/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetInput;
import com.oracle.bmc.recovery.model.UpdateProtectedDatabaseDetails;
import com.oracle.bmc.recovery.responses.UpdateProtectedDatabaseResponse;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.VpcUser;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleSecretStoreException;

public class UpdateProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    private boolean updatePassword;
    private String protectionPolicyId;
    private List<RecoveryServiceSubnetInput> recoverySubnets = new ArrayList<RecoveryServiceSubnetInput>();
    private int databaseSizeInGbs;
    private boolean realtimeRedo;

    public UpdateProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("update protected database", command, conn, ctx);
        Result optionsCheck = this.checkOptions();
        if (!optionsCheck.getStatus().equals((Object)Status.SUCCESS)) {
            throw new IllegalArgumentException(optionsCheck.getMessage());
        }
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new CallControlPlane());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        this.protectionPolicyId = (String)command.getOptionValue((Id)RCVOptions.Options.PROTECTION_POLICY_ID);
        List subnets = (List)command.getOptionValue((Id)RCVOptions.Options.RECOVERY_SERVICE_SUBNETS);
        if (subnets != null) {
            for (String id : subnets) {
                this.recoverySubnets.add(RecoveryServiceSubnetInput.builder().recoveryServiceSubnetId(id).build());
            }
        }
        if (command.getOptionValue((Id)RCVOptions.Options.DATABASE_SIZE) != null) {
            this.databaseSizeInGbs = (Integer)command.getOptionValue((Id)RCVOptions.Options.DATABASE_SIZE);
        }
        this.updatePassword = command.isFlagSet((Id)RCVOptions.Options.PASSWORD);
    }

    public Result checkOptions() {
        ParsedCommand command = this.getCommand();
        Map options = command.getOptions();
        for (String option : options.keySet()) {
            if (options.get(option) == null) continue;
            return new Result(Status.SUCCESS);
        }
        String error = "Please provide at least one option.";
        return Result.missingOption(error);
    }

    private UpdateProtectedDatabaseDetails getUpdateProtectedDatabaseDetails(String password) {
        ParsedCommand command = this.getCommand();
        UpdateProtectedDatabaseDetails.Builder bodyBuilder = UpdateProtectedDatabaseDetails.builder();
        if (this.protectionPolicyId != null) {
            bodyBuilder.protectionPolicyId(this.protectionPolicyId);
        }
        if (!this.recoverySubnets.isEmpty()) {
            bodyBuilder.recoveryServiceSubnets(this.recoverySubnets);
        }
        if (this.databaseSizeInGbs > 0) {
            bodyBuilder.databaseSizeInGBs(Integer.valueOf(this.databaseSizeInGbs));
        }
        if (command.getOptionValue((Id)RCVOptions.Options.REALTIME_REDO) != null) {
            bodyBuilder.isRedoLogsShipped((Boolean)command.getOptionValue((Id)RCVOptions.Options.REALTIME_REDO));
        }
        if (password != null && !password.isEmpty()) {
            bodyBuilder.password(password);
        }
        return bodyBuilder.build();
    }

    @Override
    public void handleFailure() {
    }

    private class CallControlPlane
    implements UnitOfWork {
        private CallControlPlane() {
        }

        @Override
        public Result run() {
            Logger logger = UpdateProtectedDatabaseWorkflow.this.getLogger();
            ParsedCommand command = UpdateProtectedDatabaseWorkflow.this.getCommand();
            ProtectedDatabaseMetadata metadata = UpdateProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            String protectedDatabaseId = metadata.getOcid();
            String password = null;
            if (UpdateProtectedDatabaseWorkflow.this.updatePassword) {
                password = new String(Utils.promptAndConfirmPassword("Enter a new password for VPC user:", "Confirm new password for VPC user:"));
            }
            ZRCVClientManager zrcvClientManager = RCVCommand.createZrcvClientManager(logger);
            UpdateProtectedDatabaseDetails updateProtectedDatabaseDetails = UpdateProtectedDatabaseWorkflow.this.getUpdateProtectedDatabaseDetails(password);
            try {
                UpdateProtectedDatabaseResponse response = zrcvClientManager.updateProtectedDatabase(updateProtectedDatabaseDetails, protectedDatabaseId);
                int httpStatusCode = response.get__httpStatusCode__();
                if (httpStatusCode < 200 || httpStatusCode >= 300) {
                    logger.log(Level.FINE, "Failed to update protected database " + metadata.getOcid());
                    return Result.updProtectedDatabaseHttpError("Failed to update protected database " + protectedDatabaseId);
                }
                logger.log(Level.FINE, "Waiting for protected database state to change to Active...");
                ProtectedDatabase db = zrcvClientManager.waitForProtectedDatabaseUpdate(protectedDatabaseId, 300, 5);
                if (!db.getLifecycleState().equals((Object)LifecycleState.Active)) {
                    String error = "Timed out waiting for update protected database to become active" + protectedDatabaseId;
                    logger.log(Level.FINE, error);
                    return Result.updProtectedDatabaseStatusTmt(error);
                }
                logger.log(Level.FINE, "Successfully updated protected database.");
            }
            catch (Exception e) {
                UpdateProtectedDatabaseWorkflow.this.logException(e);
                return Result.updProtectedDatabaseCallError("Failed to update protected database settings.");
            }
            if (password != null && !password.isEmpty()) {
                VpcUser vpcUser = new VpcUser(metadata.getVpcUserName(), password);
                try {
                    vpcUser.storePassword(metadata.getWalletLocation(), metadata.getCredentialAlias());
                }
                catch (IOException | OracleSecretStoreException e) {
                    UpdateProtectedDatabaseWorkflow.this.logException(e);
                    String error = String.format("Failed to update the VPC password in wallet: %s", metadata.getWalletLocation());
                    return Result.updVpcWalletError(error);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }
}

