/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.Metrics;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.rest.OCIClientManager;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    private ZRCVClientManager zrcvClientManager;

    public ShowProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("show protected_database", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new ShowProtectedDatabase());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        String endpoint = (String)command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        GlobalMetadata globalMetadata = GlobalMetadata.load();
        if (endpoint == null) {
            if (globalMetadata.getRecoveryServiceEndpoint() != null) {
                endpoint = globalMetadata.getRecoveryServiceEndpoint();
            } else if (globalMetadata.getSystemType().equals("OCI")) {
                endpoint = OCIClientManager.getRecoveryServiceEndpoint();
                globalMetadata.setRecoveryServiceEndpoint(endpoint);
                try {
                    globalMetadata.save();
                }
                catch (IOException e) {
                    this.getLogger().log(Level.FINE, "Failed to save global metadata in " + GlobalMetadata.getMetadataFile());
                }
            } else {
                throw new IllegalArgumentException("Please provide the recovery service endpoint using --endpoint <endpoint>!");
            }
        }
        this.zrcvClientManager = new ZRCVClientManager(globalMetadata.getAuthentication(), endpoint, this.getLogger());
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        globalMetadata.setRecoveryServiceEndpoint(endpoint);
    }

    private class ShowProtectedDatabase
    implements UnitOfWork {
        private ShowProtectedDatabase() {
        }

        @Override
        public Result run() {
            ProtectedDatabase protectedDatabase;
            String dbUniqueName = ShowProtectedDatabaseWorkflow.this.getDbUniqueName();
            ProtectedDatabaseMetadata metadata = ShowProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            Logger logger = ShowProtectedDatabaseWorkflow.this.getLogger();
            String protectedDatabaseId = ShowProtectedDatabaseWorkflow.this.getProtectedDatabaseOcid();
            if (protectedDatabaseId != null) {
                metadata.setOcid(protectedDatabaseId);
            }
            if ((protectedDatabase = ShowProtectedDatabaseWorkflow.this.zrcvClientManager.getProtectedDatabase(protectedDatabaseId)) == null) {
                logger.log(Level.INFO, "Database is not onboarded to Recovey Service. Please run 'rcv add protected_database' to onboard it.");
                return new Result(Status.SUCCESS);
            }
            Metrics metrics = protectedDatabase.getMetrics();
            logger.log(Level.INFO, "DB Unique Name:    " + protectedDatabase.getDbUniqueName());
            logger.log(Level.INFO, "Display Name:      " + protectedDatabase.getDisplayName());
            logger.log(Level.INFO, "OCID:              " + protectedDatabase.getId());
            logger.log(Level.INFO, "Status:            " + String.valueOf(protectedDatabase.getLifecycleState()));
            logger.log(Level.INFO, "VPC User:          " + protectedDatabase.getVpcUserName());
            logger.log(Level.INFO, "Real-time Redo:    " + protectedDatabase.getIsRedoLogsShipped());
            logger.log(Level.INFO, "Protection Policy: " + protectedDatabase.getProtectionPolicyId());
            logger.log(Level.INFO, "Health:            " + String.valueOf(protectedDatabase.getHealth()));
            logger.log(Level.INFO, "Health Details:    " + protectedDatabase.getHealthDetails());
            logger.log(Level.INFO, "Metrics:");
            logger.log(Level.INFO, "\tMinimum Recovery Time:     " + metrics.getMinimumRecoveryNeededInDays() + " days");
            logger.log(Level.INFO, "\tUnprotected Window:        " + metrics.getUnprotectedWindowInSeconds() + " seconds");
            return new Result(Status.SUCCESS);
        }
    }
}

