/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.dbtools.extension.rcv.workflows.Status;

public class Result {
    private Status status;
    private String message;
    private String error_code;
    public static final String ERR_PREFIX = "Error";
    private static final String ERR_CODE_BASE = "RCV";
    public static final String FA_UNHANDLED_EXCEPTION = "00005";
    private static final String WF_INVALID_OPTION = "00010";
    private static final String WF_MISSING_OPTION = "00011";
    public static final String WF_UNHANDLED_EXCEPTION = "00015";
    public static final String WF_GET_CLIENT_CONF_ERROR = "00017";
    public static final String WF_INIT_ERROR = "00018";
    public static final String WF_UPDATE_CLIENT_CONF_ERROR = "00025";
    public static final String WF_FETCH_DATABASE_CONFIG_EXCEPTION = "00026";
    private static final String PD_DB_NOT_ONBOARDED = "00028";
    private static final String APD_METADATA_EXCEPTION = "00030";
    private static final String APD_PRECHECK_ERROR = "00033";
    private static final String APD_CHECK_DB_EXIST_OCI_ERROR = "00035";
    private static final String APD_ONBOARD_DB_ERROR = "00040";
    private static final String APD_DB_NOT_ONBOARDED_ERROR = "00043";
    private static final String APD_VPC_USER_WALLET_ERROR = "00047";
    private static final String APD_LIFECYCLE_GET_STATUS = "00048";
    private static final String APD_LIFECYCLE_STATUS_TMT = "00049";
    private static final String APD_LIFECYCLE_STATUS_ERROR = "00050";
    private static final String APD_GET_CATALOG_ALIAS_ERROR = "00054";
    private static final String APD_UPD_WALLET_ALIAS_ERROR = "00055";
    private static final String APD_REGISTER_DB_META_ERROR = "00058";
    private static final String APD_REGISTER_DB_ERROR = "00059";
    private static final String APD_REGISTER_DB_ERROR2 = "00060";
    private static final String APD_CONF_PROT_DB_ERROR = "00063";
    private static final String APD_SAVE_METADATA_ERROR = "00066";
    private static final String CPD_FLEET_ENGINE_CONNECTION_EXP = "00080";
    private static final String CPD_UPDATE_ERROR = "00081";
    private static final String CPD_UPDATE_ERROR2 = "00083";
    private static final String RPD_INIT_REMOVE_DB_ERROR = "00110";
    private static final String RPD_REMOVE_DB_ERROR = "00111";
    private static final String RPD_WAIT_TMT = "00112";
    private static final String RPD_LIFECYCLE_ERROR = "00113";
    private static final String RPD_RM_METADATA_ERROR = "00115";
    private static final String BPD_LOGMODE_ERROR = "00120";
    private static final String BPD_FE_CONNECTION_ERROR = "00121";
    private static final String BPD_DB_BACKUP_ERROR = "00122";
    private static final String UPD_HTTP_CALL_ERROR = "00143";
    private static final String UPD_DB_STATUS_TMT = "00146";
    private static final String UPD_CLIENT_CALL_ERROR = "00149";
    private static final String UPD_VPC_WALLET_ERROR = "00151";
    private static final String CHW_CHECKS_ERROR = "00170";
    private static final String UCW_UPDATE_CLIENT_CONF_ERROR = "00190";
    private static final String UCW_GET_ALIASES_ERROR = "00191";
    private static final String UCW_QUERY_WALLET_ERROR = "00192";
    private static final String UCW_GET_VPCUSER_ERROR = "00193";
    private static final String UCW_GET_VPCUSER_DATA_ERROR = "00194";
    private static final String UCW_UPD_VPCUSER_DATA_ERROR = "00195";
    private static final String FTW_INIT_ERROR = "00200";
    private static final String FTW_RMAN_SCRIPT_ERROR = "00201";
    private static final String FTW_DB_NOT_CONFIGURED_ERROR = "00202";
    private static final String FTW_DB_NOT_REGISTERED_ERROR = "00203";
    private static final String FTW_INCORRECT_ACTION_ERROR = "00204";
    private static final String FTW_TASK_EXPIRED_ERROR = "00205";
    private static final String FTW_TASK_UNKNOWN_ERROR = "00206";
    private static final String FTW_UNHANDLED_ERROR = "00210";
    private static final String ERR_INIT_UPDATE_EXCEPTION = "00230";
    private static final String ERR_INIT_LOG_CONFIG_EXCEPTION = "00231";
    private static final String ERR_INIT_LOG_DEST_EXCEPTION = "00232";
    private static final String ERR_INIT_LOG_DEST_DB_EXCEPTION = "00233";
    private static final String ERR_CHECK_PDB_ERROR = "00240";
    private static final String ERR_CHECK_REDO_USER_ERROR = "00241";
    private static final String ERR_CHECK_WALLET_ERROR = "00242";
    private static final String ERR_CONFIG_WALLET_ERROR = "00245";
    private static final String ERR_CONFIG_TNSNAMES_ERROR = "00248";
    private static final String ERR_CONFIG_SQLNET_ERROR = "00251";
    private static final String ERR_VERIFY_DB_CONNECTION_ERROR = "00254";
    private static final String ERR_VERIFY_BACKUP_EXISTS_ERROR = "00257";
    private static final String ERR_CONF_LOG_DEST_FREE_ERROR = "00260";
    private static final String ERR_CONF_LOG_DEST_STATE_ERROR = "00261";
    private static final String ERR_CONF_LOG_DEST_UPDATE_ERROR = "00262";
    private static final String ERR_CONF_REDO_USER_ERROR = "00265";
    private static final String ERR_CONF_REDO_USER_UPDATE_ERROR = "00266";
    private static final String DRR_INIT_LOG_CONFIG_EXCEPTION = "00280";
    private static final String DRR_CHECK_PDB_ERROR = "00283";
    private static final String DRR_LOG_DEST_GET_ERROR = "00286";
    private static final String DRR_LOG_DEST_UPDATE_ERROR = "00287";
    private static final String DRR_REDO_USER_UPDATE_ERROR = "00290";
    private static final String DRR_TNSNAMES_UPDATE_ERROR = "00290";
    private static final String DRR_SQLNET_UPDATE_ERROR = "00293";
    private static final String UAW_METADATA_ERROR = "00300";
    private static final String UAW_VALIDATE_AUTH_ERROR = "00303";
    private static final String UAW_METADATA_UPDATE_ERROR = "00306";
    private static final String ASS_CREATE_SS_ERROR = "00310";
    private static final String ASS_GET_SS_STATE_ERROR = "00313";
    private static final String ASS_SS_LIFECYCLE_STATUS_TMT = "00314";
    private static final String ASS_SS_LIFECYCLE_STATUS_ERROR = "00315";
    private static final String METADATA_FILE_OPEN_EXCEPTION = "00500";
    private static final String METADATA_JSON_PROCESSING_EXCEPTION = "00501";
    private static final String METADATA_GLOBAL_DIR_EXCEPTION = "00502";
    private static final String METADATA_FILE_SAVE_EXCEPTION = "00503";
    private static final String METADATA_STATE_EXCEPTION = "00504";
    private static final String PDB_METADATA_LOAD_EXCEPTION = "00510";
    private static final String PDB_METADATA_SAVE_EXCEPTION = "00511";
    private static final String PDB_METADATA_SAVE_ERROR = "00512";
    private static final String WALLET_CREATE_WALLET_EXCEPTION = "00550";
    private static final String WALLET_ADD_CREDENTIAL_EXCEPTION = "00551";
    private static final String WALLET_WALLET_WORK_EXCEPTION = "00552";
    private static final String RCVS_GET_PROTECTED_DATABASE_EXCEPTION = "00601";
    private static final String RCVS_GET_PROTECTION_POLICY_EXCEPTION = "00603";
    private static final String OCI_DATABASE_API_EXCEPTION = "00650";
    private static final Map<String, List<String>> action = Map.ofEntries(Map.entry("00005", List.of("Cause: Unexpected error.", "Action: Check the log message or log file for more information. Contact Oracle Support.")), Map.entry("00010", List.of("Cause: An option was specified incorrectly.", "Action: Please verify the command syntax and ensure all options are valid.")), Map.entry("00011", List.of("Cause: A required option is missing.", "Action: Please check the command syntax and include all mandatory options.")), Map.entry("00015", List.of("Cause: Unexpected error.", "Action: Check the log message or log file for more information. Contact Oracle Support.")), Map.entry("00018", List.of("Cause: On of the steps in the initialization process failed.", "Action: Troubleshoot it and try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00017", List.of("Cause: The agent failed to get or process the protected database configuration.", "Action: This message should be accompanied by other error messages indicating the cause of the error. If call to the cloud API failed, verity network connectivity to the cloud endpoint.If there is a filesystem error, troubleshoot it. Try to restart the command in both cases.")), Map.entry("00025", List.of("Cause: The agent failed to update the protected database configuration locally.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely it's a filesystem error, troubleshoot it. Try to restart the command.")), Map.entry("00026", List.of("Cause: The agent failed to download the protected database configuration.", "Action: Check the log file for more information on why call to the cloud API has failed. The log file can contain links to further troubleshoot the API failure. Try to restart the command.")), Map.entry("00028", List.of("Cause: Database has not been found to be onboarded to ZDL Recovery Cloud Service.", "Action: Please run 'rcv add protected_database' first.")), Map.entry("00030", List.of("Cause: Database has not been found to be onboarded to ZDL Recovery Cloud Service.", "Action: Please provide an OCID for the desired protection policy using --protection_policy_id <ocid>. ")), Map.entry("00033", List.of("Cause: One of the checks failed.", "Action: 1) You need to use compatible version of the database. 2) Transparent Data Encryption (TDE) is not configured in the database ")), Map.entry("00035", List.of("Cause: Failed to get information about the database.", "Action: This message should be accompanied by other error messages indicating the cause of the error. If it's a cloud configuration, most likely call to cloud API failed. Try to restart the command.")), Map.entry("00040", List.of("Cause: Failed to onboard protected database to a cloud service.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely call to the cloud API failed. Try to restart the command.")), Map.entry("00043", List.of("Cause: Internal error in the workflow process.", "Action: Try to restart the command. Contact Oracle Support.")), Map.entry("00047", List.of("Cause: The operation on the wallet has failed.", "Action: Check the log message or log file for more information. Try to restart the command.")), Map.entry("00048", List.of("Cause: The call to the cloud API failed, or the request timed out.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, a call to the cloud API failed. Try to restart the command.")), Map.entry("00049", List.of("Cause: Status of the protected database is not what is expected.", "Action: Probably it takes more time than expected to create the protected database. Try to restart the command after waiting for 10 minutes.")), Map.entry("00050", List.of("Cause: Status of the protected database is not what is expected.", "Action: Unexpected error. Contact Oracle Support.")), Map.entry("00054", List.of("Cause: The agent failed to get configuration data.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely it's a filesystem error, troubleshoot it. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00055", List.of("Cause: The agent failed to update user credentials in a wallet.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, it's a filesystem-related error. Troubleshoot it. ")), Map.entry("00058", List.of("Cause: The agent failed to find user name in the metadata.", "Action: Unexpected error. Contact Oracle Support.")), Map.entry("00059", List.of("Cause: The agent failed to register database using RMAN.", "Action: Check provided the log file for more information.Try to restart the command.")), Map.entry("00060", List.of("Cause: The agent failed to register database using RMAN.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, execution of the RMAN command failed with a system error. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00066", List.of("Cause: The agent failed to save internal state to the disk.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, it's a filesystem-related error. Troubleshoot it. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00080", List.of("Cause: The agent failed to establish a database connection.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, configured Recovery Appliance is not available. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00081", List.of("Cause: The agent failed to update a configuration on the Recovery Appliance.", "Action: Internal communication error. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00083", List.of("Cause: The agent failed to update a configuration on the Recovery Appliance.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, configured Recovery Appliance is not available. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00110", List.of("Cause: Command failed initialization.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, it's a filesystem-related error. Troubleshoot it. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00111", List.of("Cause: The call to the cloud API failed.", "Action: This message should be accompanied by other error messages indicating the cause of the error. If call to the cloud API failed, verity network connectivity to the cloud endpoint, check that authentication is valid. Check the log file for more information. Try to restart the command.")), Map.entry("00112", List.of("Cause: The agent timed out while waiting for the required status to be set for the protected database.", "Action: Probably it takes more time than expected to create the protected database. Try to restart the command after waiting for some time.")), Map.entry("00113", List.of("Cause: The protected database has entered an incorrect lifecycle state.", "Action: Unexpected state, contact Oracle Support.")), Map.entry("00115", List.of("Cause: The agent failed to delete directory.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, it's a filesystem-related error. Troubleshoot it. Directory can be removed manually if it's not removed.")), Map.entry("00120", List.of("Cause: The agent detected that the protected database is in 'NOARCHIVELOG' log mode.", "Action: Change the log mode to 'ARCHIVELOG' to proceed with the backups.")), Map.entry("00143", List.of("Cause: The call to the cloud API failed.", "Action: This message should be accompanied by other error messages indicating the cause of the error. If call to the cloud API failed, verity network connectivity to the cloud endpoint, check that authentication is valid. Check the log file for more information. Try to restart the command.")), Map.entry("00146", List.of("Cause: The agent timed out while waiting for the required status to be set for the protected database.", "Action: Probably it takes more time than expected to update the protected database settings. Try to restart the command.")), Map.entry("00149", List.of("Cause: The call to the cloud API failed.", "Action: This message should be accompanied by other error messages indicating the cause of the error. If call to the cloud API failed, verity network connectivity to the cloud endpoint. Check the log file for more information. Try to restart the command.")), Map.entry("00151", List.of("Cause: The agent failed to store VPC user credentials.", "Action: This message should be accompanied by other error messages indicating the cause of the error. Most likely, it's a filesystem-related error. Troubleshoot it. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00170", List.of("Cause: One of the checks has failed.", "Action: This message will be accompanied by other status messages indicating while the check has failed. The error message should be self-explationary. If there are any question about it, please contact Oracle Support.")), Map.entry("00192", List.of("Cause: Failed to get data from the wallet.", "Action: This message should be accompanied by other error messages indicating the cause of the error. If it's a filesystem-related error, troubleshoot it. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00193", List.of("Cause: Failed to get data from the wallet.", "Action: This message should be accompanied by other error messages indicating the cause of the error. If call to the cloud API failed, verity network connectivity to the cloud endpoint. Check the log file for more information. If it's a filesystem-related error, troubleshoot it. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00500", List.of("Cause: Failed to open metadata file.", "Action: Check permissions on the specified file, so that agent process can read it. If file is not found, contact Oracle Support.")), Map.entry("00501", List.of("Cause: Failed to process metadata file.", "Action: Check that file is a valid JSON file.")), Map.entry("00502", List.of("Cause: Failed to create directory to hold metadata.", "Action: Check that directory can be created in the specified location.")), Map.entry("00503", List.of("Cause: Failed to save metadata file.", "Action: Check permissions on the specified file and the parent directory.")), Map.entry("00504", List.of("Cause: Internal metadata is not fully updated.", "Action: Please provide the recovery service endpoint using 'rcv add protected_database.")), Map.entry("00510", List.of("Cause: Failed to read file because of filesystem error.", "Action: Check permissions on the specified path, so that the backup process can read the metadata file.")), Map.entry("00511", List.of("Cause: Failed to save file because of filesystem error.", "Action: Check permissions on the specified path, so that the backup process can write to the metadata file.")), Map.entry("00512", List.of("Cause: Failed to save file because of filesystem error.", "Action: Check permissions on the specified path, so that the backup process can write to the metadata file.")), Map.entry("00550", List.of("Cause: Failed to create a wallet in the filesystem.", "Action: Check permissions on the specified path, so that the backup process can create a wallet. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00551", List.of("Cause: Failed to add credential to a wallet.", "Action: Check permissions on the specified path, so that the backup process can update a wallet. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00552", List.of("Cause: The operation on the wallet has failed.", "Action: Check permissions on the specified path, so that the backup process can read the wallet. Try to restart the command. If error persist, contact Oracle Support.")), Map.entry("00601", List.of("Cause: The call to the cloud API to get details about the protected database failed.", "Action: Check the log message and the log file for more information. The log file can contain links to further troubleshoot the API failure.")), Map.entry("00603", List.of("Cause: The call to the cloud API to get details about the protection policy failed.", "Action: Check the log message and the log file for more information. The log file can contain links to further troubleshoot the API failure.")), Map.entry("00650", List.of("Cause: The call to the cloud API has failed.", "Action: Check the log message and the log file for more information. The log file can contain links to further troubleshoot the API failure.")));

    public Result() {
        this.status = Status.NOT_STARTED;
    }

    public Result(Status status) {
        this.status = status;
    }

    public Result(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Result(Status status, String message, String error_code) {
        this(status, message);
        this.error_code = error_code;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        if (this.error_code != null && !Result.isHandled(this.message)) {
            this.message = Result.getMessage(this.message, this.error_code);
        }
        return this.message;
    }

    public static String getMessage(String msg, String code) {
        return String.format("%s: %s-%s: %s", ERR_PREFIX, ERR_CODE_BASE, code, msg);
    }

    public static boolean isHandled(String message) {
        boolean result = message.matches("(?s)^Error: RCV-\\d+.*");
        return result;
    }

    public String getAction() {
        if (this.error_code == null) {
            return "";
        }
        Stream<CharSequence> stream = action.containsKey(this.error_code) ? action.get(this.error_code).stream() : Stream.empty();
        return stream.collect(Collectors.joining(System.lineSeparator()));
    }

    public static String getAction(String msg) {
        Pattern pattern = Pattern.compile("^Error: RCV-(\\d{5})");
        Matcher matcher = pattern.matcher(msg);
        if (!matcher.find()) {
            return "";
        }
        String error_code = matcher.group(1);
        Stream<CharSequence> stream = action.containsKey(error_code) ? action.get(error_code).stream() : Stream.empty();
        return stream.collect(Collectors.joining(System.lineSeparator()));
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static Result invalidOption(String msg) {
        return new Result(Status.FAILED, msg, WF_INVALID_OPTION);
    }

    public static Result missingOption(String msg) {
        return new Result(Status.FAILED, msg, WF_MISSING_OPTION);
    }

    public static Result wfGetClientConfError(String msg) {
        return new Result(Status.FAILED, msg, WF_GET_CLIENT_CONF_ERROR);
    }

    public static Result wfInitError(String msg) {
        return new Result(Status.FAILED, msg, WF_INIT_ERROR);
    }

    public static Result wfUpdateClientConfError(String msg) {
        return new Result(Status.FAILED, msg, WF_UPDATE_CLIENT_CONF_ERROR);
    }

    public static RuntimeException wfFetchProtectedDatabaseConfigurationException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, WF_FETCH_DATABASE_CONFIG_EXCEPTION), e);
    }

    public static Result databaseNotOnboarded(String msg) {
        return new Result(Status.FAILED, msg, PD_DB_NOT_ONBOARDED);
    }

    public static RuntimeException apdMetadataInitException(String msg) {
        return new RuntimeException(Result.getMessage(msg, APD_METADATA_EXCEPTION));
    }

    public static Result apdPrecheckError(String msg) {
        return new Result(Status.FAILED, msg, APD_PRECHECK_ERROR);
    }

    public static Result apdCheckDbExistOciError(String msg) {
        return new Result(Status.FAILED, msg, APD_CHECK_DB_EXIST_OCI_ERROR);
    }

    public static Result apdOnboardDbError(String msg) {
        return new Result(Status.FAILED, msg, APD_ONBOARD_DB_ERROR);
    }

    public static Result apdDbNotOnboarded(String msg) {
        return new Result(Status.FAILED, msg, APD_DB_NOT_ONBOARDED_ERROR);
    }

    public static Result apdVpcUserWalletError(String msg) {
        return new Result(Status.FAILED, msg, APD_VPC_USER_WALLET_ERROR);
    }

    public static Result apdLifecycleGetStatusError(String msg) {
        return new Result(Status.TIMED_OUT, msg, APD_LIFECYCLE_GET_STATUS);
    }

    public static Result apdLifecycleStatusTmt(String msg) {
        return new Result(Status.TIMED_OUT, msg, APD_LIFECYCLE_STATUS_TMT);
    }

    public static Result apdVerifyLifecycleStatusError(String msg) {
        return new Result(Status.FAILED, msg, APD_LIFECYCLE_STATUS_ERROR);
    }

    public static Result apdGetCatalogAliasError(String msg) {
        return new Result(Status.FAILED, msg, APD_GET_CATALOG_ALIAS_ERROR);
    }

    public static Result apdUpdateWalletWithAliasError(String msg) {
        return new Result(Status.FAILED, msg, APD_UPD_WALLET_ALIAS_ERROR);
    }

    public static Result apdVpcUserMetadataError(String msg) {
        return new Result(Status.FAILED, msg, APD_REGISTER_DB_META_ERROR);
    }

    public static Result apdRegisterDbError(String msg) {
        return new Result(Status.FAILED, msg, APD_REGISTER_DB_ERROR);
    }

    public static Result apdRegisterDbError2(String msg) {
        return new Result(Status.FAILED, msg, APD_REGISTER_DB_ERROR2);
    }

    public static Result apdConfigureProtDbError(String msg) {
        return new Result(Status.FAILED, msg, APD_CONF_PROT_DB_ERROR);
    }

    public static Result apdSaveMetadataError(String msg) {
        return new Result(Status.FAILED, msg, APD_SAVE_METADATA_ERROR);
    }

    public static RuntimeException cpdFleetAgentConnectionException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, CPD_FLEET_ENGINE_CONNECTION_EXP), e);
    }

    public static Result cpdUpdateError(String msg) {
        return new Result(Status.FAILED, msg, CPD_UPDATE_ERROR);
    }

    public static Result cpdUpdateError2(String msg) {
        return new Result(Status.FAILED, msg, CPD_UPDATE_ERROR2);
    }

    public static Result rpdInitRemoveProtectedDbError(String msg) {
        return new Result(Status.FAILED, msg, RPD_INIT_REMOVE_DB_ERROR);
    }

    public static Result rpdRemoveProtectedDbError(String msg) {
        return new Result(Status.FAILED, msg, RPD_REMOVE_DB_ERROR);
    }

    public static Result rpdRemoveProtectedDbTmt(String msg) {
        return new Result(Status.TIMED_OUT, msg, RPD_WAIT_TMT);
    }

    public static Result rpdRemoveLifecycleError(String msg) {
        return new Result(Status.FAILED, msg, RPD_LIFECYCLE_ERROR);
    }

    public static Result rpdRemoveMetadataError(String msg) {
        return new Result(Status.FAILED, msg, RPD_RM_METADATA_ERROR);
    }

    public static Result bpdLogmodeError(String msg) {
        return new Result(Status.FAILED, msg, BPD_LOGMODE_ERROR);
    }

    public static Result bpdFeConnectionError(String msg) {
        return new Result(Status.FAILED, msg, BPD_FE_CONNECTION_ERROR);
    }

    public static Result bpdDbBackupError(String msg) {
        return new Result(Status.FAILED, msg, BPD_DB_BACKUP_ERROR);
    }

    public static Result updProtectedDatabaseHttpError(String msg) {
        return new Result(Status.FAILED, msg, UPD_HTTP_CALL_ERROR);
    }

    public static Result updProtectedDatabaseStatusTmt(String msg) {
        return new Result(Status.FAILED, msg, UPD_DB_STATUS_TMT);
    }

    public static Result updProtectedDatabaseCallError(String msg) {
        return new Result(Status.FAILED, msg, UPD_CLIENT_CALL_ERROR);
    }

    public static Result updVpcWalletError(String msg) {
        return new Result(Status.FAILED, msg, UPD_VPC_WALLET_ERROR);
    }

    public static Result chwChecksError(String msg) {
        return new Result(Status.FAILED, msg, CHW_CHECKS_ERROR);
    }

    public static Result ucwUpdateClientConfError(String msg) {
        return new Result(Status.FAILED, msg, UCW_UPDATE_CLIENT_CONF_ERROR);
    }

    public static Result ucwGetAliasesError(String msg) {
        return new Result(Status.FAILED, msg, UCW_GET_ALIASES_ERROR);
    }

    public static Result ucwGetVpcUserError(String msg) {
        return new Result(Status.FAILED, msg, UCW_GET_VPCUSER_ERROR);
    }

    public static Result ucwGetVpcUserPwdError(String msg) {
        return new Result(Status.FAILED, msg, UCW_GET_VPCUSER_DATA_ERROR);
    }

    public static Result ucwUpdateVpcUserPwdError(String msg) {
        return new Result(Status.FAILED, msg, UCW_UPD_VPCUSER_DATA_ERROR);
    }

    public static Result ucwQueryWalletError(String msg) {
        return new Result(Status.FAILED, msg, UCW_QUERY_WALLET_ERROR);
    }

    public static Result ftwInitError(String msg) {
        return new Result(Status.FAILED, msg, FTW_INIT_ERROR);
    }

    public static Result ftwRmanScriptError(String msg) {
        return new Result(Status.FAILED, msg, FTW_RMAN_SCRIPT_ERROR);
    }

    public static Result ftwDbNotConfiguredError(String msg) {
        return new Result(Status.FAILED, msg, FTW_DB_NOT_CONFIGURED_ERROR);
    }

    public static Result ftwDbNotRegisteredError(String msg) {
        return new Result(Status.FAILED, msg, FTW_DB_NOT_REGISTERED_ERROR);
    }

    public static Result ftwIncorrectActionError(String msg) {
        return new Result(Status.FAILED, msg, FTW_INCORRECT_ACTION_ERROR);
    }

    public static Result ftwTaskExpiredError(String msg) {
        return new Result(Status.FAILED, msg, FTW_TASK_EXPIRED_ERROR);
    }

    public static Result ftwTaskUnknownError(String msg) {
        return new Result(Status.FAILED, msg, FTW_TASK_UNKNOWN_ERROR);
    }

    public static Result ftwUnhandledError(String msg) {
        return new Result(Status.FAILED, msg, FTW_UNHANDLED_ERROR);
    }

    public static RuntimeException errInitUpdateException(String msg) {
        return new RuntimeException(Result.getMessage(msg, ERR_INIT_UPDATE_EXCEPTION));
    }

    public static RuntimeException errInitLogConfigException(String msg) {
        return new RuntimeException(Result.getMessage(msg, ERR_INIT_LOG_CONFIG_EXCEPTION));
    }

    public static RuntimeException errInitLogDestException(String msg) {
        return new RuntimeException(Result.getMessage(msg, ERR_INIT_LOG_DEST_EXCEPTION));
    }

    public static RuntimeException errInitLogDestDbException(String msg) {
        return new RuntimeException(Result.getMessage(msg, ERR_INIT_LOG_DEST_DB_EXCEPTION));
    }

    public static Result errCheckPdbError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CHECK_PDB_ERROR);
    }

    public static Result errCheckRedoUserError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CHECK_REDO_USER_ERROR);
    }

    public static Result errCheckWalletError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CHECK_WALLET_ERROR);
    }

    public static Result errConfigWalletError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CONFIG_WALLET_ERROR);
    }

    public static Result errConfigTnsError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CONFIG_TNSNAMES_ERROR);
    }

    public static Result errConfigSqlError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CONFIG_SQLNET_ERROR);
    }

    public static Result errVerifyDbConnectionError(String msg) {
        return new Result(Status.FAILED, msg, ERR_VERIFY_DB_CONNECTION_ERROR);
    }

    public static Result errVerifyBackupExistsError(String msg) {
        return new Result(Status.FAILED, msg, ERR_VERIFY_BACKUP_EXISTS_ERROR);
    }

    public static Result errConfLogDestFreeError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CONF_LOG_DEST_FREE_ERROR);
    }

    public static Result errConfLogDestStateError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CONF_LOG_DEST_STATE_ERROR);
    }

    public static Result errConfLogDestUpdateError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CONF_LOG_DEST_UPDATE_ERROR);
    }

    public static Result errConfRedoUserError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CONF_REDO_USER_ERROR);
    }

    public static Result errConfRedoUserUpdateError(String msg) {
        return new Result(Status.FAILED, msg, ERR_CONF_REDO_USER_UPDATE_ERROR);
    }

    public static RuntimeException drrInitLogConfigException(String msg) {
        return new RuntimeException(Result.getMessage(msg, DRR_INIT_LOG_CONFIG_EXCEPTION));
    }

    public static Result drrCheckPdbError(String msg) {
        return new Result(Status.FAILED, msg, DRR_CHECK_PDB_ERROR);
    }

    public static Result drrLogDestGetError(String msg) {
        return new Result(Status.FAILED, msg, DRR_LOG_DEST_GET_ERROR);
    }

    public static Result drrLogDestUpdateError(String msg) {
        return new Result(Status.FAILED, msg, DRR_LOG_DEST_UPDATE_ERROR);
    }

    public static Result drrRedoUserUpdateError(String msg) {
        return new Result(Status.FAILED, msg, "00290");
    }

    public static Result drrTnsnamesUpdateError(String msg) {
        return new Result(Status.FAILED, msg, "00290");
    }

    public static Result drrSqlnetUpdateError(String msg) {
        return new Result(Status.FAILED, msg, DRR_SQLNET_UPDATE_ERROR);
    }

    public static Result uawMetadataError(String msg) {
        return new Result(Status.FAILED, msg, UAW_METADATA_ERROR);
    }

    public static Result uawValidateAuthenticationError(String msg) {
        return new Result(Status.FAILED, msg, UAW_VALIDATE_AUTH_ERROR);
    }

    public static Result uawMetadataUpdateError(String msg) {
        return new Result(Status.FAILED, msg, UAW_METADATA_UPDATE_ERROR);
    }

    public static Result assCreateServiceSubnetError(String msg) {
        return new Result(Status.FAILED, msg, ASS_CREATE_SS_ERROR);
    }

    public static Result assGetServiceSubnetStateError(String msg) {
        return new Result(Status.FAILED, msg, ASS_GET_SS_STATE_ERROR);
    }

    public static Result assLifecycleStatusTmt(String msg) {
        return new Result(Status.TIMED_OUT, msg, ASS_SS_LIFECYCLE_STATUS_TMT);
    }

    public static Result assVerifyLifecycleStatusError(String msg) {
        return new Result(Status.FAILED, msg, ASS_SS_LIFECYCLE_STATUS_ERROR);
    }

    public static RuntimeException metadataFileOpenException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, METADATA_FILE_OPEN_EXCEPTION), e);
    }

    public static RuntimeException metadataJsonProcessingException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, METADATA_JSON_PROCESSING_EXCEPTION), e);
    }

    public static RuntimeException metadataGlobalDirectoryException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, METADATA_GLOBAL_DIR_EXCEPTION), e);
    }

    public static RuntimeException metadataFileSaveException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, METADATA_FILE_SAVE_EXCEPTION), e);
    }

    public static RuntimeException metadataStateException(String msg) {
        return new RuntimeException(Result.getMessage(msg, METADATA_STATE_EXCEPTION));
    }

    public static RuntimeException pdbMetadataLoadException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, PDB_METADATA_LOAD_EXCEPTION), e);
    }

    public static RuntimeException pdbMetadataSaveException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, PDB_METADATA_SAVE_EXCEPTION), e);
    }

    public static Result pdbMetadataSaveError(String msg) {
        return new Result(Status.FAILED, msg, PDB_METADATA_SAVE_ERROR);
    }

    public static RuntimeException walletCreateWalletException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, WALLET_CREATE_WALLET_EXCEPTION), e);
    }

    public static RuntimeException walletAddCredentialException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, WALLET_ADD_CREDENTIAL_EXCEPTION), e);
    }

    public static RuntimeException walletWalletWorkException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, WALLET_WALLET_WORK_EXCEPTION), e);
    }

    public static RuntimeException rcvGetProtectedDatabaseException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, RCVS_GET_PROTECTED_DATABASE_EXCEPTION), e);
    }

    public static RuntimeException rcvGetProtectionPolicyException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, RCVS_GET_PROTECTION_POLICY_EXCEPTION), e);
    }

    public static RuntimeException ociDatabaseApiException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(msg, OCI_DATABASE_API_EXCEPTION), e);
    }
}

