/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.DisableRealtimeRedoWorkflow;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class RemoveProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    private ZRCVClientManager zrcvClientManager;
    private boolean force;
    private boolean remove = true;

    public RemoveProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("remove protected database", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new ConfirmDeletion());
        steps.add(new DisableRealtimeRedo());
        steps.add(new RemoveProtectedDatabase());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        this.force = command.isFlagSet((Id)RCVOptions.Options.FORCE);
    }

    private class ConfirmDeletion
    implements UnitOfWork {
        private ConfirmDeletion() {
        }

        @Override
        public Result run() {
            Connection conn = RemoveProtectedDatabaseWorkflow.this.getConnection();
            Logger logger = RemoveProtectedDatabaseWorkflow.this.getLogger();
            String dbUniqueName = RemoveProtectedDatabaseWorkflow.this.getDbUniqueName();
            ProtectedDatabaseMetadata metadata = RemoveProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
            String id = metadata.getOcid();
            logger.log(Level.INFO, "Protected database to remove:");
            logger.log(Level.INFO, "\tDB Unique Name: " + dbUniqueName);
            logger.log(Level.INFO, "\tOCID:           " + id);
            if (!RemoveProtectedDatabaseWorkflow.this.force) {
                logger.log(Level.INFO, "WARNING: Removing the protected database can result in data loss.");
                RemoveProtectedDatabaseWorkflow.this.remove = Utils.confirm("Are you sure you want to remove this protected database (yes/no)? ");
            }
            if (!RemoveProtectedDatabaseWorkflow.this.remove) {
                return new Result(Status.SUCCESS, "User chose to not remove the protected database. Exiting...");
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class DisableRealtimeRedo
    implements UnitOfWork {
        private DisableRealtimeRedo() {
        }

        @Override
        public Result run() {
            if (RemoveProtectedDatabaseWorkflow.this.remove) {
                Logger logger = RemoveProtectedDatabaseWorkflow.this.getLogger();
                logger.log(Level.INFO, "Check Realtime Redo Configuration");
                ScriptRunnerContext ctx = RemoveProtectedDatabaseWorkflow.this.getContext();
                Connection conn = RemoveProtectedDatabaseWorkflow.this.getConnection();
                Optional<ParsedCommand> disableRealtimeRedoCommand = Workflow.generateParsedCommand(RCVVerbs.DISABLE, RCVObjects.REALTIME_REDO, null, null, ctx);
                DisableRealtimeRedoWorkflow workflow = new DisableRealtimeRedoWorkflow(disableRealtimeRedoCommand.get(), conn, ctx);
                return workflow.run();
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RemoveProtectedDatabase
    implements UnitOfWork {
        private RemoveProtectedDatabase() {
        }

        @Override
        public Result run() {
            if (RemoveProtectedDatabaseWorkflow.this.remove) {
                ProtectedDatabase protectedDatabase;
                Logger logger = RemoveProtectedDatabaseWorkflow.this.getLogger();
                String dbUniqueName = RemoveProtectedDatabaseWorkflow.this.getDbUniqueName();
                ProtectedDatabaseMetadata metadata = RemoveProtectedDatabaseWorkflow.this.getProtectedDatabaseMetadata();
                String id = metadata.getOcid();
                String metadataDirectory = metadata.getMetadataDirectory();
                logger.log(Level.INFO, "Remove Protected Database");
                try {
                    RemoveProtectedDatabaseWorkflow.this.zrcvClientManager = RCVCommand.createZrcvClientManager(logger);
                }
                catch (Exception e) {
                    RemoveProtectedDatabaseWorkflow.this.logException(e);
                    return Result.rpdInitRemoveProtectedDbError("Initialization failed.");
                }
                try {
                    protectedDatabase = RemoveProtectedDatabaseWorkflow.this.zrcvClientManager.waitForRemoveProtectedDatabase(id);
                }
                catch (Exception e) {
                    RemoveProtectedDatabaseWorkflow.this.logException(e);
                    return Result.rpdRemoveProtectedDbError("Failed to remove protected database.");
                }
                LifecycleState state = protectedDatabase.getLifecycleState();
                if (!state.equals((Object)LifecycleState.Deleted) && !state.equals((Object)LifecycleState.DeleteScheduled)) {
                    if (state.equals((Object)LifecycleState.Deleting)) {
                        String msg = "The lifecycle state is still 'Deleting'. Timed out waiting for the lifecycle state to become 'Deleted'.";
                        return Result.rpdRemoveProtectedDbTmt(msg);
                    }
                    return Result.rpdRemoveLifecycleError(String.format("The protected database's current lifecycle state is '%s', expected it to be 'ACTIVE'.", state.getValue().toUpperCase(Locale.ROOT)));
                }
                String msg = String.format("Protected database %s state is %s.", id, state.getValue());
                logger.log(Level.FINE, msg);
                RCVCommand.removeProtectedDatabaseMetadata(dbUniqueName);
                if (Files.exists(Paths.get(metadataDirectory, new String[0]), new LinkOption[0])) {
                    try {
                        Utils.deleteDirectory(metadataDirectory);
                    }
                    catch (IOException e) {
                        RemoveProtectedDatabaseWorkflow.this.logException(e);
                        return Result.rpdRemoveMetadataError("Failed to delete metadata directory " + metadataDirectory);
                    }
                }
                logger.log(Level.FINE, "Successfully deleted protected database " + metadata.getDbUniqueName());
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED);
        }
    }
}

