/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVGrammar;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.controllers.FleetEngine;
import oracle.dbtools.extension.rcv.controllers.TaskManager;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.models.commandengine.GetActionRequest;
import oracle.dbtools.extension.rcv.models.commandengine.InitRequest;
import oracle.dbtools.extension.rcv.models.commandengine.NextActionRequest;
import oracle.dbtools.extension.rcv.models.commandengine.UpdateActionStatusRequest;
import oracle.dbtools.extension.rcv.models.task.Task;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;

public class FetchTaskWorkflow
extends ProtectedDatabaseWorkflow {
    private boolean fetchLatestConfig;
    private int agentId;
    private int actionId;
    private int incorrectActionIdCount;
    private Connection fleetEngineConn;
    private int instanceId;

    public FetchTaskWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(command, conn, ctx, true);
    }

    public FetchTaskWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx, boolean fetchLatestConfig) {
        super("fetch task", command, conn, ctx);
        this.fetchLatestConfig = fetchLatestConfig;
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new ExecuteTask());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        Object error2;
        FleetEngineResponse.Status status;
        FleetEngineResponse response;
        int maxErrorCount;
        String dbUniqueName = this.getDbUniqueName();
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        Logger logger = this.getLogger();
        this.instanceId = DatabaseUtils.getInstanceId(this.getConnection());
        if (this.fetchLatestConfig) {
            Parser parser = new Parser(RCVGrammar.createType(), this.getContext().getEnvironment());
            String commandString = String.format("%s %s %s", new Object[]{RCVGrammar.Base.RCV, RCVVerbs.UPDATE, RCVObjects.ZRCV_CONFIG});
            Optional updateZRCVConfigurationCommand = parser.parse(commandString, error -> logger.log(Level.SEVERE, (String)error));
            UpdateZRCVConfigurationWorkflow wf = new UpdateZRCVConfigurationWorkflow((ParsedCommand)updateZRCVConfigurationCommand.get(), this.getConnection(), this.getContext());
            Result updateConfigResult = wf.run();
            if (!updateConfigResult.getStatus().equals((Object)Status.SUCCESS)) {
                Object error3 = "Failed to update config.";
                if (updateConfigResult.getMessage() != null) {
                    error3 = (String)error3 + "\n" + updateConfigResult.getMessage();
                }
                throw new RuntimeException((String)error3);
            }
        }
        try {
            this.fleetEngineConn = FleetEngine.getEngineConnection(metadata);
            maxErrorCount = 2;
            InitRequest initRequest = new InitRequest.Builder(this.fleetEngineConn, dbUniqueName.toUpperCase(), this.instanceId).build();
            response = FleetEngine.retry(maxErrorCount, initRequest);
            status = response.getStatus();
            if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                error2 = "Failed to initiate session with Command Engine.";
                if (response.getMessage() != null) {
                    error2 = (String)error2 + "\n" + response.getMessage();
                }
                throw new RuntimeException((String)error2);
            }
            if (response.getData() == null) {
                throw new RuntimeException("Failed to get agent ID from Command Engine: " + response.getMessage());
            }
            this.agentId = (Integer)response.getData();
            logger.log(Level.FINE, "Agent ID: " + this.agentId);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initiate session with Command Engine: " + e.getMessage());
        }
        try {
            maxErrorCount = 2;
            NextActionRequest nextActionRequest = new NextActionRequest.Builder(this.fleetEngineConn, dbUniqueName, this.agentId).build();
            response = FleetEngine.retry(maxErrorCount, nextActionRequest);
            status = response.getStatus();
            if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                error2 = "Failed to get action ID from Command Engine.";
                if (response.getMessage() != null) {
                    error2 = (String)error2 + "\n" + response.getMessage();
                }
                throw new RuntimeException((String)error2);
            }
            if (response.getData() != null) {
                this.actionId = (Integer)response.getData();
                logger.log(Level.FINE, "Action ID: " + this.actionId);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get task from Command Engine: " + e.getMessage());
        }
    }

    private class ExecuteTask
    implements UnitOfWork {
        private ExecuteTask() {
        }

        @Override
        public Result run() {
            String dbUniqueName = FetchTaskWorkflow.this.getDbUniqueName();
            ProtectedDatabaseMetadata metadata = FetchTaskWorkflow.this.getProtectedDatabaseMetadata();
            Logger logger = FetchTaskWorkflow.this.getLogger();
            FleetEngineResponse response = null;
            try {
                GetActionRequest getActionRequest = new GetActionRequest.Builder(FetchTaskWorkflow.this.fleetEngineConn, dbUniqueName, FetchTaskWorkflow.this.agentId, FetchTaskWorkflow.this.actionId).build();
                response = getActionRequest.execute();
                FleetEngineResponse.Status status = response.getStatus();
                if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                    String error = "Failed to fetch task!\nStatus: " + String.valueOf((Object)response.getStatus());
                    if (response.getMessage() != null) {
                        error = error + "\nerror message: " + response.getMessage();
                    }
                    return new Result(Status.FAILED, error);
                }
                Task task = (Task)response.getData();
                String taskLogDirectory = String.join((CharSequence)File.separator, metadata.getLogsDirectory(), "tasks");
                if (!Files.exists(Paths.get(taskLogDirectory, new String[0]), new LinkOption[0])) {
                    Files.createDirectories(Paths.get(taskLogDirectory, new String[0]), new FileAttribute[0]);
                }
                String taskLog = String.join((CharSequence)File.separator, taskLogDirectory, "task_" + task.getId() + ".log");
                logger.log(Level.INFO, "Fetching task from Recovery Service...");
                logger.log(Level.INFO, String.format("See %s for detailed output", taskLog));
                Result taskResult = TaskManager.executeTask(task, taskLog);
                if (!taskResult.getStatus().equals((Object)Status.SUCCESS)) {
                    return taskResult;
                }
                logger.log(Level.FINE, String.format("Task %d completed successfully", task.getId()));
                UpdateActionStatusRequest updateActionStatusRequest = new UpdateActionStatusRequest.Builder(FetchTaskWorkflow.this.fleetEngineConn, dbUniqueName, FetchTaskWorkflow.this.agentId, FetchTaskWorkflow.this.actionId).build();
                response = updateActionStatusRequest.execute();
                logger.log(Level.FINE, "Notified Command Engine on task result: " + String.valueOf((Object)response.getStatus()));
            }
            catch (IOException | SQLException e) {
                logger.log(Level.FINE, Utils.getStackTrace(e));
                return Result.ftwUnhandledError(e.getMessage());
            }
            return new Result(Status.SUCCESS);
        }
    }
}

