/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.common.TnsnamesHelper;
import oracle.dbtools.extension.rcv.controllers.ConfigurationManager;
import oracle.dbtools.extension.rcv.models.LogArchiveConfig;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.Sqlnet;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.UpdateProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class DisableRealtimeRedoWorkflow
extends ProtectedDatabaseWorkflow {
    private LogArchiveConfig currentLogArchiveConfig;
    private LogArchiveConfig dbrsLogArchiveConfig;
    private HashMap<Integer, LogArchiveDestination> currentDestinations;
    private List<LogArchiveDestination> dbrsDestinations;
    private boolean restartDatabase = false;
    private ProtectedDatabase protectedDatabase;
    private ZRCVClientManager zrcvClientManager;

    public DisableRealtimeRedoWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("disable realtime_redo", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new RunChecks());
        steps.add(new RemoveLogArchiveDestinations());
        steps.add(new RemoveRedoTransportUser());
        steps.add(new UpdateTnsNames());
        steps.add(new UpdateSqlnet());
        steps.add(new NotifyControlPlane());
        steps.add(new RestartDatabase());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        Connection conn = this.getConnection();
        ProtectedDatabaseMetadata metadata = this.getProtectedDatabaseMetadata();
        Logger logger = this.getLogger();
        String rcvConf = ConfigurationManager.getRcvConf(metadata);
        this.zrcvClientManager = RCVCommand.createZrcvClientManager(logger);
        try {
            this.dbrsLogArchiveConfig = new LogArchiveConfig(ConfigurationManager.getLogArchiveConfig(rcvConf));
        }
        catch (IOException e) {
            throw Result.drrInitLogConfigException("Failed to get log archive config from RCV conf: " + e.getMessage());
        }
        String dgConfigString = DatabaseUtils.getLogArchiveConfig(conn);
        this.currentLogArchiveConfig = new LogArchiveConfig();
        if (dgConfigString != null) {
            this.currentLogArchiveConfig = new LogArchiveConfig(dgConfigString);
        }
        this.protectedDatabase = this.zrcvClientManager.getProtectedDatabase(metadata.getOcid());
    }

    private class RunChecks
    implements UnitOfWork {
        private RunChecks() {
        }

        @Override
        public Result run() {
            Logger logger = DisableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Run prechecks");
            ProtectedDatabaseMetadata metadata = DisableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            Connection conn = DisableRealtimeRedoWorkflow.this.getConnection();
            if (DatabaseUtils.isPDB(conn)) {
                String error = "You are connected to a PDB. This command requires a CDB connection to run. Please reconnect to the CDB and rerun this command.";
                return Result.drrCheckPdbError(error);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class RemoveLogArchiveDestinations
    implements UnitOfWork {
        private RemoveLogArchiveDestinations() {
        }

        @Override
        public Result run() {
            Logger logger = DisableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Remove log archive destinations");
            Connection conn = DisableRealtimeRedoWorkflow.this.getConnection();
            List<String> dbrsDgConfig = DisableRealtimeRedoWorkflow.this.dbrsLogArchiveConfig.getDgConfig();
            ArrayList<String> currentDgConfig = new ArrayList<String>(DisableRealtimeRedoWorkflow.this.currentLogArchiveConfig.getDgConfig());
            HashMap<String, String> updatedParameters = new HashMap<String, String>();
            boolean update = false;
            for (int i = currentDgConfig.size() - 1; i >= 0; --i) {
                String dbUniqueName = (String)currentDgConfig.get(i);
                for (String dbrsDbUniqueName : dbrsDgConfig) {
                    if (!dbrsDbUniqueName.equalsIgnoreCase(dbUniqueName)) continue;
                    currentDgConfig.remove(i);
                    update = true;
                }
            }
            if (update) {
                DisableRealtimeRedoWorkflow.this.currentLogArchiveConfig.setDgConfig(currentDgConfig);
                updatedParameters.put("log_archive_config", DisableRealtimeRedoWorkflow.this.currentLogArchiveConfig.toString());
            }
            try {
                ResultSet rs = DatabaseUtils.getLogArchiveDestinations(conn, dbrsDgConfig);
                if (rs != null) {
                    while (rs.next()) {
                        updatedParameters.put(rs.getString("DEST_NAME"), "");
                    }
                }
            }
            catch (SQLException e) {
                logger.log(Level.FINE, e.getMessage(), e);
                return Result.drrLogDestGetError("Failed to get log archive destinations: " + e.getMessage());
            }
            if (updatedParameters.keySet().size() > 0) {
                try {
                    DatabaseUtils.updateParameter(conn, updatedParameters);
                }
                catch (SQLException e) {
                    logger.log(Level.FINE, e.getMessage(), e);
                    return Result.drrLogDestUpdateError("Failed to update log archive destinations: " + e.getMessage());
                }
            } else {
                return new Result(Status.SKIPPED);
            }
            DisableRealtimeRedoWorkflow.this.restartDatabase = true;
            return new Result(Status.SUCCESS);
        }
    }

    private class RemoveRedoTransportUser
    implements UnitOfWork {
        private RemoveRedoTransportUser() {
        }

        @Override
        public Result run() {
            Logger logger = DisableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Remove redo transport user");
            Connection conn = DisableRealtimeRedoWorkflow.this.getConnection();
            ProtectedDatabaseMetadata metadata = DisableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            String currentRedoTransportUser = DatabaseUtils.getRedoTransportUser(conn);
            if (currentRedoTransportUser != null && currentRedoTransportUser.equals(DisableRealtimeRedoWorkflow.this.protectedDatabase.getVpcUserName())) {
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                parameterMap.put("redo_transport_user", "");
                DisableRealtimeRedoWorkflow.this.restartDatabase = true;
                try {
                    DatabaseUtils.updateParameter(conn, parameterMap);
                }
                catch (SQLException e) {
                    logger.log(Level.FINE, e.getMessage(), e);
                    return Result.drrRedoUserUpdateError("Failed to update redo_transport_user: " + e.getMessage());
                }
            } else {
                return new Result(Status.SKIPPED);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class UpdateTnsNames
    implements UnitOfWork {
        private UpdateTnsNames() {
        }

        @Override
        public Result run() {
            Logger logger = DisableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Update tnsnames");
            ProtectedDatabaseMetadata metadata = DisableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            try {
                if (!TnsnamesHelper.removeIfile(metadata.getTnsnamesFile())) {
                    return new Result(Status.SKIPPED);
                }
                DisableRealtimeRedoWorkflow.this.restartDatabase = true;
            }
            catch (FileNotFoundException e) {
                logger.log(Level.FINE, e.getMessage(), e);
                return Result.drrTnsnamesUpdateError("Failed to check and update tnsnames.ora: " + e.getMessage());
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage(), e);
                return Result.drrTnsnamesUpdateError("Failed to check and update tnsnames.ora: " + e.getMessage());
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class UpdateSqlnet
    implements UnitOfWork {
        private UpdateSqlnet() {
        }

        @Override
        public Result run() {
            Logger logger = DisableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Update sqlnet");
            ProtectedDatabaseMetadata metadata = DisableRealtimeRedoWorkflow.this.getProtectedDatabaseMetadata();
            Sqlnet sqlnet = new Sqlnet(Sqlnet.getSqlnetOraPath().toString());
            if (sqlnet.removeIfile(metadata.getSqlnetFile())) {
                DisableRealtimeRedoWorkflow.this.restartDatabase = true;
                try {
                    sqlnet.writeFile();
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.FINE, e.getMessage(), e);
                    return Result.drrSqlnetUpdateError("Failed to check and update sqlnet.ora: " + e.getMessage());
                }
                catch (IOException e) {
                    logger.log(Level.FINE, e.getMessage(), e);
                    return Result.drrSqlnetUpdateError("Failed to check and update sqlnet.ora: " + e.getMessage());
                }
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class NotifyControlPlane
    implements UnitOfWork {
        private NotifyControlPlane() {
        }

        @Override
        public Result run() {
            Logger logger = DisableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Notify control plane");
            if (DisableRealtimeRedoWorkflow.this.protectedDatabase.getIsRedoLogsShipped().booleanValue()) {
                Connection conn = DisableRealtimeRedoWorkflow.this.getConnection();
                ScriptRunnerContext ctx = DisableRealtimeRedoWorkflow.this.getContext();
                Optional<ParsedCommand> updateProtectedDatabaseCommand = Workflow.generateParsedCommand(RCVVerbs.UPDATE, RCVObjects.PROTECTED_DATABASE, Map.of(RCVOptions.Options.REALTIME_REDO.toString(), "false"), null, ctx);
                UpdateProtectedDatabaseWorkflow updateProtectedDatabaseWorkflow = new UpdateProtectedDatabaseWorkflow(updateProtectedDatabaseCommand.get(), conn, ctx);
                return updateProtectedDatabaseWorkflow.run();
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RestartDatabase
    implements UnitOfWork {
        private RestartDatabase() {
        }

        @Override
        public Result run() {
            Logger logger = DisableRealtimeRedoWorkflow.this.getLogger();
            logger.log(Level.INFO, "Check database");
            if (DisableRealtimeRedoWorkflow.this.restartDatabase) {
                logger.log(Level.INFO, "!! Action Required: Please restart the database to finish disabling real-time redo !!");
            }
            return new Result(Status.SUCCESS);
        }
    }
}

