/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.controllers.LogManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureLogWorkflow
extends Workflow {
    private Map<String, Level> logLevels = Map.of("INFO", Level.FINE, "TRACE", Level.FINEST);

    public ConfigureLogWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("set log", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new SetLoggingLevel());
        super.setSteps(steps);
    }

    private class SetLoggingLevel
    implements UnitOfWork {
        private SetLoggingLevel() {
        }

        @Override
        public Result run() {
            Logger logger = ConfigureLogWorkflow.this.getLogger();
            ParsedCommand command = ConfigureLogWorkflow.this.getCommand();
            String level = (String)command.getOptionValue((Id)RCVOptions.Options.LOG_LEVEL);
            if (level != null) {
                logger.log(Level.FINEST, "Level: {0}", level);
                level = level.toUpperCase();
                if (ConfigureLogWorkflow.this.logLevels.containsKey(level)) {
                    LogManager.setLogLevel(ConfigureLogWorkflow.this.logLevels.get(level));
                    logger.log(Level.INFO, "Set log level to: " + level);
                } else {
                    logger.log(Level.SEVERE, "Incorrect log level: " + level);
                    return new Result(Status.FAILED);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }
}

