/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureAuthenticationWorkflow
extends ProtectedDatabaseWorkflow {
    private OCIAuthentication.Method method;
    private String ociConfig;
    private String profileName;
    private GlobalMetadata globalMetadata;

    public ConfigureAuthenticationWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("update authentication", command, conn, ctx);
        Result optionsCheck = this.checkOptions();
        if (optionsCheck.getStatus().equals((Object)Status.FAILED)) {
            throw new IllegalArgumentException(optionsCheck.getMessage());
        }
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new CreateMetadataDirectory());
        steps.add(new ValidateAuthentication());
        steps.add(new UpdateMetadata());
        super.setSteps(steps);
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        this.method = OCIAuthentication.Method.valueOf((String)command.getOptionValue((Id)RCVOptions.Options.METHOD));
        this.ociConfig = (String)command.getOptionValue((Id)RCVOptions.Options.OCI_CONFIG);
        this.profileName = (String)command.getOptionValue((Id)RCVOptions.Options.PROFILE_NAME);
        this.globalMetadata = GlobalMetadata.load();
    }

    public Result checkOptions() {
        ParsedCommand command = this.getCommand();
        if (command.getOptionValue((Id)RCVOptions.Options.METHOD).equals("RESOURCE_PRINCIPAL")) {
            if (command.getOptionValue((Id)RCVOptions.Options.OCI_CONFIG) != null) {
                String error = String.format("-%s cannot be used when -%s is resource_principal.", new Object[]{RCVOptions.Options.OCI_CONFIG, RCVOptions.Options.METHOD});
                return Result.invalidOption(error);
            }
            if (command.getOptionValue((Id)RCVOptions.Options.PROFILE_NAME) != null) {
                String error = String.format("-%s cannot be used when -%s is resource_principal.", new Object[]{RCVOptions.Options.PROFILE_NAME, RCVOptions.Options.METHOD});
                return Result.invalidOption(error);
            }
        }
        return new Result(Status.SUCCESS);
    }

    private class CreateMetadataDirectory
    implements UnitOfWork {
        private CreateMetadataDirectory() {
        }

        @Override
        public Result run() {
            Logger logger = ConfigureAuthenticationWorkflow.this.getLogger();
            logger.log(Level.INFO, "Setting up environment");
            ProtectedDatabaseMetadata metadata = ConfigureAuthenticationWorkflow.this.getProtectedDatabaseMetadata();
            Path metadataFilePath = Paths.get(GlobalMetadata.getMetadataFile(), new String[0]);
            Path parentDir = metadataFilePath.getParent();
            if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(parentDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    String error = "Failed to setup environment:" + e.getMessage();
                    logger.log(Level.INFO, error, e);
                    return Result.uawMetadataError(error);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ValidateAuthentication
    implements UnitOfWork {
        private ValidateAuthentication() {
        }

        @Override
        public Result run() {
            Logger logger = ConfigureAuthenticationWorkflow.this.getLogger();
            logger.log(Level.INFO, "Validate authentication");
            if (ConfigureAuthenticationWorkflow.this.method.equals((Object)OCIAuthentication.Method.API_KEY)) {
                OCIAuthentication auth = new OCIAuthentication(ConfigureAuthenticationWorkflow.this.method, ConfigureAuthenticationWorkflow.this.ociConfig, ConfigureAuthenticationWorkflow.this.profileName);
                try {
                    ConfigFileAuthenticationDetailsProvider configFileAuthenticationDetailsProvider = new ConfigFileAuthenticationDetailsProvider(auth.getConfigFile(), auth.getProfileName());
                }
                catch (Exception e) {
                    String error = "Failed to update authentication: " + e.getMessage();
                    logger.log(Level.INFO, error, e);
                    return Result.uawValidateAuthenticationError(error);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class UpdateMetadata
    implements UnitOfWork {
        private UpdateMetadata() {
        }

        @Override
        public Result run() {
            Logger logger = ConfigureAuthenticationWorkflow.this.getLogger();
            logger.log(Level.INFO, "Update metadata");
            ConfigureAuthenticationWorkflow.this.globalMetadata.setAuthentication(new OCIAuthentication(ConfigureAuthenticationWorkflow.this.method, ConfigureAuthenticationWorkflow.this.ociConfig, ConfigureAuthenticationWorkflow.this.profileName));
            try {
                ConfigureAuthenticationWorkflow.this.globalMetadata.save();
            }
            catch (IOException e) {
                String error = "Failed to update metadata with new authentication: " + e.getMessage();
                logger.log(Level.INFO, error, e);
                return Result.uawMetadataUpdateError(error);
            }
            return new Result(Status.SUCCESS);
        }
    }
}

