/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RCVVerbs;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.workflows.ConfigureBackupWorkflow;
import oracle.dbtools.extension.rcv.workflows.FetchTaskWorkflow;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class BackupProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    int level = 1;

    public BackupProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("backup protected_database", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new SetBackupFlag());
        steps.add(new TakeBackup());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        if (command.getOptionValue((Id)RCVOptions.Options.LEVEL) != null) {
            this.level = (Integer)command.getOptionValue((Id)RCVOptions.Options.LEVEL);
        }
    }

    private class SetBackupFlag
    implements UnitOfWork {
        private SetBackupFlag() {
        }

        @Override
        public Result run() {
            Logger logger = BackupProtectedDatabaseWorkflow.this.getLogger();
            ScriptRunnerContext ctx = BackupProtectedDatabaseWorkflow.this.getContext();
            Optional<ParsedCommand> configureBackupCommand = Workflow.generateParsedCommand(RCVVerbs.CONFIGURE, RCVObjects.BACKUP, Map.of(RCVOptions.Options.CONFIG_NAME.toString(), "backup_level_zero_database", RCVOptions.Options.CONFIG_VALUE.toString(), BackupProtectedDatabaseWorkflow.this.level == 0 ? "true" : "false"), null, ctx);
            ConfigureBackupWorkflow configureWf = new ConfigureBackupWorkflow(configureBackupCommand.get(), BackupProtectedDatabaseWorkflow.this.getConnection(), BackupProtectedDatabaseWorkflow.this.getContext());
            return configureWf.run();
        }
    }

    private class TakeBackup
    implements UnitOfWork {
        private TakeBackup() {
        }

        @Override
        public Result run() {
            Connection conn = BackupProtectedDatabaseWorkflow.this.getConnection();
            ScriptRunnerContext ctx = BackupProtectedDatabaseWorkflow.this.getContext();
            Logger logger = BackupProtectedDatabaseWorkflow.this.getLogger();
            if (DatabaseUtils.getArchiveLogMode(conn).equalsIgnoreCase("NOARCHIVELOG")) {
                return Result.bpdLogmodeError("The archive log mode is 'NOARCHIVELOG'.");
            }
            Optional<ParsedCommand> fetchTaskCommand = Workflow.generateParsedCommand(RCVVerbs.FETCH, RCVObjects.TASK, null, null, ctx);
            FetchTaskWorkflow fetchTaskWorkflow = new FetchTaskWorkflow(fetchTaskCommand.get(), conn, BackupProtectedDatabaseWorkflow.this.getContext(), false);
            return fetchTaskWorkflow.run();
        }
    }
}

