/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.rest.OCIClientManager;
import oracle.dbtools.extension.rcv.rest.ZRCVClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.UnitOfWork;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class AddRecoveryServiceSubnetWorkflow
extends Workflow {
    private String vcnId;
    private String subnetId;
    private String displayName;
    private String compartmentId;
    private ZRCVClientManager zrcvClientManager;
    private ProtectedDatabaseMetadata metadata;
    private RecoveryServiceSubnet subnet;
    private static GlobalMetadata globalMetadata = GlobalMetadata.load();

    public AddRecoveryServiceSubnetWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super("add recovery service subnet", command, conn, ctx);
        ArrayList<UnitOfWork> steps = new ArrayList<UnitOfWork>();
        steps.add(new AddRecoveryServiceSubnet());
        steps.add(new WaitForRecoveryServiceSubnet());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        ParsedCommand command = this.getCommand();
        Map options = command.getOptions();
        String dbUniqueName = RCVCommand.getDbUniqueName(this.getConnection());
        this.metadata = RCVCommand.getProtectedDatabaseMetadata(dbUniqueName);
        this.vcnId = (String)command.getOptionValue((Id)RCVOptions.Options.VCN_ID);
        this.compartmentId = (String)command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.subnetId = (String)command.getOptionValue((Id)RCVOptions.Options.SUBNET_ID);
        this.displayName = (String)command.getOptionValue((Id)RCVOptions.Options.DISPLAY_NAME);
        String endpoint = (String)command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        if (endpoint == null) {
            endpoint = OCIClientManager.getRecoveryServiceEndpoint();
        }
        if (this.displayName == null) {
            this.displayName = String.format("%s_recovery_subnet", dbUniqueName);
        }
        globalMetadata.setRecoveryServiceEndpoint(endpoint);
        this.zrcvClientManager = RCVCommand.createZrcvClientManager(this.getLogger());
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    private class AddRecoveryServiceSubnet
    implements UnitOfWork {
        private AddRecoveryServiceSubnet() {
        }

        @Override
        public Result run() {
            Logger logger = AddRecoveryServiceSubnetWorkflow.this.getLogger();
            logger.log(Level.INFO, "Create recovery service subnet");
            try {
                AddRecoveryServiceSubnetWorkflow.this.subnet = AddRecoveryServiceSubnetWorkflow.this.zrcvClientManager.createRecoveryServiceSubnet(AddRecoveryServiceSubnetWorkflow.this.vcnId, AddRecoveryServiceSubnetWorkflow.this.compartmentId, AddRecoveryServiceSubnetWorkflow.this.displayName, AddRecoveryServiceSubnetWorkflow.this.subnetId);
            }
            catch (Exception e) {
                String error = "Failed to create recovery service subnet: " + Utils.getFirstString(e.toString());
                logger.log(Level.FINE, error, e);
                return Result.assCreateServiceSubnetError(error);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class WaitForRecoveryServiceSubnet
    implements UnitOfWork {
        private WaitForRecoveryServiceSubnet() {
        }

        @Override
        public Result run() {
            Logger logger = AddRecoveryServiceSubnetWorkflow.this.getLogger();
            logger.log(Level.INFO, "Verify lifecycle state");
            try {
                AddRecoveryServiceSubnetWorkflow.this.subnet = AddRecoveryServiceSubnetWorkflow.this.zrcvClientManager.waitForRecoveryServiceSubnetUpdate(AddRecoveryServiceSubnetWorkflow.this.subnet, 600, 20);
            }
            catch (Exception e) {
                String error = "Failed to get recovery service subnet state: " + Utils.getFirstString(e.toString());
                logger.log(Level.FINE, error, e);
                return Result.assGetServiceSubnetStateError(error);
            }
            LifecycleState lifeCycleState = AddRecoveryServiceSubnetWorkflow.this.subnet.getLifecycleState();
            if (lifeCycleState.equals((Object)LifecycleState.Creating)) {
                return Result.assLifecycleStatusTmt("Timed out waiting for recovery service subnet to become Active.");
            }
            if (!lifeCycleState.equals((Object)LifecycleState.Active)) {
                String error = String.format("The recovery service subnet's state is %s, expected it to be %s or %s", lifeCycleState.toString(), LifecycleState.Active.toString(), LifecycleState.Creating.toString());
                return Result.assVerifyLifecycleStatusError(error);
            }
            logger.log(Level.INFO, "The recovery service subnet ID is: " + AddRecoveryServiceSubnetWorkflow.this.subnet.getId());
            return new Result(Status.SUCCESS);
        }
    }
}

