/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.rest;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import com.oracle.bmc.database.model.DatabaseSummary;
import com.oracle.bmc.recovery.DatabaseRecoveryClient;
import com.oracle.bmc.recovery.model.CreateProtectedDatabaseDetails;
import com.oracle.bmc.recovery.model.CreateRecoveryServiceSubnetDetails;
import com.oracle.bmc.recovery.model.FetchProtectedDatabaseConfigurationDetails;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.ProtectedDatabaseCollection;
import com.oracle.bmc.recovery.model.ProtectedDatabaseSummary;
import com.oracle.bmc.recovery.model.ProtectionPolicy;
import com.oracle.bmc.recovery.model.ProtectionPolicySummary;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetSummary;
import com.oracle.bmc.recovery.model.UpdateProtectedDatabaseDetails;
import com.oracle.bmc.recovery.model.WorkRequest;
import com.oracle.bmc.recovery.requests.CreateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.CreateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.FetchProtectedDatabaseConfigurationRequest;
import com.oracle.bmc.recovery.requests.GetProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.GetProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.GetRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.GetWorkRequestRequest;
import com.oracle.bmc.recovery.requests.ListProtectedDatabasesRequest;
import com.oracle.bmc.recovery.requests.ListProtectionPoliciesRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.responses.CreateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.CreateRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.FetchProtectedDatabaseConfigurationResponse;
import com.oracle.bmc.recovery.responses.GetProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.GetProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.GetRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.ListProtectedDatabasesResponse;
import com.oracle.bmc.recovery.responses.ListProtectionPoliciesResponse;
import com.oracle.bmc.recovery.responses.ListRecoveryServiceSubnetsResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectedDatabaseResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.rest.OCIClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;

public class ZRCVClientManager {
    private DatabaseRecoveryClient client;
    private Logger logger;

    public ZRCVClientManager(OCIAuthentication authentication, String endpoint, Logger logger) {
        AbstractAuthenticationDetailsProvider provider = ZRCVClientManager.getAuthenticationDetailsProvider(authentication);
        this.client = DatabaseRecoveryClient.builder().build(provider);
        this.client.setEndpoint(endpoint);
        this.logger = logger;
    }

    public ZRCVClientManager(String endpoint, Logger logger) {
        this(new OCIAuthentication(OCIAuthentication.Method.API_KEY), endpoint, logger);
    }

    public ZRCVClientManager(DatabaseRecoveryClient client) {
        this.client = client;
    }

    public void setEndpoint(String endpoint) {
        this.client.setEndpoint(endpoint);
    }

    private void log(Level level, String message) {
        if (this.logger != null) {
            this.logger.log(level, message);
        } else {
            System.out.println(message);
        }
    }

    public static AbstractAuthenticationDetailsProvider getAuthenticationDetailsProvider(OCIAuthentication authentication) {
        OCIAuthentication.Method method = authentication.getMethod();
        if (method.equals((Object)OCIAuthentication.Method.RESOURCE_PRINCIPAL)) {
            String ociResourcePrincipalRptEndpoint = OCIClientManager.getResourcePrincipalRptEndpoint();
            ResourcePrincipalAuthenticationDetailsProvider provider = ResourcePrincipalAuthenticationDetailsProvider.builder().build_1_1(ociResourcePrincipalRptEndpoint, null);
            return provider;
        }
        try {
            ConfigFileAuthenticationDetailsProvider provider = new ConfigFileAuthenticationDetailsProvider(authentication.getConfigFile(), authentication.getProfileName());
            return provider;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to authenticate to ZRCV API with API keys in " + authentication.getConfigFile(), e);
        }
    }

    public CreateProtectedDatabaseResponse onboardProtectedDatabase(CreateProtectedDatabaseDetails database, boolean dryRun) {
        CreateProtectedDatabaseRequest createProtectedDatabaseRequest = CreateProtectedDatabaseRequest.builder().createProtectedDatabaseDetails(database).opcDryRun(Boolean.valueOf(dryRun)).build();
        CreateProtectedDatabaseResponse response = this.client.createProtectedDatabase(createProtectedDatabaseRequest);
        this.log(Level.FINE, response.toString());
        return response;
    }

    public UpdateProtectedDatabaseResponse updateProtectedDatabase(UpdateProtectedDatabaseDetails details, String protectedDatabaseId) {
        UpdateProtectedDatabaseRequest request = UpdateProtectedDatabaseRequest.builder().body$(details).protectedDatabaseId(protectedDatabaseId).build();
        UpdateProtectedDatabaseResponse response = this.client.updateProtectedDatabase(request);
        return response;
    }

    public FetchProtectedDatabaseConfigurationResponse getConfiguration(String protectedDatabaseId, FetchProtectedDatabaseConfigurationDetails.ConfigurationType type, String fileName) {
        FetchProtectedDatabaseConfigurationResponse response;
        FetchProtectedDatabaseConfigurationDetails fetchProtectedDatabaseConfigurationDetails = FetchProtectedDatabaseConfigurationDetails.builder().configurationType(type).build();
        FetchProtectedDatabaseConfigurationRequest fetchProtectedDatabaseConfigurationRequest = FetchProtectedDatabaseConfigurationRequest.builder().protectedDatabaseId(protectedDatabaseId).fetchProtectedDatabaseConfigurationDetails(fetchProtectedDatabaseConfigurationDetails).build();
        try {
            response = this.client.fetchProtectedDatabaseConfiguration(fetchProtectedDatabaseConfigurationRequest);
        }
        catch (Exception e) {
            throw Result.wfFetchProtectedDatabaseConfigurationException("Failed to fetch database configuration", e);
        }
        Path path = Paths.get(fileName, new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            this.log(Level.INFO, ex.getMessage());
            return null;
        }
        try {
            int read;
            File targetFile = new File(fileName);
            if (!targetFile.exists()) {
                targetFile.createNewFile();
            } else {
                targetFile.delete();
                targetFile.createNewFile();
            }
            InputStream inputStream = response.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(targetFile, false);
            byte[] bytes = new byte[8192];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        catch (IOException ex) {
            this.log(Level.INFO, ex.getMessage());
            return null;
        }
        return response;
    }

    public ProtectedDatabase waitForProtectedDatabaseUpdate(ProtectedDatabase protectedDatabase, int waitTime, int waitInterval) {
        String protectedDatabaseId = protectedDatabase.getId();
        return this.waitForProtectedDatabaseUpdate(protectedDatabaseId, waitTime, waitInterval);
    }

    public ProtectedDatabase waitForProtectedDatabaseUpdate(String protectedDatabaseId, int waitTime, int waitInterval) {
        GetProtectedDatabaseRequest request = GetProtectedDatabaseRequest.builder().protectedDatabaseId(protectedDatabaseId).build();
        return this.waitForProtectedDatabaseUpdate(request, waitTime, waitInterval);
    }

    public ProtectedDatabase waitForProtectedDatabaseUpdate(GetProtectedDatabaseRequest request, int waitTime, int waitInterval) {
        ProtectedDatabase protectedDatabase = this.client.getProtectedDatabase(request).getProtectedDatabase();
        LifecycleState state = protectedDatabase.getLifecycleState();
        for (int time = 0; time < waitTime && (state.equals((Object)LifecycleState.Creating) || state.equals((Object)LifecycleState.Deleting) || state.equals((Object)LifecycleState.Updating)); time += waitInterval) {
            try {
                Thread.sleep(waitInterval * 1000);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            protectedDatabase = this.client.getProtectedDatabase(request).getProtectedDatabase();
            state = protectedDatabase.getLifecycleState();
        }
        return protectedDatabase;
    }

    public List<ProtectedDatabase> waitForWorkRequestToFinish(String workRequestId, int waitTime, int waitInterval) {
        ArrayList<ProtectedDatabase> databases = new ArrayList<ProtectedDatabase>();
        GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(workRequestId).build();
        WorkRequest workRequest = this.client.getWorkRequest(getWorkRequestRequest).getWorkRequest();
        workRequest.getResources().stream().map(resource -> resource.getIdentifier()).forEach(id -> {
            ProtectedDatabase db = this.waitForProtectedDatabaseUpdate((String)id, waitTime, waitInterval);
            databases.add(db);
        });
        return databases;
    }

    public WorkRequest getWorkRequest(String workRequestId) {
        GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(workRequestId).build();
        return this.client.getWorkRequest(getWorkRequestRequest).getWorkRequest();
    }

    public List<ProtectedDatabaseSummary> filterProtectedDatabasesByDatabaseId(String compartmentId, String databaseId) {
        ListProtectedDatabasesRequest request = ListProtectedDatabasesRequest.builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active).build();
        ListProtectedDatabasesResponse response = this.client.listProtectedDatabases(request);
        ProtectedDatabaseCollection collection = response.getProtectedDatabaseCollection();
        if (collection == null) {
            return new ArrayList<ProtectedDatabaseSummary>();
        }
        List summaryList = collection.getItems();
        List<ProtectedDatabaseSummary> filteredList = summaryList.stream().filter(summary -> summary.getDatabaseId() != null && summary.getDatabaseId().equals(databaseId)).collect(Collectors.toList());
        return filteredList;
    }

    public ProtectedDatabase getProtectedDatabase(String protectedDatabaseId) {
        GetProtectedDatabaseResponse response;
        GetProtectedDatabaseRequest request = GetProtectedDatabaseRequest.builder().protectedDatabaseId(protectedDatabaseId).build();
        try {
            response = this.client.getProtectedDatabase(request);
        }
        catch (Exception e) {
            throw Result.rcvGetProtectedDatabaseException("Failed to get protected database details", e);
        }
        return response.getProtectedDatabase();
    }

    public DeleteProtectedDatabaseResponse removeProtectedDatabase(String protectedDatabaseId) {
        DeleteProtectedDatabaseRequest request = DeleteProtectedDatabaseRequest.builder().protectedDatabaseId(protectedDatabaseId).build();
        return this.client.deleteProtectedDatabase(request);
    }

    public ProtectedDatabase waitForRemoveProtectedDatabase(String protectedDatabaseId) {
        ProtectedDatabase db = this.getProtectedDatabase(protectedDatabaseId);
        LifecycleState state = db.getLifecycleState();
        if (state.equals((Object)LifecycleState.Active)) {
            DeleteProtectedDatabaseResponse response = this.removeProtectedDatabase(protectedDatabaseId);
            this.log(Level.FINE, response.getOpcRequestId());
            this.log(Level.FINE, response.getOpcWorkRequestId());
        }
        db = this.waitForProtectedDatabaseUpdate(protectedDatabaseId, 300, 5);
        return db;
    }

    public List<RecoveryServiceSubnetSummary> getRecoveryServiceSubnets(ListRecoveryServiceSubnetsRequest request) {
        ListRecoveryServiceSubnetsResponse response = this.client.listRecoveryServiceSubnets(request);
        return response.getRecoveryServiceSubnetCollection().getItems();
    }

    public RecoveryServiceSubnet getRecoveryServiceSubnet(GetRecoveryServiceSubnetRequest request) {
        GetRecoveryServiceSubnetResponse response = this.client.getRecoveryServiceSubnet(request);
        return response.getRecoveryServiceSubnet();
    }

    public RecoveryServiceSubnet createRecoveryServiceSubnet(String vcnId, String compartmentId, String displayName, String subnetId) {
        CreateRecoveryServiceSubnetDetails details = CreateRecoveryServiceSubnetDetails.builder().vcnId(vcnId).compartmentId(compartmentId).displayName(displayName).subnetId(subnetId).build();
        CreateRecoveryServiceSubnetRequest request = CreateRecoveryServiceSubnetRequest.builder().body$(details).build();
        CreateRecoveryServiceSubnetResponse response = this.client.createRecoveryServiceSubnet(request);
        return response.getRecoveryServiceSubnet();
    }

    public RecoveryServiceSubnet waitForRecoveryServiceSubnetUpdate(RecoveryServiceSubnet subnet, int waitTime, int waitInterval) {
        String id = subnet.getId();
        return this.waitForRecoveryServiceSubnetUpdate(id, waitTime, waitInterval);
    }

    public RecoveryServiceSubnet waitForRecoveryServiceSubnetUpdate(String recoveryServiceSubnetId, int waitTime, int waitInterval) {
        GetRecoveryServiceSubnetRequest request = GetRecoveryServiceSubnetRequest.builder().recoveryServiceSubnetId(recoveryServiceSubnetId).build();
        return this.waitForRecoveryServiceSubnetUpdate(request, waitTime, waitInterval);
    }

    public RecoveryServiceSubnet waitForRecoveryServiceSubnetUpdate(GetRecoveryServiceSubnetRequest request, int waitTime, int waitInterval) {
        RecoveryServiceSubnet subnet = this.client.getRecoveryServiceSubnet(request).getRecoveryServiceSubnet();
        LifecycleState state = subnet.getLifecycleState();
        for (int time = 0; time < waitTime && (state.equals((Object)LifecycleState.Creating) || state.equals((Object)LifecycleState.Deleting) || state.equals((Object)LifecycleState.Updating)); time += waitInterval) {
            try {
                Thread.sleep(waitInterval * 1000);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            subnet = this.client.getRecoveryServiceSubnet(request).getRecoveryServiceSubnet();
            state = subnet.getLifecycleState();
        }
        return subnet;
    }

    public String getProtectedDatabaseOcid(Connection conn) {
        List<ProtectedDatabaseSummary> summaryList;
        GlobalMetadata globalMetadata = RCVCommand.getGlobalMetadata();
        String dbUniqueName = RCVCommand.getDbUniqueName(conn);
        String dbOcid = null;
        String compartmentId = null;
        if (globalMetadata.getSystemType().equals("OCI")) {
            OCIAuthentication authentication = globalMetadata.getAuthentication();
            OCIClientManager ociClientManager = new OCIClientManager(authentication);
            DatabaseSummary databaseSummary = ociClientManager.getDatabaseSummary(dbUniqueName);
            if (databaseSummary == null) {
                this.log(Level.FINE, "no database found");
                return null;
            }
            dbOcid = databaseSummary.getId();
            compartmentId = databaseSummary.getCompartmentId();
        } else {
            dbOcid = DatabaseUtils.generateDatabaseIdForOnPremiseClient(conn);
            ProtectedDatabaseMetadata metadata = RCVCommand.getProtectedDatabaseMetadata(dbUniqueName);
            compartmentId = metadata.getCompartmentId();
            if (compartmentId == null) {
                throw new IllegalStateException("Compartment ID is missing from the metadata. Please provide it using 'rcv add protected_database'.");
            }
        }
        if (dbOcid != null && (summaryList = this.filterProtectedDatabasesByDatabaseId(compartmentId, dbOcid)).size() > 0) {
            return summaryList.get(0).getId();
        }
        return null;
    }

    public String getProtectedDatabaseOcid(Connection conn, String compartmentId) {
        List<ProtectedDatabaseSummary> summaryList;
        GlobalMetadata globalMetadata = RCVCommand.getGlobalMetadata();
        String dbUniqueName = RCVCommand.getDbUniqueName(conn);
        String dbOcid = null;
        if (globalMetadata.getSystemType().equals("OCI")) {
            OCIAuthentication authentication = globalMetadata.getAuthentication();
            OCIClientManager ociClientManager = new OCIClientManager(authentication);
            DatabaseSummary databaseSummary = ociClientManager.getDatabaseSummary(dbUniqueName);
            if (databaseSummary == null) {
                this.log(Level.FINE, "no database found");
                return null;
            }
            dbOcid = databaseSummary.getId();
            compartmentId = databaseSummary.getCompartmentId();
        } else {
            dbOcid = DatabaseUtils.generateDatabaseIdForOnPremiseClient(conn);
        }
        if (dbOcid != null && (summaryList = this.filterProtectedDatabasesByDatabaseId(compartmentId, dbOcid)).size() > 0) {
            return summaryList.get(0).getId();
        }
        return null;
    }

    public List<ProtectionPolicySummary> getProtectionPolicies(ListProtectionPoliciesRequest request) {
        ListProtectionPoliciesResponse response;
        try {
            response = this.client.listProtectionPolicies(request);
        }
        catch (Exception e) {
            throw Result.rcvGetProtectionPolicyException("Failed to get protection policy details", e);
        }
        return response.getProtectionPolicyCollection().getItems();
    }

    public List<ProtectionPolicySummary> getDefaultProtectionPolicies(String compartmentId) {
        ListProtectionPoliciesRequest request = new ListProtectionPoliciesRequest.Builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active).build();
        List<ProtectionPolicySummary> items = this.getProtectionPolicies(request);
        return items.stream().filter(item -> item.getIsPredefinedPolicy()).collect(Collectors.toList());
    }

    public List<ProtectionPolicySummary> getProtectionPolicies(String compartmentId) {
        ListProtectionPoliciesRequest request = new ListProtectionPoliciesRequest.Builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active).build();
        return this.getProtectionPolicies(request);
    }

    public List<ProtectionPolicySummary> getProtectionPoliciesByName(String policyName, String compartmentId) {
        ListProtectionPoliciesRequest request = new ListProtectionPoliciesRequest.Builder().compartmentId(compartmentId).displayName(policyName).lifecycleState(LifecycleState.Active).build();
        return this.getProtectionPolicies(request);
    }

    public List<String> getProtectionPolicyOcids(String policyName, String compartmentId) {
        List<ProtectionPolicySummary> items = this.getProtectionPoliciesByName(policyName, compartmentId);
        return items.stream().map(ProtectionPolicySummary::getId).collect(Collectors.toList());
    }

    public ProtectionPolicy getProtectionPolicy(String policyId, String compartmentId) {
        GetProtectionPolicyRequest request = GetProtectionPolicyRequest.builder().protectionPolicyId(policyId).build();
        GetProtectionPolicyResponse response = this.client.getProtectionPolicy(request);
        return response.getProtectionPolicy();
    }
}

