/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.rest;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.DatabaseSummary;
import com.oracle.bmc.database.model.DbHomeSummary;
import com.oracle.bmc.database.model.DbSystem;
import com.oracle.bmc.database.requests.GetDbSystemRequest;
import com.oracle.bmc.database.requests.ListDatabasesRequest;
import com.oracle.bmc.database.requests.ListDbHomesRequest;
import com.oracle.bmc.database.responses.GetDbSystemResponse;
import com.oracle.bmc.database.responses.ListDatabasesResponse;
import com.oracle.bmc.database.responses.ListDbHomesResponse;
import java.io.IOException;
import java.net.http.HttpConnectTimeoutException;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.InstanceMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.rest.InstanceMetadataClient;
import oracle.dbtools.extension.rcv.workflows.Result;

public class OCIClientManager {
    private DatabaseClient databaseClient;

    public OCIClientManager(OCIAuthentication authentication) {
        OCIAuthentication.Method method = authentication.getMethod();
        if (method.equals((Object)OCIAuthentication.Method.RESOURCE_PRINCIPAL)) {
            String ociResourcePrincipalRptEndpoint = OCIClientManager.getResourcePrincipalRptEndpoint();
            ResourcePrincipalAuthenticationDetailsProvider provider = ResourcePrincipalAuthenticationDetailsProvider.builder().build_1_1(ociResourcePrincipalRptEndpoint, null);
            this.databaseClient = new DatabaseClient((BasicAuthenticationDetailsProvider)provider);
        } else {
            try {
                ConfigFileAuthenticationDetailsProvider provider = new ConfigFileAuthenticationDetailsProvider(authentication.getConfigFile(), authentication.getProfileName());
                this.databaseClient = new DatabaseClient((BasicAuthenticationDetailsProvider)provider);
            }
            catch (IOException e) {
                throw new RuntimeException("OCI SDK authentication failed using API keys", e);
            }
        }
    }

    public static String getDbSystemOcid() throws IOException, InterruptedException {
        InstanceMetadata instanceMetadata = new InstanceMetadata(InstanceMetadataClient.getInstanceMetadataResponse());
        String dbSystemId = instanceMetadata.getDisplayName();
        return dbSystemId;
    }

    public static boolean amIInOCI() {
        try {
            InstanceMetadata instanceMetadata = new InstanceMetadata(InstanceMetadataClient.getInstanceMetadataResponse());
        }
        catch (HttpConnectTimeoutException e) {
            return false;
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return true;
    }

    public DbSystem getDbSystem(String dbSystemId) {
        GetDbSystemResponse getDbSystemResponse;
        GetDbSystemRequest getDbSystemRequest = GetDbSystemRequest.builder().dbSystemId(dbSystemId).build();
        try {
            getDbSystemResponse = this.databaseClient.getDbSystem(getDbSystemRequest);
        }
        catch (Exception e) {
            throw Result.ociDatabaseApiException("Failed to get database system details.", e);
        }
        return getDbSystemResponse.getDbSystem();
    }

    public DatabaseSummary getDatabaseSummary(String dbUniqueName) {
        ListDatabasesResponse response;
        ListDbHomesResponse listDbHomesResponse;
        GlobalMetadata globalMetadata = RCVCommand.getGlobalMetadata();
        String dbSystemId = globalMetadata.getDbSystemOcid();
        DbSystem dbSystem = this.getDbSystem(dbSystemId);
        if (dbSystem == null) {
            return null;
        }
        String compartmentId = dbSystem.getCompartmentId();
        ListDbHomesRequest listDbHomesRequest = ListDbHomesRequest.builder().compartmentId(compartmentId).dbSystemId(dbSystemId).build();
        try {
            listDbHomesResponse = this.databaseClient.listDbHomes(listDbHomesRequest);
        }
        catch (Exception e) {
            throw Result.ociDatabaseApiException("Failed to get list of database homes on the system.", e);
        }
        List dbHomeSummaryList = listDbHomesResponse.getItems();
        if (dbHomeSummaryList.isEmpty()) {
            return null;
        }
        DbHomeSummary dbHomeSummary = (DbHomeSummary)dbHomeSummaryList.get(0);
        if (dbHomeSummary == null) {
            return null;
        }
        String dbHomeId = dbHomeSummary.getId();
        ListDatabasesRequest listDatabasesRequest = ListDatabasesRequest.builder().systemId(dbSystemId).compartmentId(compartmentId).dbHomeId(dbHomeId).build();
        try {
            response = this.databaseClient.listDatabases(listDatabasesRequest);
        }
        catch (Exception e) {
            throw Result.ociDatabaseApiException("Failed to get list of the databases on the system.", e);
        }
        List databases = response.getItems();
        databases = databases.stream().filter(db -> db.getDbUniqueName() != null && db.getDbUniqueName().equalsIgnoreCase(dbUniqueName) && db.getLifecycleState().equals((Object)DatabaseSummary.LifecycleState.Available)).collect(Collectors.toList());
        if (databases != null && !databases.isEmpty()) {
            return (DatabaseSummary)databases.get(0);
        }
        return null;
    }

    public static Region getRegion() {
        Region.enableInstanceMetadataService();
        Region.registerFromInstanceMetadataService();
        Region region = Region.getRegionFromImds();
        return region;
    }

    public static String getResourcePrincipalRptEndpoint() {
        Region region = OCIClientManager.getRegion();
        String regionString = region.getRegionId();
        return "https://database." + regionString + ".oraclecloud.com";
    }

    public static String getRecoveryServiceEndpoint() {
        Region region = OCIClientManager.getRegion();
        String regionString = region.getRegionId();
        return OCIClientManager.getRecoveryServiceEndpoint(regionString);
    }

    public static String getRecoveryServiceEndpoint(String region) {
        return "https://recovery." + region + ".oci.oraclecloud.com";
    }
}

