/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;

public class UpdateActionStatusRequest
extends FleetEngineRequest {
    private int agentId;
    private int actionId;
    private String errorString;
    private int errorNum;
    private static final String ACTION_STATUS = "call dbms_ra_cmd_engine.action_status(?, ?, ?, ?, ?, ?, ?)";

    private UpdateActionStatusRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        try {
            this.errorString = builder.errorString;
            this.errorNum = builder.errorNum;
            this.actionId = builder.actionId;
            this.agentId = builder.agentId;
            CallableStatement cs = super.getCallableStatement();
            cs.setString("P_DB_UNIQUE_NAME", dbUniqueName.toUpperCase());
            cs.setInt("P_ACTION_ID", this.actionId);
            cs.setInt("P_AGENT_ID", this.agentId);
            cs.registerOutParameter("O_STATUS_CODE", 4);
            cs.registerOutParameter("O_STATUS_MESG", 12);
            if (this.errorString == null) {
                cs.setNull("P_ERROR_STRING", 12);
            } else {
                cs.setString("P_ERROR_STRING", this.errorString);
            }
            if (this.errorNum == -1) {
                cs.setNull("P_ERROR_NUM", 4);
            } else {
                cs.setInt("P_ERROR_NUM", this.errorNum);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update task status: " + e.getMessage());
        }
    }

    public int getAgentId() {
        return this.agentId;
    }

    public int getActionId() {
        return this.actionId;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    @Override
    public FleetEngineResponse execute() throws SQLException {
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int statusCode = cs.getInt("O_STATUS_CODE");
        String statusMessage = cs.getString("O_STATUS_MESG");
        return new FleetEngineResponse(statusCode, statusMessage, null);
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int agentId;
        private int actionId;
        private String errorString;
        private int errorNum = -1;

        public Builder(Connection conn, String dbUniqueName, int agentId, int actionId) {
            super(conn, dbUniqueName, UpdateActionStatusRequest.ACTION_STATUS);
            this.agentId = agentId;
            this.actionId = actionId;
        }

        public Builder errorNum(int errorNum) {
            this.errorNum = errorNum;
            return this.self();
        }

        public Builder errorString(String errorString) {
            this.errorString = errorString;
            return this.self();
        }

        @Override
        public UpdateActionStatusRequest build() {
            return new UpdateActionStatusRequest(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

