/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;

public class InitRequest
extends FleetEngineRequest {
    private static final String INIT = "call dbms_ra_cmd_engine.init(?, ?, ?, ?, ?, ?)";
    private int instanceId;

    private InitRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        this.instanceId = builder.instanceId;
        try {
            CallableStatement cs = super.getCallableStatement();
            cs.setString("p_db_unique_name", dbUniqueName.toUpperCase());
            cs.setString("p_agent_version", "" + RCVCommand.AGENT_VERSION);
            cs.setInt("p_instance_id", this.instanceId);
            cs.registerOutParameter("o_agent_id", 4);
            cs.registerOutParameter("o_status_code", 4);
            cs.registerOutParameter("o_status_mesg", 12);
        }
        catch (SQLException e) {
            System.out.println(e);
            throw new RuntimeException("Failed to initiate session with Command Engine: " + e.getMessage());
        }
    }

    @Override
    public FleetEngineResponse execute() throws SQLException {
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int returnCode = cs.getInt("O_STATUS_CODE");
        String statusMessage = cs.getString("O_STATUS_MESG");
        int agentId = cs.getInt("O_AGENT_ID");
        return new FleetEngineResponse(returnCode, statusMessage, (Object)agentId);
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int instanceId;

        public Builder(Connection conn, String dbUniqueName, int instanceId) {
            super(conn, dbUniqueName, InitRequest.INIT);
            this.instanceId = instanceId;
        }

        @Override
        public InitRequest build() {
            return new InitRequest(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

