/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;

public abstract class FleetEngineRequest {
    private Connection conn;
    private String dbUniqueName;
    private CallableStatement cs;

    protected FleetEngineRequest(Builder<?> builder) {
        this.conn = builder.conn;
        this.dbUniqueName = builder.dbUniqueName;
        try {
            this.cs = this.conn.prepareCall(builder.plsqlCall);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Connection getFleetEngineConnection() {
        return this.conn;
    }

    public CallableStatement getCallableStatement() {
        return this.cs;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public abstract FleetEngineResponse execute() throws SQLException;

    public static abstract class Builder<T extends Builder<T>> {
        private Connection conn;
        private String dbUniqueName;
        private String plsqlCall;

        public Builder(Connection conn, String dbUniqueName, String plsqlCall) {
            this.conn = conn;
            this.dbUniqueName = dbUniqueName;
            this.plsqlCall = plsqlCall;
        }

        public abstract FleetEngineRequest build();

        public abstract T self();
    }
}

