/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;

public class ConfigureRequest
extends FleetEngineRequest {
    private int agentId;
    private String name;
    private String value;
    private static final String CONFIGURE = "call dbms_ra_cmd_engine.configure(?, ?, ?, ?, ?, ?)";
    public static final String ARCHIVAL_BACKUP_INTERVAL = "archival_backup_interval";
    public static final String CLIENT_MAX_CHANNEL = "client_max_channel";
    public static final String COMPRESSION_ALGORITHM = "compression_algorithm";
    public static final String CREDENTIAL_ALIAS = "credential_alias";
    public static final String DB_VERSION = "db_version";
    public static final String ENCRYPTION_ALGORITHM = "encryption_algorithm";
    public static final String FLEET_AGENT_VERSION = "fleet_agent_version";
    public static final String LEVEL_ONE_BACKUP = "backup_level_one_database";
    public static final String LEVEL_ZERO_BACKUP = "backup_level_zero_database";
    public static final String LIB_RA_LOCATION = "lib_ra_location";
    public static final String NODE_COUNT = "node_count";
    public static final String OCPU_PER_NODE = "ocpu_per_node";
    public static final String PREFERRED_BACKUP_DB_UNIQUE_NAME = "preferred_backup_db_unique_name";
    public static final String RMAN_VERSION = "rman_version";
    public static final String UPLOAD_PERMISSION = "upload_permission";
    public static final String WALLET_LOCATION = "wallet_location";

    private ConfigureRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        try {
            CallableStatement cs = super.getCallableStatement();
            this.agentId = builder.agentId;
            this.name = builder.name;
            this.value = builder.value;
            cs.setString("P_DB_UNIQUE_NAME", dbUniqueName.toUpperCase());
            cs.setInt("P_AGENT_ID", builder.agentId);
            cs.setString("P_NAME", builder.name);
            cs.setString("P_VALUE", builder.value);
            cs.registerOutParameter("O_STATUS_CODE", 4);
            cs.registerOutParameter("O_STATUS_MESG", 12);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initiate session with Command Engine: " + e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public FleetEngineResponse execute() throws SQLException {
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int statusCode = cs.getInt("O_STATUS_CODE");
        String statusMessage = cs.getString("O_STATUS_MESG");
        return new FleetEngineResponse(statusCode, statusMessage, null);
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int agentId;
        private String name;
        private String value;

        public Builder(Connection conn, String dbUniqueName, int agentId, String name, String value) {
            super(conn, dbUniqueName, ConfigureRequest.CONFIGURE);
            this.agentId = agentId;
            this.name = name;
            this.value = value;
        }

        @Override
        public ConfigureRequest build() {
            return new ConfigureRequest(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

