/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemCommand {
    private HashMap<String, String> environment;
    private String logFile;
    private Logger logger;

    public SystemCommand() {
        this.environment = null;
    }

    public SystemCommand(HashMap<String, String> environment) {
        this.environment = environment;
    }

    public SystemCommand(String logFile) {
        this.logFile = logFile;
    }

    public SystemCommand(Logger logger) {
        this.logger = logger;
    }

    public SystemCommand(HashMap<String, String> environment, String logFile) {
        this.environment = environment;
        this.logFile = logFile;
    }

    public SystemCommand(HashMap<String, String> environment, Logger logger) {
        this.environment = environment;
        this.logger = logger;
    }

    public void setEnvironment(HashMap<String, String> environment) {
        this.environment = environment;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public ExecutionResult run(List<String> args) {
        return this.run(args, true);
    }

    public ExecutionResult run(List<String> args, String input) {
        return this.run(args, input, true);
    }

    public ExecutionResult run(List<String> args, boolean printOutput) {
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        builder.redirectError(ProcessBuilder.Redirect.PIPE);
        if (this.environment != null) {
            Map<String, String> processEnvironment = builder.environment();
            for (String key : this.environment.keySet()) {
                processEnvironment.put(key, this.environment.get(key));
            }
        }
        StringBuilder sb = new StringBuilder();
        try {
            Process process = builder.start();
            BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String lineSeparator = System.getProperty("line.separator");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (this.logger != null) {
                        this.logger.log(Level.FINE, line + lineSeparator);
                    }
                    sb.append(line).append(lineSeparator);
                }
            }
            int rc = process.waitFor();
            return new ExecutionResult(sb.toString(), rc);
        }
        catch (Exception e) {
            System.out.println("failed to execute command: " + e.getMessage());
            e.printStackTrace();
            return new ExecutionResult(e.getMessage(), -1);
        }
    }

    public ExecutionResult run(List<String> args, String input, boolean printOutput) {
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectErrorStream(true);
        if (this.environment != null) {
            Map<String, String> processEnvironment = builder.environment();
            for (String key : this.environment.keySet()) {
                processEnvironment.put(key, this.environment.get(key));
            }
        }
        StringBuilder sb = new StringBuilder();
        try {
            Process process = builder.start();
            BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedWriter stdInput = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            stdInput.write(input + System.getProperty("line.separator"));
            stdInput.flush();
            stdInput.close();
            String s = null;
            while ((s = stdOutput.readLine()) != null) {
                if (printOutput) {
                    System.out.println("\t" + s);
                }
                sb.append(s);
                sb.append(System.getProperty("line.separator"));
            }
            int rc = process.waitFor();
            return new ExecutionResult(sb.toString(), rc);
        }
        catch (Exception e) {
            System.out.println("failed to execute command: " + e.getMessage());
            e.printStackTrace();
            return new ExecutionResult(e.getMessage(), -1);
        }
    }

    public class ExecutionResult {
        private String output;
        private int returnCode;

        public ExecutionResult(String output, int returnCode) {
            this.output = output;
            this.returnCode = returnCode;
        }

        public String getOutput() {
            return this.output;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

