/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.models.Node;

public class Sqlnet {
    private List<Node<String, String>> entries;

    public Sqlnet() {
        this.entries = new ArrayList<Node<String, String>>();
    }

    public Sqlnet(List<Node<String, String>> entries) {
        this.entries = entries;
    }

    public Sqlnet(String filePath) {
        ArrayList<String> data = new ArrayList<String>();
        Object currentEntry = "";
        int leftParentheses = 0;
        Pattern p = Pattern.compile("^([^\\s\\(\\)]+)\\s*=\\s*(\\S+)$");
        Pattern commentP = Pattern.compile("^#\\s*\\S+");
        try {
            File file = new File(filePath);
            Scanner sqlnetReader = new Scanner(file);
            while (sqlnetReader.hasNextLine()) {
                Matcher m;
                String line = sqlnetReader.nextLine().strip();
                Matcher commentM = commentP.matcher(line);
                if (commentM.find()) continue;
                line = line.replaceAll("\\s", "");
                currentEntry = (String)currentEntry + line;
                for (char c : line.toCharArray()) {
                    if (c == '(') {
                        ++leftParentheses;
                    } else if (c == ')') {
                        --leftParentheses;
                    }
                    if (leftParentheses >= 0) continue;
                }
                if (leftParentheses != 0 || !(m = p.matcher((CharSequence)currentEntry)).find()) continue;
                data.add((String)currentEntry);
                currentEntry = "";
            }
            sqlnetReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.entries = this.parseLines(data);
    }

    private List<Node<String, String>> parseLines(List<String> lines) {
        ArrayList<Node<String, String>> data = new ArrayList<Node<String, String>>();
        for (String line : lines) {
            data.add(this.parseLine(line));
        }
        return data;
    }

    private Node<String, String> parseLine(String line) {
        Pattern p1 = Pattern.compile("^([^\\s\\(\\)]+)\\s*=\\s*([^\\s\\(\\)=]+)$");
        Pattern p2 = Pattern.compile("^([^\\s\\(\\)]+)\\s*=\\s*(\\([^\\(\\)=]+\\))$");
        Pattern p3 = Pattern.compile("^([^\\s\\(\\)]+)\\s*=\\s*(\\(\\S+\\))$");
        Matcher m = p1.matcher(line);
        if (m.find()) {
            return new Node<String, String>(m.group(1), m.group(2));
        }
        m = p2.matcher(line);
        if (m.find()) {
            return new Node<String, String>(m.group(1), m.group(2));
        }
        m = p3.matcher(line);
        if (!m.find()) {
            return null;
        }
        int leftParentheses = 0;
        int leftParenthesisIndex = line.indexOf("(");
        Node<String, String> node = new Node<String, String>(m.group(1), m.group(2));
        for (int i = leftParenthesisIndex; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '(') {
                ++leftParentheses;
                if (leftParenthesisIndex == -1) {
                    leftParenthesisIndex = i;
                }
            } else if (c == ')') {
                --leftParentheses;
            }
            if (leftParenthesisIndex == -1 || leftParentheses != 0) continue;
            Node<String, String> child = this.parseLine(line.substring(leftParenthesisIndex + 1, i));
            node.addChild(child);
            leftParenthesisIndex = -1;
        }
        return node;
    }

    public List<Node<String, String>> getSqlnetEntries() {
        return this.entries;
    }

    public Node<String, String> getEntry(String parameter) {
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            Node<String, String> n = this.entries.get(i).get(parameter);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    public List<Node<String, String>> getAllEntriesFor(String parameter) {
        ArrayList<Node<String, String>> targetEntries = new ArrayList<Node<String, String>>();
        for (int i = 0; i < this.entries.size(); ++i) {
            List<Node<String, String>> childTargetEntries = this.entries.get(i).getAll(parameter);
            for (Node<String, String> entry : childTargetEntries) {
                targetEntries.add(entry);
            }
        }
        return targetEntries;
    }

    public List<String> getIfiles() {
        ArrayList<String> ifiles = new ArrayList<String>();
        List<Node<String, String>> ifileEntries = this.getAllEntriesFor("IFILE");
        for (Node<String, String> ifileEntry : ifileEntries) {
            ifiles.add(ifileEntry.value());
        }
        return ifiles;
    }

    public Node<String, String> removeParameter(Node<String, String> parent, String parameter) {
        Node<String, String> node = parent.remove(parameter);
        if (node != null) {
            this.bubbleUpValues(node.parent());
        }
        return node;
    }

    public void removeParameters(Iterable<String> parameters) {
        HashSet<Node<String, String>> remove = new HashSet<Node<String, String>>();
        for (String string : parameters) {
            for (int i = this.entries.size() - 1; i >= 0; --i) {
                if (!this.entries.get(i).key().toUpperCase().equals(string.toUpperCase())) continue;
                remove.add(this.entries.get(i));
            }
        }
        for (Node node : remove) {
            this.entries.remove(node);
        }
    }

    private void bubbleUpValues(Node<String, String> node) {
        for (Node<String, String> current = node; current != null; current = current.parent()) {
            if (current.children().size() <= 0) continue;
            Object newValue = "";
            for (Node<String, String> child : current.children()) {
                newValue = (String)newValue + "(" + child.value() + ")";
            }
            current.setValue((String)newValue);
        }
    }

    public void updateParameter(String parameter, String value) {
        Node<String, String> n = this.getEntry(parameter);
        if (n == null) {
            this.entries.add(this.parseLine(parameter + "=" + value));
        } else {
            Node<String, String> newNode = this.parseLine(parameter + "=" + value);
            n.setChildren(newNode.children());
            n.setValue(newNode.value());
            this.bubbleUpValues(n.parent());
        }
    }

    public void updateParameters(Map<String, String> parameters) {
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String parameter = entry.getKey();
            String targetvalue = entry.getValue();
            String currentValue = this.getParameterValue(parameter);
            if (currentValue != null && currentValue.equals(targetvalue)) continue;
            this.updateParameter(parameter, targetvalue);
        }
    }

    public boolean addIfile(String ifile) {
        List<String> currentIfiles = this.getIfiles();
        for (String currentIfile : currentIfiles) {
            if (!currentIfile.equals(ifile)) continue;
            return false;
        }
        this.entries.add(new Node<String, String>("IFILE", ifile));
        return true;
    }

    public boolean removeIfile(String ifile) {
        boolean removed = false;
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            Node<String, String> entry = this.entries.get(i);
            if (!entry.key().equals("IFILE") || !entry.value().equals(ifile)) continue;
            this.entries.remove(i);
            removed = true;
        }
        return removed;
    }

    public String getParameterValue(String parameter) {
        Node<String, String> n = this.getEntry(parameter);
        if (n != null) {
            return n.value();
        }
        return null;
    }

    public boolean hasParameter(String parameter) {
        return this.getEntry(parameter) != null;
    }

    public boolean validateParameter(String parameter, String value) {
        Node<String, String> node = this.getEntry(parameter);
        if (node != null) {
            return node.value().equals(value);
        }
        return false;
    }

    public void writeFile() throws IOException, FileNotFoundException {
        this.writeFile(Sqlnet.getSqlnetOraPath().toString());
    }

    public void writeFile(String filePath) throws IOException, FileNotFoundException {
        File file = new File(filePath);
        if (file.exists()) {
            String date = new SimpleDateFormat("ddMMyyyy").format(new Date());
            File target = new File(filePath + "." + date);
            Utils.copyFileContent(file, target);
        }
        FileOutputStream fileStream = new FileOutputStream(filePath);
        OutputStreamWriter fileWriter = new OutputStreamWriter(fileStream);
        for (Node<String, String> entry : this.entries) {
            fileWriter.write(this.getString(entry) + "\n");
        }
        fileWriter.close();
    }

    public String getString(Node<String, String> node) {
        if (node == null) {
            return "";
        }
        return node.key() + "=" + node.value();
    }

    public boolean parameterHas(String parameter, String value) {
        Node<String, String> entry = this.getEntry(parameter);
        if (entry == null) {
            return false;
        }
        return this.entryHas(entry, value);
    }

    public boolean entryHas(Node<String, String> entry, String value) {
        Pattern p = Pattern.compile(".*[\\(,]{1}\\s*" + value.strip() + "\\s*[,\\)]{1}", 2);
        return p.matcher(entry.value()).find();
    }

    public void appendValueToParameter(String parameter, String value) {
        Node<String, String> entry = this.getEntry(parameter);
        if (entry == null) {
            this.entries.add(new Node<String, CallSite>(parameter, (CallSite)((Object)("(" + value + ")"))));
        } else if (!this.entryHas(entry, value)) {
            String currentValue = entry.value().strip();
            Pattern p = Pattern.compile("[\\(]+\\s*(\\S+)\\s*[\\)]+$");
            Matcher m = p.matcher(currentValue);
            if (m.find()) {
                String newValue = "(" + m.group(1) + "," + value + ")";
                this.updateParameter(parameter, newValue);
            }
        }
    }

    public void removeValueFromParameter(String parameter, String value) {
        Node<String, String> entry = this.getEntry(parameter);
        if (entry == null) {
            return;
        }
        if (this.entryHas(entry, value)) {
            CharSequence[] newValueArr;
            String currentValue = entry.value();
            String[] valueArr = entry.value().replaceAll("^\\(|\\)$", "").split(",\\s*", 0);
            if (valueArr.length != (newValueArr = (String[])Arrays.stream(valueArr).filter(val -> !val.toUpperCase().equals(value.toUpperCase())).toArray(String[]::new)).length) {
                if (newValueArr.length == 0) {
                    this.removeParameter(entry.parent(), parameter);
                } else {
                    this.updateParameter(parameter, "(" + String.join((CharSequence)", ", newValueArr) + ")");
                }
            }
        }
    }

    public static Path getSqlnetOraPath() {
        String tnsAdmin;
        Path sqlnetPath = Paths.get(Utils.getOracleBaseHome(), "network", "admin", "sqlnet.ora");
        if (!Files.exists(sqlnetPath, new LinkOption[0]) && (tnsAdmin = System.getenv("TNS_ADMIN")) != null && Files.exists(Paths.get(tnsAdmin, "sqlnet.ora"), new LinkOption[0])) {
            sqlnetPath = Paths.get(tnsAdmin, "sqlnet.ora");
        }
        return sqlnetPath;
    }
}

