/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.ConnectString;
import oracle.dbtools.extension.rcv.models.RMANScript;
import oracle.dbtools.extension.rcv.models.SystemCommand;

public class RMANCommand {
    private ConnectString target;
    private ConnectString catalog;
    private RMANScript rmanScript;
    private String catalogScript;
    private Map<String, String> args;
    private Logger logger;
    private String logFile;
    private String traceFile;
    private boolean append;
    private boolean checkSyntax;
    private boolean debug;
    private String tnsAdmin;
    private String rmanPath;

    private RMANCommand(Builder builder) {
        this.target = builder.target;
        this.catalog = builder.catalog;
        this.rmanScript = builder.rmanScript;
        this.catalogScript = builder.catalogScript;
        this.args = builder.args;
        this.logger = builder.logger;
        this.logFile = builder.logFile;
        this.traceFile = builder.traceFile;
        this.debug = builder.debug;
        this.append = builder.append;
        this.checkSyntax = builder.checkSyntax;
        this.tnsAdmin = builder.tnsAdmin;
        this.rmanPath = RCVCommand.getOracleHome() + "/bin/rman";
    }

    public SystemCommand.ExecutionResult execute() {
        ArrayList<String> rmanArgs = new ArrayList<String>(Arrays.asList(this.rmanPath, "target", this.target.toString(), "catalog", this.catalog.toString()));
        if (this.rmanScript != null) {
            rmanArgs.add("cmdfile='" + this.rmanScript.getScriptPath() + "'");
        } else if (this.catalogScript != null) {
            rmanArgs.add("script");
            rmanArgs.add(this.catalogScript);
        }
        if (this.logFile != null && this.logFile.length() > 0) {
            rmanArgs.add("log");
            rmanArgs.add(String.format("'%s'", this.logFile));
        }
        if (this.traceFile != null && this.traceFile.length() > 0) {
            rmanArgs.add("trace");
            rmanArgs.add(String.format("'%s'", this.traceFile));
        }
        if ((this.logFile != null && this.logFile.length() > 0 || this.traceFile != null && this.traceFile.length() > 0) && this.append) {
            rmanArgs.add("append");
        }
        if (this.args != null && this.args.keySet().size() > 0) {
            rmanArgs.add("using");
            for (int i = 1; i <= this.args.keySet().size(); ++i) {
                if (!this.args.containsKey("" + i)) continue;
                rmanArgs.add("'" + this.args.get("" + i) + "'");
            }
        }
        if (this.tnsAdmin != null) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("TNS_ADMIN", this.tnsAdmin);
            return new SystemCommand(env, this.logger).run(rmanArgs, false);
        }
        return new SystemCommand(this.logger).run(rmanArgs, false);
    }

    public static class Builder {
        private ConnectString target;
        private ConnectString catalog;
        private RMANScript rmanScript;
        private String catalogScript;
        private Map<String, String> args;
        private String logFile;
        private String traceFile;
        private boolean append;
        private boolean debug;
        private boolean checkSyntax;
        private String tnsAdmin;
        private Logger logger;

        public Builder(ConnectString target, ConnectString catalog, RMANScript rmanScript) {
            this.target = target;
            this.catalog = catalog;
            this.rmanScript = rmanScript;
        }

        public Builder(ConnectString target, ConnectString catalog, String catalogScript) {
            this.target = target;
            this.catalog = catalog;
            this.catalogScript = catalogScript;
        }

        public Builder args(Map<String, String> args) {
            this.args = args;
            return this;
        }

        public Builder append(boolean append) {
            this.append = append;
            return this;
        }

        public Builder checkSyntax(boolean checkSyntax) {
            this.checkSyntax = checkSyntax;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder rmanScript(RMANScript rmanScript) {
            this.rmanScript = rmanScript;
            return this;
        }

        public Builder catalogScript(String catalogScript) {
            this.catalogScript = catalogScript;
            return this;
        }

        public Builder tnsAdmin(String tnsAdmin) {
            this.tnsAdmin = tnsAdmin;
            return this;
        }

        public Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder traceFile(String traceFile) {
            this.traceFile = traceFile;
            return this;
        }

        public RMANCommand build() {
            return new RMANCommand(this);
        }
    }
}

