/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

public class ConnectString {
    private String username;
    private String password;
    private String host;
    private int port;
    private String serviceName;
    private String alias;

    private ConnectString(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.host = builder.host;
        this.port = builder.port;
        this.serviceName = builder.serviceName;
        this.alias = builder.alias;
    }

    public String toString() {
        if (this.alias != null && this.alias.length() > 0) {
            return "/@" + this.alias;
        }
        String string = this.username + "/" + this.password;
        if (this.host != null && this.host.length() > 0 && this.port > 0 && this.serviceName != null && this.serviceName.length() > 0) {
            string = string + "@" + this.host + ":" + this.port + "/" + this.serviceName;
        }
        return string;
    }

    public static class Builder {
        private String username;
        private String password;
        private String host;
        private int port;
        private String serviceName;
        private String alias;

        public Builder() {
            this.username = "";
            this.password = "";
            this.serviceName = "";
            this.host = "";
            this.alias = "";
        }

        public Builder(String host, int port, String serviceName) {
            this.host = host;
            this.port = port;
            this.serviceName = serviceName;
            this.username = "";
            this.password = "";
            this.host = "";
            this.alias = "";
        }

        public Builder(String username, String password, String serviceName) {
            this.username = username;
            this.password = password;
            this.serviceName = serviceName;
            this.host = "";
            this.alias = "";
        }

        public Builder(String alias) {
            this.alias = alias;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ConnectString build() {
            return new ConnectString(this);
        }
    }
}

