/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.controllers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;
import oracle.dbtools.extension.rcv.models.WalletEntry;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class WalletManager {
    public static final String CREDENTIAL_CONNECT_STRING = "oracle.security.client.connect_string";
    public static final String CREDENTIAL_USERNAME = "oracle.security.client.username";
    public static final String CREDENTIAL_PASSWORD = "oracle.security.client.password";
    public static final String WALLET_FILE = "cwallet.sso";

    public static boolean walletContainsConnectString(OracleWallet wallet, String alias) throws IOException, OracleSecretStoreException {
        return WalletManager.storeContainsConnectString(wallet.getSecretStore(), alias);
    }

    public static boolean walletContainsUser(OracleWallet wallet, String userName) {
        try {
            return WalletManager.storeContainsUser(wallet.getSecretStore(), userName);
        }
        catch (Exception e) {
            String error = String.format("Failed to open a wallet.", new Object[0]);
            throw Result.walletWalletWorkException(error, e);
        }
    }

    public static boolean storeContainsUser(OracleSecretStore store, String userName) {
        try {
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                String storeUserName;
                String field = (String)e.nextElement();
                if (!field.startsWith(CREDENTIAL_USERNAME) || !(storeUserName = new String(store.getSecret(field))).equals(userName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            String error = String.format("Failed to locate credentials for the user \"%s\".", userName);
            throw Result.walletWalletWorkException(error, e);
        }
        return false;
    }

    public static boolean storeContainsConnectString(OracleSecretStore store, String alias) {
        try {
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                String connectString;
                String field = (String)e.nextElement();
                if (!field.startsWith(CREDENTIAL_CONNECT_STRING) || !(connectString = new String(store.getSecret(field))).equalsIgnoreCase(alias)) continue;
                return true;
            }
        }
        catch (Exception e) {
            String error = String.format("Failed to locate connect string for the alias \"%s\".", alias);
            throw Result.walletWalletWorkException(error, e);
        }
        return false;
    }

    public static char[] getSecretForUser(OracleWallet wallet, String targetUser) throws OracleSecretStoreException, IOException {
        OracleSecretStore store = wallet.getSecretStore();
        Enumeration e = store.internalAliases();
        while (e.hasMoreElements()) {
            String user;
            String field = (String)e.nextElement();
            if (!field.startsWith(CREDENTIAL_USERNAME) || !(user = new String(store.getSecret(field))).equals(targetUser)) continue;
            String id = field.substring(CREDENTIAL_USERNAME.length());
            return store.getSecret(CREDENTIAL_PASSWORD + id);
        }
        return null;
    }

    public static char[] getSecretForAlias(OracleWallet wallet, String alias) throws OracleSecretStoreException, IOException {
        OracleSecretStore store = wallet.getSecretStore();
        Enumeration e = store.internalAliases();
        while (e.hasMoreElements()) {
            String connectString;
            String field = (String)e.nextElement();
            if (!field.startsWith(CREDENTIAL_CONNECT_STRING) || !(connectString = new String(store.getSecret(field))).equals(alias)) continue;
            String id = field.substring(CREDENTIAL_CONNECT_STRING.length());
            return store.getSecret(CREDENTIAL_PASSWORD + id);
        }
        return null;
    }

    public static void updateAlias(OracleWallet wallet, String oldAlias, String newAlias) throws IOException, OracleSecretStoreException {
        if (oldAlias.equals(newAlias)) {
            return;
        }
        OracleSecretStore store = wallet.getSecretStore();
        Enumeration e = store.internalAliases();
        while (e.hasMoreElements()) {
            String connectString;
            String field = (String)e.nextElement();
            if (!field.startsWith(CREDENTIAL_CONNECT_STRING) || !(connectString = new String(store.getSecret(field))).equals(oldAlias)) continue;
            store.setSecret(field, newAlias.toCharArray());
            wallet.setSecretStore(store);
            wallet.save();
            return;
        }
    }

    public static OracleWallet getWallet(String path) throws IOException {
        OracleWallet oraWallet = new OracleWallet();
        oraWallet.setLocation(path);
        oraWallet.open(path, null);
        try {
            OracleSecretStore store = oraWallet.getSecretStore();
            oraWallet.setSecretStore(store);
            oraWallet.save();
        }
        catch (OracleSecretStoreException e) {
            System.out.println("Oracle Secret Store Exception: " + e.getMessage());
        }
        return oraWallet;
    }

    public static OracleWallet createWallet(String path) {
        boolean bWalletConf = false;
        OracleWallet oraWallet = new OracleWallet();
        try {
            oraWallet.setLocation(path);
            if (!oraWallet.exists(path)) {
                oraWallet.createSSO();
                oraWallet.saveAs(path);
            }
            oraWallet.open(path, null);
            OracleSecretStore store = oraWallet.getSecretStore();
            oraWallet.setSecretStore(store);
            oraWallet.save();
        }
        catch (IOException | OracleSecretStoreException e) {
            String error = String.format("Failed to create wallet in \"%s\".", path);
            throw Result.walletCreateWalletException(error, (Exception)e);
        }
        return oraWallet;
    }

    public static OracleWallet createWallet(String path, String password) {
        byte bWalletConf = 0;
        OracleWallet wallet = new OracleWallet();
        try {
            wallet.setLocation(path);
            if (!wallet.exists(path)) {
                wallet.create(password.toCharArray());
                wallet.saveAs(path, bWalletConf);
            }
        }
        catch (IOException e) {
            String error = String.format("Failed to create password-protected wallet in \"%s\".", path);
            throw Result.walletCreateWalletException(error, e);
        }
        return wallet;
    }

    public static void addCertificate(OracleWallet wallet, String certificateString) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        wallet.importCertB64(certificateString, true);
        wallet.save();
    }

    public static void addCertificate(OracleWallet wallet, Path certificatePath) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try {
            String text = Files.readString(certificatePath);
            wallet.importCertB64(text, true);
            wallet.save();
        }
        catch (IOException e) {
            System.out.println("Failed to store ssl certificate: " + e.getMessage());
        }
    }

    public static void addCredential(OracleWallet wallet, String user, String password, String alias) {
        try {
            OracleSecretStore store = wallet.getSecretStore();
            if (WalletManager.storeContainsConnectString(store, alias)) {
                store.modifyCredential(alias.toCharArray(), user.toCharArray(), password.toCharArray());
            } else {
                store.createCredential(alias.toCharArray(), user.toCharArray(), password.toCharArray());
            }
            wallet.setSecretStore(store);
            wallet.save();
        }
        catch (IOException | OracleSecretStoreException e) {
            String error = String.format("Failed to update wallet in \"%s\".", wallet.getLocation());
            throw Result.walletAddCredentialException(error, (Exception)e);
        }
    }

    public static String getWalletRoot(Connection conn) {
        return DatabaseUtils.getParameter(conn, "WALLET_ROOT");
    }

    public static void migrateWallet(String sourceWalletDirectory, String targetWalletDirectory) throws IOException, KeyStoreException, OracleSecretStoreException, NoSuchAlgorithmException, CertificateException {
        String srcWalletFile;
        Path srcWalletFilePath;
        if (Files.exists(Paths.get(sourceWalletDirectory, new String[0]), new LinkOption[0]) && Files.exists(Paths.get(targetWalletDirectory, new String[0]), new LinkOption[0]) && !sourceWalletDirectory.equals(targetWalletDirectory) && Files.exists(srcWalletFilePath = Paths.get(srcWalletFile = String.join((CharSequence)File.separator, sourceWalletDirectory, WALLET_FILE), new String[0]), new LinkOption[0])) {
            HashMap<String, WalletEntry.Builder> walletEntries = new HashMap<String, WalletEntry.Builder>();
            OracleWallet srcWallet = WalletManager.createWallet(sourceWalletDirectory);
            OracleWallet targetWallet = WalletManager.createWallet(targetWalletDirectory);
            OracleSecretStore store = srcWallet.getSecretStore();
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                WalletEntry.Builder builder;
                String field = (String)e.nextElement();
                String id = null;
                if (field.startsWith(CREDENTIAL_CONNECT_STRING)) {
                    String connectString = new String(store.getSecret(field));
                    id = field.substring(CREDENTIAL_CONNECT_STRING.length());
                    builder = walletEntries.getOrDefault(id, new WalletEntry.Builder());
                    walletEntries.put(id, builder.credentialAlias(connectString));
                    continue;
                }
                if (field.startsWith(CREDENTIAL_USERNAME)) {
                    String username = new String(store.getSecret(field));
                    id = field.substring(CREDENTIAL_USERNAME.length());
                    builder = walletEntries.getOrDefault(id, new WalletEntry.Builder());
                    walletEntries.put(id, builder.username(username));
                    continue;
                }
                if (!field.startsWith(CREDENTIAL_PASSWORD)) continue;
                String password = new String(store.getSecret(field));
                id = field.substring(CREDENTIAL_PASSWORD.length());
                builder = walletEntries.getOrDefault(id, new WalletEntry.Builder());
                walletEntries.put(id, builder.password(password));
            }
            for (String id : walletEntries.keySet()) {
                WalletEntry.Builder builder = (WalletEntry.Builder)walletEntries.get(id);
                WalletEntry entry = builder.build();
                WalletManager.addCredential(targetWallet, entry.getUserName(), entry.getPassword(), entry.getCredentialAlias());
            }
            KeyStore keystore = srcWallet.getKeyStore();
            Enumeration<String> keystoreAliases = keystore.aliases();
            KeyStore targetKeyStore = targetWallet.getKeyStore();
            while (keystoreAliases.hasMoreElements()) {
                String alias = keystoreAliases.nextElement();
                Certificate cert = keystore.getCertificate(alias);
                if (targetKeyStore.containsAlias(alias)) {
                    targetKeyStore.deleteEntry(alias);
                }
                if (cert == null) continue;
                targetKeyStore.setCertificateEntry(alias, cert);
            }
        }
    }
}

