/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.controllers;

import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.controllers.RMANScriptFactory;
import oracle.dbtools.extension.rcv.models.ConnectString;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.RMANCommand;
import oracle.dbtools.extension.rcv.models.RMANScript;
import oracle.dbtools.extension.rcv.models.SystemCommand;
import oracle.dbtools.extension.rcv.models.task.Task;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;

public class TaskManager {
    public static Result executeTask(Task task, String logFile) throws SQLException, IOException {
        int type = task.getType();
        int id = task.getId();
        Clob clobContent = task.getContent();
        String dbUniqueName = task.getDbUniqueName();
        Object scriptPath = task.getScriptPath();
        if (type == 1) {
            return new Result(Status.SUCCESS);
        }
        if (type == 2) {
            int i = ((String)scriptPath).lastIndexOf(".");
            if (i > 0 && i < ((String)scriptPath).length() - 1) {
                String extension = ((String)scriptPath).substring(i + 1);
                if (!extension.equals("rman")) {
                    scriptPath = (String)scriptPath + ".rman";
                }
            } else {
                scriptPath = (String)scriptPath + ".rman";
            }
            RMANScript rmanScript = RMANScriptFactory.generateScriptFromClob((String)scriptPath, clobContent);
            ProtectedDatabaseMetadata metadata = RCVCommand.getProtectedDatabaseMetadata(dbUniqueName);
            ConnectString target = new ConnectString.Builder().build();
            ConnectString catalog = new ConnectString.Builder(metadata.getCredentialAlias()).build();
            RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).tnsAdmin(metadata.getNetworkDirectory()).logFile(logFile).build();
            SystemCommand.ExecutionResult rmanTaskResult = rmanCommand.execute();
            if (rmanTaskResult.getReturnCode() == 0) {
                return new Result(Status.SUCCESS);
            }
            return Result.ftwRmanScriptError(rmanTaskResult.getOutput());
        }
        if (type == 3) {
            return new Result(Status.SUCCESS);
        }
        if (type == 4) {
            String error = String.format("Database %s is not configured. Please run 'rcv configure protected_database' to configure the database.", dbUniqueName);
            return Result.ftwDbNotConfiguredError(error);
        }
        if (type == 5) {
            String error = String.format("Database %s is not registered with the fleet engine. Please run 'rcv add protected_database' to register the database.", dbUniqueName);
            return Result.ftwDbNotRegisteredError(error);
        }
        if (type == 6) {
            String error = String.format("Incorrect action id %d", id);
            return Result.ftwIncorrectActionError(error);
        }
        if (type == 9) {
            String error = String.format("Task %d is expired.", id);
            return Result.ftwTaskExpiredError(error);
        }
        return Result.ftwTaskUnknownError(String.format("An unrecognized action type '%s' was returned by the fleet engine.", type));
    }
}

