/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.controllers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Map;
import oracle.dbtools.extension.rcv.models.RMANScript;

public class RMANScriptFactory {
    public static final String ARCHIVED_REDO_LOG_BACKUP = "backup_archived_redo_logs.rman";
    public static final String CONTROLFILE_BACKUP = "backup_controlfile.rman";
    public static final String INCREMENTAL_BACKUP = "incremental_backup.rman";
    public static final String REGISTER_DATABASE = "register_database.rman";
    public static final String SPFILE_BACKUP = "backup_spfile.rman";
    private static final Map<String, String> md5sums = Map.of("backup_controlfile.rman", "5f3d18c1f96ccc4746a2b35ca680eeb2", "register_database.rman", "c5debdd02ffacec1db49a3ac1a2daab9", "backup_spfile.rman", "4dc71ea1128608266cb0412b91fd5e91");

    public static RMANScript generateScriptFromClob(String scriptPath, Clob content) throws IOException, SQLException {
        int bytesRead;
        Reader reader = content.getCharacterStream();
        FileWriter writer = new FileWriter(scriptPath);
        char[] buffer = new char[8192];
        while ((bytesRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, bytesRead);
        }
        reader.close();
        writer.close();
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateRegisterDatabaseScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, REGISTER_DATABASE);
        File script = new File(scriptPath);
        if (!script.exists()) {
            FileWriter fWriter = new FileWriter(scriptPath);
            fWriter.write("register database;");
            fWriter.close();
        }
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateIncrementalBackupScript(String scriptsDirectory, int channels) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, INCREMENTAL_BACKUP);
        File script = new File(scriptPath);
        if (!script.exists()) {
            FileWriter fWriter = new FileWriter(scriptPath);
            fWriter.write("set echo on;\n");
            fWriter.write("SET COMPRESSION ALGORITHM 'low' AS OF RELEASE 'DEFAULT' OPTIMIZE FOR LOAD TRUE;\n");
            fWriter.write("show all;\n");
            fWriter.write("RUN\n");
            fWriter.write("{\n");
            fWriter.write("configure encryption for database ON;\n");
            for (int i = 0; i < channels; ++i) {
                String allocateChannel = String.format("ALLOCATE CHANNEL 'T%d' DEVICE TYPE 'SBT_TAPE' PARMS \"SBT_LIBRARY=%s, ENV=(RA_WALLET='location=file:%s credential_alias=%s',RA_FORMAT=TRUE)\";\n", i, "&1", "&2", "&3");
                fWriter.write(allocateChannel);
            }
            fWriter.write(String.format("BACKUP TAG '%s' CUMULATIVE INCREMENTAL LEVEL 1  FILESPERSET 1  SECTION SIZE 64G DATABASE  PLUS ARCHIVELOG  FILESPERSET 1 NOT BACKED UP ;\n", "&4"));
            fWriter.write("}");
            fWriter.close();
        }
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateArchivedRedoLogsBackupScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, ARCHIVED_REDO_LOG_BACKUP);
        File script = new File(scriptPath);
        if (!script.exists()) {
            FileWriter fWriter = new FileWriter(scriptPath);
            fWriter.write("RUN {\n");
            fWriter.write(String.format("ALLOCATE CHANNEL 'T0' DEVICE TYPE 'SBT_TAPE' PARMS \"SBT_LIBRARY=%s, ENV=(RA_WALLET='location=file:%s credential_alias=%s',RA_FORMAT=TRUE)\";\n", "&1", "&2", "&3"));
            fWriter.write("BACKUP AS BACKUPSET ARCHIVELOG ALL NOT BACKED UP  FILESPERSET 1;\n");
            fWriter.write("}\n");
            fWriter.close();
        }
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateControlFileBackupScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, CONTROLFILE_BACKUP);
        File script = new File(scriptPath);
        if (!script.exists()) {
            FileWriter fWriter = new FileWriter(scriptPath);
            fWriter.write("CONFIGURE CONTROLFILE AUTOBACKUP ON;\n");
            fWriter.write("RUN {\n");
            fWriter.write(String.format("ALLOCATE CHANNEL 'T0' DEVICE TYPE 'SBT_TAPE' PARMS \"SBT_LIBRARY=%s, ENV=(RA_WALLET='location=file:%s credential_alias=%s',RA_FORMAT=TRUE)\";\n", "&1", "&2", "&3"));
            fWriter.write("BACKUP CURRENT CONTROLFILE;\n");
            fWriter.write("}\n");
            fWriter.close();
        }
        return new RMANScript(scriptPath);
    }

    public static RMANScript generateSpfileBackupScript(String scriptsDirectory) throws IOException {
        String scriptPath = String.join((CharSequence)File.separator, scriptsDirectory, SPFILE_BACKUP);
        File script = new File(scriptPath);
        if (!script.exists()) {
            FileWriter fWriter = new FileWriter(scriptPath);
            fWriter.write("RUN {\n");
            fWriter.write(String.format("ALLOCATE CHANNEL 'T0' DEVICE TYPE 'SBT_TAPE' PARMS \"SBT_LIBRARY=%s, ENV=(RA_WALLET='location=file:%s credential_alias=%s',RA_FORMAT=TRUE)\";\n", "&1", "&2", "&3"));
            fWriter.write("BACKUP SPFILE;\n");
            fWriter.write("}\n");
            fWriter.close();
        }
        return new RMANScript(scriptPath);
    }
}

