/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.controllers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.dbtools.extension.rcv.commands.RCVCommand;

public class LogManager {
    private static Handler consoleHandler = new ConsoleHandler();
    private static ConsoleHandler actionHandler = new ConsoleHandler();
    private static HashMap<String, Logger> loggers;
    private static HashMap<String, String> logFiles;
    private static Level logLevel;

    private LogManager() {
    }

    public static Logger getLogger(String workflowName, String dbUniqueName) {
        Logger logger;
        String logDirectory = RCVCommand.getLogDirectory(dbUniqueName);
        if (!loggers.containsKey(workflowName)) {
            logger = Logger.getLogger(workflowName);
            logger.setLevel(logLevel);
            logger.setUseParentHandlers(false);
            consoleHandler.setFormatter(new CustomFormatter());
            logger.addHandler(consoleHandler);
            Path path = Paths.get(logDirectory, new String[0]);
            String logFile = LogManager.getLogFile(workflowName, dbUniqueName);
            logFiles.put(workflowName, logFile);
            try {
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                FileHandler fileHandler = new FileHandler(logFile, true);
                Filter fileFilter = new Filter(){

                    @Override
                    public boolean isLoggable(LogRecord record) {
                        return true;
                    }
                };
                fileHandler.setFilter(fileFilter);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, String.format("Failed to create log file for workflow %s: %s", workflowName, e.getMessage()));
            }
            Filter consoleFilter = new Filter(){

                @Override
                public boolean isLoggable(LogRecord record) {
                    if (record.getLevel().intValue() == Level.WARNING.intValue()) {
                        return false;
                    }
                    return record.getLevel().intValue() >= Level.INFO.intValue();
                }
            };
            consoleHandler.setFilter(consoleFilter);
            logger.addHandler(actionHandler);
            loggers.put(workflowName, logger);
        }
        if (!(logger = loggers.get(workflowName)).getLevel().equals(logLevel)) {
            logger.setLevel(logLevel);
        }
        return logger;
    }

    public static String getLogFile(String workflowName, String dbUniqueName) {
        String logName = workflowName.replaceAll("\\s+", "_") + ".log";
        String logDirectory = RCVCommand.getLogDirectory(dbUniqueName);
        return String.join((CharSequence)File.separator, logDirectory, logName);
    }

    public static void setLogLevel(Level newLevel) {
        logLevel = newLevel;
    }

    static {
        actionHandler.setLevel(Level.WARNING);
        actionHandler.setFormatter(new SimpleFormatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        });
        loggers = new HashMap();
        logFiles = new HashMap();
        logLevel = Level.FINE;
    }

    private static class CustomFormatter
    extends SimpleFormatter {
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private CustomFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String timestamp = dateFormat.format(new Date(record.getMillis()));
            return timestamp + ": " + record.getMessage() + "\n";
        }
    }
}

