/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.controllers;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.models.commandengine.UpdateActionStatusRequest;

public class FleetEngine {
    private static final String DBMS_RA_CMD_ENGINE = "dbms_ra_cmd_engine";
    private static final String INIT = "dbms_ra_cmd_engine.init(?, ?, ?, ?, ?)";
    private static final String CONFIGURE = "dbms_ra_cmd_engine.configure(?, ?, ?, ?)";
    private static final String CONFIGURE_WALLET_LOCATION = "dbms_ra_cmd_engine.configure_wallet(?, ?, ?)";
    private static final String CONFIGURE_CREDENTIAL_ALIAS = "dbms_ra_cmd_engine.configure_credential_alias(?, ?, ?)";
    private static final String CONFIGURE_MAX_CHANNELS = "dbms_ra_cmd_engine.configure_maxChannels(?, ?, ?)";
    private static final String CONFIGURE_LIBRA_LOCATION = "dbms_ra_cmd_engine.configure_libra(?, ?, ?)";
    private static final String UPDATE_ACTION_STATUS = "dbms_ra_cmd_engine.action_status(?, ?, ?, ?, ?)";
    private static final String NEXT_ACTION = "dbms_ra_cmd_engine.next_action(?, ?, ?, ?, ?)";
    private static final String GET_ACTION = "dbms_ra_cmd_engine.get_action(?, ?, ?, ?)";
    public static final int DATABASE_NOT_REGISTERED = 5;
    public static final int FAIL = 100;
    public static final int SUCCESS = 200;
    public static final Map<Integer, String> returnCodes = new HashMap<Integer, String>(){
        {
            this.put(100, "FAIL");
            this.put(200, "SUCCESS");
            this.put(5, "DATABASE_NOT_REGISTERED");
        }
    };

    public static String getMessage(int returnCode) {
        return returnCodes.get(returnCode);
    }

    public static Connection getEngineConnection(String tnsAdmin, String walletLocation, String credentialAlias) throws SQLException {
        System.setProperty("oracle.net.tns_admin", tnsAdmin);
        System.setProperty("oracle.net.wallet_location", walletLocation);
        String url = "jdbc:oracle:thin:@" + credentialAlias;
        return DriverManager.getConnection(url);
    }

    public static Connection getEngineConnection(ProtectedDatabaseMetadata metadata) throws SQLException {
        return FleetEngine.getEngineConnection(metadata.getNetworkDirectory(), metadata.getWalletLocation(), metadata.getCredentialAlias());
    }

    public static FleetEngineResponse updateActionStatus(UpdateActionStatusRequest request) throws SQLException {
        CallableStatement cs = request.getCallableStatement();
        cs.execute();
        int statusCode = cs.getInt("O_STATUS_CODE");
        String statusMessage = cs.getString("O_STATUS_MESSAGE");
        return new FleetEngineResponse(statusCode, statusMessage, null);
    }

    public static FleetEngineResponse updateActionStatus(Connection conn, String dbUniqueName, int agentId, int actionId) throws SQLException {
        UpdateActionStatusRequest request = new UpdateActionStatusRequest.Builder(conn, dbUniqueName, agentId, actionId).build();
        return FleetEngine.updateActionStatus(request);
    }

    public static FleetEngineResponse updateActionStatus(Connection conn, String dbUniqueName, int agentId, int actionId, int errorNum, String errorString) throws SQLException {
        UpdateActionStatusRequest request = new UpdateActionStatusRequest.Builder(conn, dbUniqueName, agentId, actionId).errorNum(errorNum).errorString(errorString).build();
        return FleetEngine.updateActionStatus(request);
    }

    public static <T extends FleetEngineRequest> FleetEngineResponse retry(int maxErrorCount, T request) throws SQLException {
        FleetEngineResponse response = null;
        for (int errorCount = 0; errorCount < maxErrorCount; ++errorCount) {
            response = request.execute();
            FleetEngineResponse.Status status = response.getStatus();
            if (status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                return response;
            }
            if (status.equals((Object)FleetEngineResponse.Status.FAIL_DATABASE_NOT_CONFIGURED) || status.equals((Object)FleetEngineResponse.Status.FAIL_DATABASE_NOT_REGISTERED) || status.equals((Object)FleetEngineResponse.Status.FAIL_INCORRECT_ACTION_ID)) continue;
            return response;
        }
        return response;
    }
}

