/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.extension.rcv.common.Utils;
import oracle.dbtools.extension.rcv.controllers.WalletManager;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.ProtectedDatabaseMetadata;
import oracle.security.pki.OracleWallet;

public class ConfigurationManager {
    private static final String RCV_CONF = "rcv.conf.txt";
    private static final String CERT_PEM = "certChainPem.txt";
    private static final String LOG_ARCHIVE_DESTION_GROUPS = "logArchiveDestinationGroups";
    private static final String LOG_ARCHIVE_CONFIG = "logArchiveConfig";

    public static String getRcvConf(ProtectedDatabaseMetadata metadata) {
        return metadata.getNetworkDirectory() + File.separatorChar + RCV_CONF;
    }

    public static void updateClientConfiguration(String configArchive, ProtectedDatabaseMetadata metadata) throws FileNotFoundException, IOException {
        String networkDirectory = metadata.getNetworkDirectory();
        String walletLocation = metadata.getWalletLocation();
        String dbrsNames = networkDirectory + File.separatorChar + "dbrsnames.ora.txt";
        Utils.unzipFile(configArchive, networkDirectory);
        File dbrsNamesFile = new File(dbrsNames);
        if (!dbrsNamesFile.exists()) {
            String error = String.format("Unzipped %s to %s, but could not find %s", configArchive, networkDirectory, dbrsNames);
            throw new FileNotFoundException(error);
        }
        String tnsNames = String.join((CharSequence)File.separator, networkDirectory, "tnsnames.ora");
        File tnsNamesFile = new File(tnsNames);
        if (tnsNamesFile.exists()) {
            Utils.copyFileContent(tnsNames, tnsNames + ".good");
        }
        Utils.copyFileContent(dbrsNames, tnsNames);
        try {
            OracleWallet wallet = WalletManager.createWallet(walletLocation);
            WalletManager.addCertificate(wallet, Paths.get(networkDirectory + File.separatorChar + CERT_PEM, new String[0]));
        }
        catch (KeyStoreException e) {
            String error = e.getMessage();
            if (!error.startsWith("PKI-04003: The trusted certificate is already present in the wallet.")) {
                System.out.println("Encountered failure while configuring wallet: " + error);
                return;
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("NoSuchAlgorithmException " + e.getMessage());
        }
        catch (CertificateException e) {
            String error = e.getMessage();
            System.out.println("Certificate exception: " + error);
        }
        Utils.updateSqlnetOraTLS(metadata, true);
    }

    public static void restoreLastConfiguration(ProtectedDatabaseMetadata metadata) throws IOException {
        String networkDirectory = metadata.getNetworkDirectory();
        String goodTnsNames = String.join((CharSequence)File.separator, networkDirectory, "tnsnames.ora.good");
        String tnsNames = String.join((CharSequence)File.separator, networkDirectory, "tnsnames.ora");
        Files.move(Paths.get(goodTnsNames, new String[0]), Paths.get(tnsNames, new String[0]), new CopyOption[0]);
    }

    public static String getCatalogAlias(ProtectedDatabaseMetadata metadata) throws IOException {
        return ConfigurationManager.getCatalogAlias(metadata.getNetworkDirectory() + File.separator + RCV_CONF);
    }

    public static String getCatalogAlias(String rcvConfFile) throws IOException {
        ObjectMapper objectMapper;
        JsonNode jsonNode;
        if (Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) && (jsonNode = (objectMapper = new ObjectMapper()).readTree(new File(rcvConfFile))).has("schema") && jsonNode.has("version")) {
            int schema = jsonNode.get("schema").asInt();
            int version = jsonNode.get("version").asInt();
            if (schema == 1 && version == 1) {
                if (jsonNode.has("actions") && jsonNode.path("actions").has("rmanCatalogConnection")) {
                    return jsonNode.path("actions").path("rmanCatalogConnection").get(0).path("payload").get(0).asText();
                }
            } else if (schema == 1 && version > 1 && jsonNode.has("currentState") && jsonNode.path("currentState").has("rmanCatalogConnection")) {
                return jsonNode.path("currentState").get("rmanCatalogConnection").asText();
            }
        }
        return null;
    }

    public static List<String> getWalletEntries(ProtectedDatabaseMetadata metadata) throws IOException {
        return ConfigurationManager.getWalletEntries(ConfigurationManager.getRcvConf(metadata));
    }

    public static List<String> getWalletEntries(String rcvConfFile) throws IOException {
        ArrayList<String> aliases;
        block4: {
            JsonNode tnsAliasesNode;
            JsonNode walletEntriesNode;
            int version;
            int schema;
            JsonNode jsonNode;
            block5: {
                JsonNode walletEntriesNode2;
                ObjectMapper objectMapper;
                aliases = new ArrayList<String>();
                if (!Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) || !(jsonNode = (objectMapper = new ObjectMapper()).readTree(new File(rcvConfFile))).has("schema") || !jsonNode.has("version")) break block4;
                schema = jsonNode.get("schema").asInt();
                version = jsonNode.get("version").asInt();
                if (schema != 1 || version != 1) break block5;
                if (!jsonNode.has("actions") || !jsonNode.path("actions").has("walletEntries") || !(walletEntriesNode2 = jsonNode.path("actions").path("walletEntries")).isArray()) break block4;
                for (JsonNode entry : walletEntriesNode2) {
                    JsonNode payloadNode;
                    if (!entry.has("operationType") || !entry.get("operationType").asText().equalsIgnoreCase("ADD") || !entry.has("payload") || !(payloadNode = entry.get("payload")).isArray()) continue;
                    for (JsonNode alias : payloadNode) {
                        aliases.add(alias.asText());
                    }
                }
                break block4;
            }
            if (schema == 1 && version > 1 && jsonNode.has("currentState") && jsonNode.path("currentState").has("walletEntries") && (walletEntriesNode = jsonNode.path("currentState").path("walletEntries")).has("tnsAliases") && (tnsAliasesNode = walletEntriesNode.path("tnsAliases")).isArray()) {
                for (JsonNode alias : tnsAliasesNode) {
                    aliases.add(alias.asText());
                }
            }
        }
        return aliases;
    }

    public static String getVpcUserName(String rcvConfFile) throws IOException {
        ObjectMapper objectMapper;
        JsonNode jsonNode;
        if (Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) && (jsonNode = (objectMapper = new ObjectMapper()).readTree(new File(rcvConfFile))).has("schema") && jsonNode.has("version")) {
            JsonNode walletEntriesNode;
            int schema = jsonNode.get("schema").asInt();
            int version = jsonNode.get("version").asInt();
            if (schema == 1 && version > 1 && jsonNode.has("actions") && jsonNode.path("actions").has("walletEntries") && (walletEntriesNode = jsonNode.path("actions").path("walletEntries")).has("vpcUser")) {
                return walletEntriesNode.get("vpcUser").asText();
            }
        }
        return null;
    }

    public static List<String> getLogArchiveConfig(String rcvConfFile) throws IOException {
        ArrayList<String> destinationNames;
        block3: {
            JsonNode configsNode;
            int version;
            int schema;
            JsonNode jsonNode;
            block4: {
                JsonNode payloadNode;
                JsonNode firstConfigNode;
                JsonNode configsNode2;
                ObjectMapper objectMapper;
                destinationNames = new ArrayList<String>();
                if (!Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) || !(jsonNode = (objectMapper = new ObjectMapper()).readTree(new File(rcvConfFile))).has("schema") || !jsonNode.has("version")) break block3;
                schema = jsonNode.get("schema").asInt();
                version = jsonNode.get("version").asInt();
                if (schema != 1 || version != 1) break block4;
                if (!jsonNode.has("actions") || !jsonNode.path("actions").has(LOG_ARCHIVE_CONFIG) || !(configsNode2 = jsonNode.path("actions").path(LOG_ARCHIVE_CONFIG)).isArray() || !configsNode2.iterator().hasNext() || !(firstConfigNode = configsNode2.get(0)).has("payload") || !(payloadNode = firstConfigNode.path("payload")).isArray()) break block3;
                for (JsonNode node : payloadNode) {
                    destinationNames.add(node.asText());
                }
                break block3;
            }
            if (schema == 1 && version > 1 && jsonNode.has("currentState") && jsonNode.path("currentState").has(LOG_ARCHIVE_CONFIG) && (configsNode = jsonNode.path("currentState").path(LOG_ARCHIVE_CONFIG)).isArray()) {
                for (JsonNode node : configsNode) {
                    destinationNames.add(node.asText());
                }
            }
        }
        return destinationNames;
    }

    public static List<LogArchiveDestination> getLogArchiveDestinationGroups(String rcvConfFile) throws IOException {
        ArrayList<LogArchiveDestination> destinations;
        block3: {
            JsonNode firstGroupNode;
            JsonNode groupsNode;
            int version;
            int schema;
            ObjectMapper objectMapper;
            JsonNode jsonNode;
            block4: {
                JsonNode firstPayloadNode;
                JsonNode payloadNode;
                JsonNode firstGroupNode2;
                JsonNode groupsNode2;
                destinations = new ArrayList<LogArchiveDestination>();
                if (!Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) || !(jsonNode = (objectMapper = new ObjectMapper()).readTree(new File(rcvConfFile))).has("schema") || !jsonNode.has("version")) break block3;
                schema = jsonNode.get("schema").asInt();
                version = jsonNode.get("version").asInt();
                if (schema != 1 || version != 1) break block4;
                if (!jsonNode.has("actions") || !jsonNode.path("actions").has(LOG_ARCHIVE_DESTION_GROUPS) || !(groupsNode2 = jsonNode.path("actions").path(LOG_ARCHIVE_DESTION_GROUPS)).isArray() || !groupsNode2.iterator().hasNext() || !(firstGroupNode2 = groupsNode2.get(0)).has("payload") || !(payloadNode = firstGroupNode2.path("payload")).isArray() || !payloadNode.iterator().hasNext() || !(firstPayloadNode = payloadNode.get(0)).isArray()) break block3;
                for (JsonNode destinationNode : firstPayloadNode) {
                    LogArchiveDestination destination = (LogArchiveDestination)objectMapper.readValue(destinationNode.toString(), LogArchiveDestination.class);
                    destination.setGroup(1);
                    destinations.add(destination);
                }
                break block3;
            }
            if (schema == 1 && version > 1 && jsonNode.has("currentState") && jsonNode.path("currentState").has(LOG_ARCHIVE_DESTION_GROUPS) && (groupsNode = jsonNode.path("currentState").path(LOG_ARCHIVE_DESTION_GROUPS)).isArray() && groupsNode.iterator().hasNext() && (firstGroupNode = groupsNode.get(0)).isArray() && firstGroupNode.iterator().hasNext()) {
                for (JsonNode destinationNode : firstGroupNode) {
                    LogArchiveDestination destination = (LogArchiveDestination)objectMapper.readValue(destinationNode.toString(), LogArchiveDestination.class);
                    destination.setGroup(1);
                    destinations.add(destination);
                }
            }
        }
        return destinations;
    }
}

