/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.db.DBUtil;

public class DatabaseUtils {
    private static final String GET_ARCHIVE_LOG_MODE = "SELECT LOG_MODE FROM V$DATABASE";
    private static final String GET_CON_ID = "SELECT sys_context('USERENV', 'CON_ID') as con_id FROM DUAL";
    private static final String GET_DB_ID = "SELECT dbid FROM v$database";
    private static final String GET_DB_NAME = "SELECT name FROM v$database";
    private static final String GET_DB_UNIQUE_NAME = "SELECT db_unique_name FROM v$database";
    private static final String GET_DB_SIZE = "SELECT ROUND(SUM(bytes) / 1024 / 1024 / 1024) FROM CDB_DATA_FILES";
    private static final String GET_FREE_LOG_ARCHIVE_DEST = "SELECT DEST_NAME FROM V$ARCHIVE_DEST WHERE STATUS = 'INACTIVE'";
    private static final String GET_INSTANCE_ID = "SELECT instance_number FROM v$instance";
    private static final String GET_LOCAL_HOST = "SELECT sys_context('USERENV', 'HOST') AS LOCAL_HOST FROM dual";
    private static final String GET_LOG_ARCHIVE_CONFIG = "SELECT value from gv$parameter where name='log_archive_config'";
    private static final String GET_REDO_TRANSPORT_USER = "SELECT value from gv$parameter where name='redo_transport_user'";
    private static final String GET_REMOTE_HOSTNAMES = String.format("SELECT host_name from gv$instance where host_name != (%s)", "SELECT sys_context('USERENV', 'HOST') AS LOCAL_HOST FROM dual");
    private static final String GET_USER = "SELECT USER FROM DUAL";
    private static final String GET_VERSION_FULL = "SELECT version_full FROM v$instance";
    private static final String DEST_NAME = "dest_name";

    public static String getDatabaseVersion(Connection conn) {
        DBUtil dbutil = DBUtil.getInstance((Connection)conn);
        if (dbutil == null) {
            System.out.println("Not connected to a database.");
            return "";
        }
        return dbutil.executeReturnOneCol(GET_VERSION_FULL);
    }

    public static String queryOneRow(Connection conn, String sql) {
        return DBUtil.getInstance((Connection)conn).executeReturnOneCol(sql);
    }

    public static int compareDatabaseVersion(String v1, String v2) {
        int j;
        String[] subVersions1 = v1.split("\\.");
        String[] subVersions2 = v2.split("\\.");
        int i = 0;
        for (j = 0; i < subVersions1.length && j < subVersions2.length; ++i, ++j) {
            if (subVersions1[i].compareTo(subVersions2[j]) < 0) {
                return -1;
            }
            if (subVersions1[i].compareTo(subVersions2[j]) <= 0) continue;
            return 1;
        }
        if (i >= subVersions1.length && j >= subVersions2.length) {
            return 0;
        }
        if (i < subVersions1.length) {
            return 1;
        }
        return -1;
    }

    public static String getDbUniqueName(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_DB_UNIQUE_NAME);
    }

    public static int getDbSize(Connection conn) {
        String sizeInString = DatabaseUtils.queryOneRow(conn, GET_DB_SIZE);
        try {
            return Integer.parseInt(sizeInString);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to get database size: ", e);
        }
    }

    public static String getUser(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_USER);
    }

    public static String getConnectionId(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_CON_ID);
    }

    public static String getArchiveLogMode(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_ARCHIVE_LOG_MODE);
    }

    public static boolean isPDB(Connection conn) {
        if (conn == null) {
            return false;
        }
        String connectionId = DatabaseUtils.getConnectionId(conn);
        return !connectionId.equals("1");
    }

    public static List<String> getFreeLogArchiveDestinations(Connection conn) throws SQLException {
        ResultSet rs = DBUtil.getInstance((Connection)conn).executeOracleQuery(GET_FREE_LOG_ARCHIVE_DEST, null);
        ArrayList<String> lads = new ArrayList<String>();
        while (rs.next()) {
            String name = rs.getString(DEST_NAME);
            lads.add(name);
        }
        return lads;
    }

    public static ResultSet getLogArchiveDestinations(Connection conn, List<String> destinationNames) throws SQLException {
        Object GET_LOG_ARCHIVE_DEST = "SELECT DEST_ID, DEST_NAME, STATUS, DESTINATION FROM V$ARCHIVE_DEST WHERE UPPER(DESTINATION) IN (";
        int n = destinationNames.size();
        for (int i = 0; i < n; ++i) {
            GET_LOG_ARCHIVE_DEST = (String)GET_LOG_ARCHIVE_DEST + "?";
            if (i >= n - 1) continue;
            GET_LOG_ARCHIVE_DEST = (String)GET_LOG_ARCHIVE_DEST + ", ";
        }
        GET_LOG_ARCHIVE_DEST = (String)GET_LOG_ARCHIVE_DEST + ")";
        ArrayList<String> capitalizedDestinationNames = new ArrayList<String>();
        for (String s : destinationNames) {
            capitalizedDestinationNames.add(s.toUpperCase());
        }
        ResultSet rs = DBUtil.getInstance((Connection)conn).executeQuery((String)GET_LOG_ARCHIVE_DEST, capitalizedDestinationNames);
        return rs;
    }

    public static String getLogArchiveConfig(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_LOG_ARCHIVE_CONFIG);
    }

    public static String getRedoTransportUser(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_REDO_TRANSPORT_USER);
    }

    public static String getParameter(Connection conn, String parameterName) {
        String query = "SELECT value from gv$parameter WHERE UPPER(NAME) = ?";
        List<String> binds = Arrays.asList(parameterName.toUpperCase());
        return DBUtil.getInstance((Connection)conn).executeReturnOneCol(query, binds);
    }

    public static HashMap<String, String> getParameters(Connection conn, List<String> parameterNames) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT name, value FROM gv$parameter WHERE UPPER(name) IN (");
        for (int i = 0; i < parameterNames.size(); ++i) {
            sql.append("?");
            if (i >= parameterNames.size() - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        ArrayList<String> capitalizedParameterNames = new ArrayList<String>();
        for (String s : parameterNames) {
            capitalizedParameterNames.add(s.toUpperCase());
        }
        ResultSet rs = DBUtil.getInstance((Connection)conn).executeQuery(sql.toString(), capitalizedParameterNames);
        HashMap<String, String> results = new HashMap<String, String>();
        if (rs != null) {
            while (rs.next()) {
                results.put(rs.getString("name"), rs.getString("value"));
            }
        }
        return results;
    }

    public static HashMap<String, String> getLogArchiveDestinationState(Connection conn, List<Integer> logArchiveDestinationIDs) throws SQLException {
        List<String> logArchiveDestinationStateNames = logArchiveDestinationIDs.stream().map(id -> "log_archive_dest_state_" + id).collect(Collectors.toList());
        return DatabaseUtils.getParameters(conn, logArchiveDestinationStateNames);
    }

    public static void updateParameter(Connection conn, HashMap<String, String> parametersMap) throws SQLException {
        for (String parameterName : parametersMap.keySet()) {
            Statement statement = conn.createStatement();
            String sql = String.format("ALTER SYSTEM SET %s = '%s'", parameterName, parametersMap.get(parameterName));
            statement.execute(sql);
        }
    }

    public static String getDbId(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_DB_ID);
    }

    public static String getDbName(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_DB_NAME);
    }

    public static int getInstanceId(Connection conn) {
        String instanceIdString = DatabaseUtils.queryOneRow(conn, GET_INSTANCE_ID);
        return Integer.parseInt(instanceIdString);
    }

    public static List<String> getRemoteHostNames(Connection conn) throws SQLException {
        ResultSet rs = DBUtil.getInstance((Connection)conn).executeOracleQuery(GET_REMOTE_HOSTNAMES, null);
        ArrayList<String> hostnames = new ArrayList<String>();
        while (rs.next()) {
            String name = rs.getString("HOST_NAME");
            hostnames.add(name);
        }
        return hostnames;
    }

    public static String generateDatabaseIdForOnPremiseClient(Connection conn) {
        return DatabaseUtils.getDbId(conn) + DatabaseUtils.getDbUniqueName(conn) + DatabaseUtils.getDbName(conn);
    }
}

