/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.common.DatabaseUtils;

public class DatabaseVersionCheck
extends Check {
    private Connection conn;
    private String minimumVersion;

    public DatabaseVersionCheck(Connection conn, String minimumVersion) {
        super("Database Version Check");
        this.conn = conn;
        this.minimumVersion = minimumVersion;
    }

    @Override
    public CheckResult run() {
        String version = DatabaseUtils.getDatabaseVersion(this.conn);
        int res = DatabaseUtils.compareDatabaseVersion(version, this.minimumVersion);
        if (res >= 0) {
            String successMessage = "Database version is at least " + this.minimumVersion;
            return new CheckResult(CheckResult.Status.PASS, successMessage);
        }
        String failureMessage = String.format("Database version %s is smaller than %s", version, this.minimumVersion);
        return new CheckResult(CheckResult.Status.FAIL, failureMessage);
    }
}

