/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.JakartaParserWrapper;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.JsonpParserWrapper;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.parser.JsonLocationImpl;
import oracle.jdbc.driver.json.parser.JsonTokenizer;
import oracle.jdbc.driver.json.parser.UnicodeDetectingInputStream;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonValue;

public class JsonParserImpl
implements OracleJsonParser {
    private Context currentContext = new NoneContext();
    private OracleJsonParser.Event currentEvent;
    private final Stack stack = new Stack();
    private final JsonTokenizer tokenizer;

    public JsonParserImpl(Reader reader, BufferPoolImpl bufferPool) {
        this.tokenizer = new JsonTokenizer(reader, bufferPool);
    }

    public JsonParserImpl(InputStream in, BufferPoolImpl bufferPool) {
        UnicodeDetectingInputStream uin = new UnicodeDetectingInputStream(in);
        this.tokenizer = new JsonTokenizer(new InputStreamReader((InputStream)uin, uin.getCharset()), bufferPool);
    }

    private OracleJsonExceptions.ExceptionFactory factory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    @Override
    public String getString() {
        if (this.currentEvent == OracleJsonParser.Event.KEY_NAME || this.currentEvent == OracleJsonParser.Event.VALUE_STRING || this.currentEvent == OracleJsonParser.Event.VALUE_DECIMAL) {
            return this.tokenizer.getValue();
        }
        throw OracleJsonExceptions.PARSER_GETSTRING_ERR.create(this.factory(), new Object[]{this.currentEvent});
    }

    @Override
    public boolean isIntegralNumber() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_ISINTEGRAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.isIntegral();
    }

    @Override
    public int getInt() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETBIGDECIMAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getInt();
    }

    @Override
    public double getDouble() {
        return this.getBigDecimal().doubleValue();
    }

    @Override
    public float getFloat() {
        return this.getBigDecimal().floatValue();
    }

    @Override
    public BigInteger getBigInteger() {
        return this.getBigDecimal().toBigInteger();
    }

    boolean isDefinitelyInt() {
        return this.tokenizer.isDefinitelyInt();
    }

    boolean isDefinitelyLong() {
        return this.tokenizer.isDefinitelyLong();
    }

    @Override
    public long getLong() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETLONG_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETBIGDECIMAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getBigDecimal();
    }

    @Override
    public OracleJsonArray getArray() {
        if (this.currentEvent != OracleJsonParser.Event.START_ARRAY) {
            throw OracleJsonExceptions.PARSER_GETARRAY_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.getValue().asJsonArray();
    }

    @Override
    public OracleJsonObject getObject() {
        if (this.currentEvent != OracleJsonParser.Event.START_OBJECT) {
            throw OracleJsonExceptions.PARSER_GETOBJECT_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.getValue().asJsonObject();
    }

    @Override
    public OracleJsonValue getValue() {
        ArrayDeque<OracleJsonStructure> stack = new ArrayDeque<OracleJsonStructure>(4);
        OracleJsonValue value = null;
        String currentKey = null;
        if (this.currentEvent == null || this.currentEvent == OracleJsonParser.Event.END_ARRAY || this.currentEvent == OracleJsonParser.Event.END_OBJECT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE_VALUE.create(this.factory(), new Object[0]);
        }
        block11: while (true) {
            switch (this.currentEvent) {
                case END_ARRAY: 
                case END_OBJECT: {
                    value = (OracleJsonValue)stack.pop();
                    break;
                }
                case KEY_NAME: {
                    currentKey = this.getString();
                    this.next();
                    continue block11;
                }
                case START_ARRAY: {
                    value = new OracleJsonArrayImpl();
                    JsonParserImpl.addValue(value, stack, currentKey);
                    stack.push(value.asJsonArray());
                    break;
                }
                case START_OBJECT: {
                    value = new OracleJsonObjectImpl();
                    JsonParserImpl.addValue(value, stack, currentKey);
                    stack.push(value.asJsonObject());
                    break;
                }
                case VALUE_DECIMAL: {
                    value = this.isDefinitelyInt() ? new OracleJsonDecimalImpl(this.getInt(), null) : (this.isDefinitelyLong() ? new OracleJsonDecimalImpl(this.getLong(), null) : new OracleJsonDecimalImpl(this.getBigDecimal()));
                    JsonParserImpl.addValue(value, stack, currentKey);
                    break;
                }
                case VALUE_STRING: {
                    value = new OracleJsonStringImpl(this.getString());
                    JsonParserImpl.addValue(value, stack, currentKey);
                    break;
                }
                case VALUE_TRUE: {
                    value = OracleJsonValue.TRUE;
                    JsonParserImpl.addValue(value, stack, currentKey);
                    break;
                }
                case VALUE_FALSE: {
                    value = OracleJsonValue.FALSE;
                    JsonParserImpl.addValue(value, stack, currentKey);
                    break;
                }
                case VALUE_NULL: {
                    value = OracleJsonValue.NULL;
                    JsonParserImpl.addValue(value, stack, currentKey);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            currentKey = null;
            if (stack.isEmpty()) break;
            this.next();
        }
        return value;
    }

    private static void addValue(OracleJsonValue v, ArrayDeque<OracleJsonStructure> stack, String currentKey) {
        if (stack.isEmpty()) {
            return;
        }
        OracleJsonStructure parent = stack.peek();
        if (parent.getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            parent.asJsonObject().put(currentKey, v);
        } else {
            parent.asJsonArray().add(v);
        }
    }

    @Override
    public void skipArray() {
        if (this.currentEvent == OracleJsonParser.Event.START_ARRAY) {
            this.currentContext.skip();
            this.currentContext = this.stack.pop();
            this.currentEvent = OracleJsonParser.Event.END_ARRAY;
        }
    }

    @Override
    public void skipObject() {
        if (this.currentEvent == OracleJsonParser.Event.START_OBJECT) {
            this.currentContext.skip();
            this.currentContext = this.stack.pop();
            this.currentEvent = OracleJsonParser.Event.END_OBJECT;
        }
    }

    public JsonLocationImpl getLocation() {
        return this.tokenizer.getLocation();
    }

    public JsonLocationImpl getLastCharLocation() {
        return this.tokenizer.getLastCharLocation();
    }

    @Override
    public boolean hasNext() {
        if (this.stack.isEmpty() && this.currentEvent != null && this.currentEvent.compareTo(OracleJsonParser.Event.KEY_NAME) > 0) {
            JsonTokenizer.JsonToken token = this.tokenizer.nextToken();
            if (token != JsonTokenizer.JsonToken.EOF) {
                throw OracleJsonExceptions.PARSER_EXPECTED_EOF.create(this.factory(), new Object[]{this.currentEvent});
            }
            return false;
        }
        if (!this.stack.isEmpty() && !this.tokenizer.hasNextToken()) {
            this.currentEvent = this.currentContext.getNextEvent();
            return false;
        }
        return true;
    }

    @Override
    public OracleJsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEvent = this.currentContext.getNextEvent();
        return this.currentEvent;
    }

    @Override
    public void close() {
        try {
            this.tokenizer.close();
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.factory(), new Object[]{this.currentEvent});
        }
    }

    private RuntimeException parsingException(JsonTokenizer.JsonToken token, String expectedTokens) {
        JsonLocationImpl location = this.getLastCharLocation();
        return OracleJsonExceptions.PARSER_INVALID_TOKEN.create(this.factory(), new Object[]{token, location.getLineNumber(), location.getColumnNumber(), expectedTokens});
    }

    @Override
    public <T> T wrap(Class<T> wrapper) {
        try {
            if (Jsonp.isJakartaJsonStream(wrapper)) {
                return wrapper.cast(new JakartaParserWrapper(this));
            }
            return wrapper.cast(new JsonpParserWrapper(this));
        }
        catch (ClassCastException e) {
            throw OracleJsonExceptions.BAD_WRAP.create(this.factory(), e, wrapper.getName());
        }
    }

    @Override
    public Period getPeriod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Duration getDuration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OffsetDateTime getOffsetDateTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getBytes(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    private final class ArrayContext
    extends Context {
        private boolean firstValue;

        private ArrayContext() {
            this.firstValue = true;
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken token = JsonParserImpl.this.tokenizer.nextToken();
            if (token == JsonTokenizer.JsonToken.EOF) {
                switch (JsonParserImpl.this.currentEvent) {
                    case START_ARRAY: {
                        throw JsonParserImpl.this.parsingException(token, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
                    }
                }
                throw JsonParserImpl.this.parsingException(token, "[COMMA, CURLYCLOSE]");
            }
            if (token == JsonTokenizer.JsonToken.SQUARECLOSE) {
                JsonParserImpl.this.currentContext = JsonParserImpl.this.stack.pop();
                return OracleJsonParser.Event.END_ARRAY;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (token != JsonTokenizer.JsonToken.COMMA) {
                    throw JsonParserImpl.this.parsingException(token, "[COMMA]");
                }
                token = JsonParserImpl.this.tokenizer.nextToken();
            }
            if (token.isValue()) {
                return token.getEvent();
            }
            if (token == JsonTokenizer.JsonToken.CURLYOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ObjectContext();
                return OracleJsonParser.Event.START_OBJECT;
            }
            if (token == JsonTokenizer.JsonToken.SQUAREOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ArrayContext();
                return OracleJsonParser.Event.START_ARRAY;
            }
            throw JsonParserImpl.this.parsingException(token, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
        }

        @Override
        void skip() {
            JsonTokenizer.JsonToken token;
            int depth = 1;
            do {
                token = JsonParserImpl.this.tokenizer.nextToken();
                switch (token) {
                    case SQUARECLOSE: {
                        --depth;
                        break;
                    }
                    case SQUAREOPEN: {
                        ++depth;
                        break;
                    }
                }
            } while (token != JsonTokenizer.JsonToken.SQUARECLOSE || depth != 0);
        }
    }

    private final class ObjectContext
    extends Context {
        private boolean firstValue;

        private ObjectContext() {
            this.firstValue = true;
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken token = JsonParserImpl.this.tokenizer.nextToken();
            if (token == JsonTokenizer.JsonToken.EOF) {
                switch (JsonParserImpl.this.currentEvent) {
                    case START_OBJECT: {
                        throw JsonParserImpl.this.parsingException(token, "[STRING, CURLYCLOSE]");
                    }
                    case KEY_NAME: {
                        throw JsonParserImpl.this.parsingException(token, "[COLON]");
                    }
                }
                throw JsonParserImpl.this.parsingException(token, "[COMMA, CURLYCLOSE]");
            }
            if (JsonParserImpl.this.currentEvent == OracleJsonParser.Event.KEY_NAME) {
                if (token != JsonTokenizer.JsonToken.COLON) {
                    throw JsonParserImpl.this.parsingException(token, "[COLON]");
                }
                token = JsonParserImpl.this.tokenizer.nextToken();
                if (token.isValue()) {
                    return token.getEvent();
                }
                if (token == JsonTokenizer.JsonToken.CURLYOPEN) {
                    JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                    JsonParserImpl.this.currentContext = new ObjectContext();
                    return OracleJsonParser.Event.START_OBJECT;
                }
                if (token == JsonTokenizer.JsonToken.SQUAREOPEN) {
                    JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                    JsonParserImpl.this.currentContext = new ArrayContext();
                    return OracleJsonParser.Event.START_ARRAY;
                }
                throw JsonParserImpl.this.parsingException(token, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
            }
            if (token == JsonTokenizer.JsonToken.CURLYCLOSE) {
                JsonParserImpl.this.currentContext = JsonParserImpl.this.stack.pop();
                return OracleJsonParser.Event.END_OBJECT;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (token != JsonTokenizer.JsonToken.COMMA) {
                    throw JsonParserImpl.this.parsingException(token, "[COMMA]");
                }
                token = JsonParserImpl.this.tokenizer.nextToken();
            }
            if (token == JsonTokenizer.JsonToken.STRING) {
                return OracleJsonParser.Event.KEY_NAME;
            }
            throw JsonParserImpl.this.parsingException(token, "[STRING]");
        }

        @Override
        void skip() {
            JsonTokenizer.JsonToken token;
            int depth = 1;
            do {
                token = JsonParserImpl.this.tokenizer.nextToken();
                switch (token) {
                    case CURLYCLOSE: {
                        --depth;
                        break;
                    }
                    case CURLYOPEN: {
                        ++depth;
                        break;
                    }
                }
            } while (token != JsonTokenizer.JsonToken.CURLYCLOSE || depth != 0);
        }
    }

    private final class NoneContext
    extends Context {
        private NoneContext() {
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken token = JsonParserImpl.this.tokenizer.nextToken();
            if (token == JsonTokenizer.JsonToken.CURLYOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ObjectContext();
                return OracleJsonParser.Event.START_OBJECT;
            }
            if (token == JsonTokenizer.JsonToken.SQUAREOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ArrayContext();
                return OracleJsonParser.Event.START_ARRAY;
            }
            if (token.isValue()) {
                return token.getEvent();
            }
            throw JsonParserImpl.this.parsingException(token, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
        }

        @Override
        void skip() {
        }
    }

    private abstract class Context {
        Context next;

        private Context() {
        }

        abstract OracleJsonParser.Event getNextEvent();

        abstract void skip();
    }

    private static final class Stack {
        private Context head;

        private Stack() {
        }

        private void push(Context context) {
            context.next = this.head;
            this.head = context;
        }

        private Context pop() {
            if (this.head == null) {
                throw new NoSuchElementException();
            }
            Context temp = this.head;
            this.head = this.head.next;
            return temp;
        }

        private boolean isEmpty() {
            return this.head == null;
        }
    }
}

