/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3.io.internal;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLengthVerifyingInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ContentLengthVerifyingInputStream.class);
    protected final InputStream delegate;
    protected final long contentLength;
    protected long totalBytesProcessed = 0L;
    protected boolean isVerificationEnabled = true;

    @Override
    public int read() throws IOException {
        int byteRead = this.delegate.read();
        int bytesRead = byteRead != -1 ? 1 : -1;
        this.processBytesRead(bytesRead);
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = this.delegate.read(b);
        this.processBytesRead(bytesRead);
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.delegate.read(b, off, len);
        this.processBytesRead(bytesRead);
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = this.delegate.skip(n);
        this.totalBytesProcessed += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.isVerificationEnabled = false;
        LOG.info("Content length verification disabled");
        this.delegate.reset();
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    protected void processBytesRead(int bytesRead) throws IOException {
        if (!this.isVerificationEnabled) {
            return;
        }
        if (bytesRead == -1) {
            if (this.totalBytesProcessed != this.contentLength) {
                throw new IOException(String.format("Total bytes processed (%d) does not match content-length (%d)", this.totalBytesProcessed, this.contentLength));
            }
        } else {
            this.totalBytesProcessed += (long)bytesRead;
        }
    }

    @ConstructorProperties(value={"delegate", "contentLength"})
    public ContentLengthVerifyingInputStream(InputStream delegate, long contentLength) {
        this.delegate = delegate;
        this.contentLength = contentLength;
    }
}

