/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.jdbc.Connection;
import oracle.dbtools.jdbc.ResultSet;
import oracle.dbtools.jdbc.util.ExceptionUtil;
import oracle.dbtools.jdbc.util.LogUtil;
import oracle.dbtools.jdbc.util.RestJdbcNotImplementedException;
import oracle.dbtools.jdbc.util.RestJdbcUnsupportedException;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.SQLStateMapping;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class Statement
implements java.sql.Statement {
    Logger LOGGER = Logger.getLogger(Statement.class.getName());
    protected Connection conn = null;
    private java.sql.ResultSet currentResultSet;
    private boolean closed = false;
    SQLWarning sqlWarning;
    private long maxRows = 0L;
    protected String sql = null;
    private boolean isCloseOnCompletion = false;
    protected long rsCount = 0L;
    protected boolean batch = false;
    protected ArrayList<String> cmds = new ArrayList();
    protected int updateCount = -1;
    protected long fetchSize = 0L;

    public Statement() {
    }

    public Statement(Connection conn) {
        this.setConn(conn);
        this.closed = false;
    }

    protected AbstractMap.SimpleEntry<JsonGenerator, Writer> generatePost(String sql, int offset) throws SQLException {
        JsonFactory f = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator g = null;
        try {
            g = f.createGenerator((Writer)writer);
            g.writeStartObject();
            if (!this.batch) {
                g.writeStringField("statementText", sql);
            } else {
                g.writeArrayFieldStart("statementText");
                for (String sqlStmt : this.cmds) {
                    g.writeString(sqlStmt);
                }
                g.writeEndArray();
            }
            g.writeStringField("emulate", "jdbc");
            g.writeNumberField("offset", offset);
            if (this.fetchSize > 0L) {
                g.writeNumberField("limit", this.fetchSize);
            } else {
                g.writeNumberField("limit", 25);
            }
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return new AbstractMap.SimpleEntry<JsonGenerator, Writer>(g, writer);
    }

    protected CloseableHttpResponse getBasicAuthResponse(Writer postWriter, URI root) throws SessionException {
        StringEntity strEntity = new StringEntity(postWriter.toString(), StandardCharsets.UTF_8);
        Session session = this.conn.getSession();
        HttpPost post = session.createPost(root);
        post.addHeader("Content-Type", (Object)"application/json");
        post.setEntity((HttpEntity)strEntity);
        return session.executeRequest((HttpUriRequest)post);
    }

    protected CloseableHttpResponse getOCIAuthResponse(Writer postWriter, URI root) throws SessionException, GeneralSecurityException, IOException {
        OCIRESTClient client = this.conn.getOCIRESTClient();
        OCIRequest request = new OCIRequest.Builder().host(root.getHost()).method("post").body(postWriter.toString()).target(root.getPath()).contentType("application/json").build();
        return client.getResponse(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableHttpResponse executeInternal(String sql) throws SQLException {
        if (!this.batch && (sql == null || sql.isEmpty())) {
            int errorCode = 17104;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        this.sql = sql;
        CloseableHttpResponse response = null;
        Connection connection = this.conn;
        synchronized (connection) {
            StringBuilder uri = new StringBuilder();
            uri.append(this.getConn().getUri());
            uri.append("_/sql");
            URI root = URI.create(uri.toString());
            try {
                AbstractMap.SimpleEntry<JsonGenerator, Writer> simpleEntry = this.generatePost(sql, 0);
                JsonGenerator g = simpleEntry.getKey();
                Writer writer = simpleEntry.getValue();
                g.close();
                response = Connection.basic_auth ? this.getBasicAuthResponse(writer, root) : this.getOCIAuthResponse(writer, root);
            }
            catch (IOException | IllegalStateException | GeneralSecurityException | SessionException e) {
                this.LOGGER.log(Level.SEVERE, e.getMessage());
            }
            return response;
        }
    }

    protected String processNonASCII(String sql) {
        StringBuilder escaped = new StringBuilder();
        return null;
    }

    protected void handleErrors(TreeNode node) throws SQLException {
        JrsArray arr = (JrsArray)node.get("items");
        Iterator elements = arr.elements();
        JrsValue value = (JrsValue)elements.next();
        if (value.get("errorCode") != null) {
            JrsNumber n = (JrsNumber)value.get("errorCode");
            int errorCode = n.getValue().intValue();
            JrsString s = (JrsString)value.get("errorDetails");
            String error_details = s.getValue();
            throw new SQLException(error_details);
        }
        if (value.get("errorDetails") != null) {
            JrsNumber n = (JrsNumber)value.get("errorCode");
            int errorCode = n.getValue().intValue();
            JrsString s = (JrsString)value.get("errorDetails");
            String error_details = s.getValue();
            throw new SQLException(error_details);
        }
    }

    protected TreeNode createJsonNode(CloseableHttpResponse response) throws SQLException {
        HttpEntity entity = response.getEntity();
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        TreeNode node = null;
        try {
            InputStream is = entity.getContent();
            node = json.treeFrom((Object)is);
        }
        catch (Exception e) {
            this.LOGGER.severe(e.getMessage());
            int errorCode = 17001;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return node;
    }

    protected int getResult(TreeNode node) throws SQLException {
        int result = -1;
        JrsArray arr = (JrsArray)node.get("items");
        Iterator elements = arr.elements();
        JrsValue value = (JrsValue)elements.next();
        JrsValue obj = value.get("result");
        if (value.get("resultSet") != null) {
            return result;
        }
        if (value.get("result") != null) {
            JrsNumber n = (JrsNumber)value.get("result");
            result = n.getValue().intValue();
        }
        return result;
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        ++this.rsCount;
        CloseableHttpResponse response = this.executeInternal(sql);
        ResultSet rs = new ResultSet(response, this, this.getConn());
        this.setCurrentResultSet(rs);
        this.updateCount = -1;
        return rs;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean result = false;
        CloseableHttpResponse response = null;
        try {
            result = true;
            response = this.executeInternal(sql);
            TreeNode node = this.createJsonNode(response);
            this.handleErrors(node);
            this.updateCount = this.getResult(node);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableHttpResponse executeUpdateInternal(String sql) throws SQLException {
        if (sql == null || sql.isEmpty()) {
            int errorCode = 17104;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        this.sql = sql;
        CloseableHttpResponse response = null;
        Connection connection = this.conn;
        synchronized (connection) {
            Session session = this.conn.getSession();
            StringBuilder uri = new StringBuilder();
            uri.append(this.getConn().getUri());
            uri.append("_/sql");
            URI root = URI.create(uri.toString());
            try {
                JsonFactory f = new JsonFactory();
                StringWriter writer = new StringWriter();
                JsonGenerator g = null;
                g = f.createGenerator((Writer)writer);
                g.writeStartObject();
                g.writeStringField("statementText", sql);
                g.writeNumberField("offset", 0);
                g.writeNumberField("limit", 1);
                g.writeEndObject();
                g.close();
                response = Connection.basic_auth ? this.getBasicAuthResponse(writer, root) : this.getOCIAuthResponse(writer, root);
            }
            catch (IOException | IllegalStateException | GeneralSecurityException | SessionException e) {
                this.LOGGER.log(Level.SEVERE, e.getMessage());
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        int result = 0;
        CloseableHttpResponse response = null;
        try {
            response = this.executeUpdateInternal(sql);
            TreeNode node = this.createJsonNode(response);
            this.handleErrors(node);
            result = this.getResult(node);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                }
            }
        }
        this.updateCount = result;
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.maxRows = 0L;
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        this.ensureOpen();
        return this.conn;
    }

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            ExceptionUtil.throwSQLException(17009);
        }
        if (this.conn.isClosed()) {
            ExceptionUtil.throwSQLException(17008);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchDirection(int direction) throws SQLException {
        Connection connection = this.getConn();
        synchronized (connection) {
            this.ensureOpen();
            if (direction != 1000) {
                if (direction == 1001 || direction == 1002) {
                    this.sqlWarning = new SQLWarning(RestjdbcResources.get("RESTJDBC_007"));
                } else {
                    throw new SQLException(RestjdbcResources.getString("ORA_17308"));
                }
            }
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureOpen();
        return (int)this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.ensureOpen();
        if (max < 0) {
            int errorCode = 17068;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        this.maxRows = max;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ensureOpen();
        if (rows < 0) {
            int errorCode = 17433;
            throw new SQLException(ExceptionUtil.getErrorMessage(17433));
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.fetchSize == 0L) {
            return 25;
        }
        return (int)this.fetchSize;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        if (!this.closed) {
            this.isCloseOnCompletion = true;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.isCloseOnCompletion;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isCloseOnCompletion && this.rsCount == 0L) {
            this.close();
        }
        return this.closed;
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.getCurrentResultSet();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
        this.sqlWarning = null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        LogUtil.logOrException(this.getConnection(), null, "Statement.getWarnings() not supported", null);
        return this.sqlWarning;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getQueryTimeout()", this.getClass().getSimpleName()));
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setQueryTimeout(int seconds)", this.getClass().getSimpleName()));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "unwrap(Class<T> iface)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "isWrapperFor(Class<?> iface)", this.getClass().getSimpleName()));
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getMaxFieldSize()", this.getClass().getSimpleName()));
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setMaxFieldSize(int max)", this.getClass().getSimpleName()));
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureOpen();
        LogUtil.log(null, Level.FINE, "setEscapeProcessing does not affect the REST JDBC driver", null);
    }

    @Override
    public void cancel() throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "cancel()", this.getClass().getSimpleName());
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "setCursorName(String name)", this.getClass().getSimpleName()));
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureOpen();
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getMoreResults()", this.getClass().getSimpleName()));
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "getResultSetConcurrency()", this.getClass().getSimpleName());
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batch = true;
        this.cmds.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch = false;
        this.cmds.clear();
    }

    protected int[] createIntArray(TreeNode node) throws SQLException {
        int i = 0;
        TreeNode resultNode = node.get("items").get(0).get("result");
        int[] result = new int[resultNode.size()];
        while (resultNode.get(i) != null) {
            try {
                JrsNumber n = (JrsNumber)resultNode.get(i);
                result[i] = n.getValue().intValue();
                ++i;
            }
            catch (Exception e) {
                ExceptionUtil.throwSQLException(17089);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] result = new int[]{};
        if (this.batch) {
            CloseableHttpResponse response = null;
            try {
                response = this.executeInternal(this.sql);
                TreeNode node = this.createJsonNode(response);
                this.handleErrors(node);
                result = this.createIntArray(node);
            }
            finally {
                this.batch = false;
                this.cmds.clear();
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        this.LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
        this.updateCount = result.length;
        return result;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "getMoreResults(int current)", this.getClass().getSimpleName());
        return false;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, " getGeneratedKeys()", this.getClass().getSimpleName());
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "executeUpdate(String sql, int autoGeneratedKeys)", this.getClass().getSimpleName());
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "executeUpdate(String sql, int[] columnIndexes)", this.getClass().getSimpleName());
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "executeUpdate(String sql, String[] columnIndexes)", this.getClass().getSimpleName());
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "(String sql, int autoGeneratedKeys)", this.getClass().getSimpleName());
        this.updateCount = 0;
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "(String sql, int[] columnIndexes)", this.getClass().getSimpleName());
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "execute(String sql, String[] columnNames)", this.getClass().getSimpleName());
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, "getResultSetHoldability()", this.getClass().getSimpleName());
        return 0;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureOpen();
        LogUtil.log(null, Level.INFO, "setPoolable does not affect the REST JDBC driver", null);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureOpen();
        return false;
    }

    public String getSqlString() {
        return this.sql;
    }

    public java.sql.ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    public void setCurrentResultSet(java.sql.ResultSet currentResultSet) {
        this.currentResultSet = currentResultSet;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public CloseableHttpResponse orestExecuteInternal(String sql) throws SQLException {
        return this.executeInternal(sql);
    }
}

