/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools;

import com.oracle.bmc.databasetools.DatabaseTools;
import com.oracle.bmc.databasetools.model.LifecycleState;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsConnectionRequest;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsEndpointServiceRequest;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsPrivateEndpointRequest;
import com.oracle.bmc.databasetools.requests.GetWorkRequestRequest;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsConnectionResponse;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsEndpointServiceResponse;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsPrivateEndpointResponse;
import com.oracle.bmc.databasetools.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DatabaseToolsWaiters {
    private final ExecutorService executorService;
    private final DatabaseTools client;

    public DatabaseToolsWaiters(ExecutorService executorService, DatabaseTools client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDatabaseToolsConnectionRequest, GetDatabaseToolsConnectionResponse> forDatabaseToolsConnection(GetDatabaseToolsConnectionRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseToolsConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseToolsConnectionRequest, GetDatabaseToolsConnectionResponse> forDatabaseToolsConnection(GetDatabaseToolsConnectionRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabaseToolsConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseToolsConnectionRequest, GetDatabaseToolsConnectionResponse> forDatabaseToolsConnection(GetDatabaseToolsConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseToolsConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseToolsConnectionRequest, GetDatabaseToolsConnectionResponse> forDatabaseToolsConnection(BmcGenericWaiter waiter, GetDatabaseToolsConnectionRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDatabaseToolsConnectionRequest, GetDatabaseToolsConnectionResponse>(){

            @Override
            public GetDatabaseToolsConnectionResponse apply(GetDatabaseToolsConnectionRequest request) {
                return DatabaseToolsWaiters.this.client.getDatabaseToolsConnection(request);
            }
        }, (Predicate)new Predicate<GetDatabaseToolsConnectionResponse>(){

            @Override
            public boolean test(GetDatabaseToolsConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getDatabaseToolsConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDatabaseToolsEndpointServiceRequest, GetDatabaseToolsEndpointServiceResponse> forDatabaseToolsEndpointService(GetDatabaseToolsEndpointServiceRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseToolsEndpointService(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseToolsEndpointServiceRequest, GetDatabaseToolsEndpointServiceResponse> forDatabaseToolsEndpointService(GetDatabaseToolsEndpointServiceRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabaseToolsEndpointService(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseToolsEndpointServiceRequest, GetDatabaseToolsEndpointServiceResponse> forDatabaseToolsEndpointService(GetDatabaseToolsEndpointServiceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseToolsEndpointService(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseToolsEndpointServiceRequest, GetDatabaseToolsEndpointServiceResponse> forDatabaseToolsEndpointService(BmcGenericWaiter waiter, GetDatabaseToolsEndpointServiceRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDatabaseToolsEndpointServiceRequest, GetDatabaseToolsEndpointServiceResponse>(){

            @Override
            public GetDatabaseToolsEndpointServiceResponse apply(GetDatabaseToolsEndpointServiceRequest request) {
                return DatabaseToolsWaiters.this.client.getDatabaseToolsEndpointService(request);
            }
        }, (Predicate)new Predicate<GetDatabaseToolsEndpointServiceResponse>(){

            @Override
            public boolean test(GetDatabaseToolsEndpointServiceResponse response) {
                return targetStatesSet.contains((Object)response.getDatabaseToolsEndpointService().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDatabaseToolsPrivateEndpointRequest, GetDatabaseToolsPrivateEndpointResponse> forDatabaseToolsPrivateEndpoint(GetDatabaseToolsPrivateEndpointRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseToolsPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseToolsPrivateEndpointRequest, GetDatabaseToolsPrivateEndpointResponse> forDatabaseToolsPrivateEndpoint(GetDatabaseToolsPrivateEndpointRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabaseToolsPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseToolsPrivateEndpointRequest, GetDatabaseToolsPrivateEndpointResponse> forDatabaseToolsPrivateEndpoint(GetDatabaseToolsPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseToolsPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseToolsPrivateEndpointRequest, GetDatabaseToolsPrivateEndpointResponse> forDatabaseToolsPrivateEndpoint(BmcGenericWaiter waiter, GetDatabaseToolsPrivateEndpointRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDatabaseToolsPrivateEndpointRequest, GetDatabaseToolsPrivateEndpointResponse>(){

            @Override
            public GetDatabaseToolsPrivateEndpointResponse apply(GetDatabaseToolsPrivateEndpointRequest request) {
                return DatabaseToolsWaiters.this.client.getDatabaseToolsPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetDatabaseToolsPrivateEndpointResponse>(){

            @Override
            public boolean test(GetDatabaseToolsPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getDatabaseToolsPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DatabaseToolsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

