/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.List;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTExtractor;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTVisitor;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.util.StreamCopy;

@Deprecated
public class RESTSQLVisitor
implements RESTVisitor {
    private StringBuilder call = new StringBuilder();

    public String getContents() {
        return this.call.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(RESTExtractor.ExportEntity entity) throws IOException {
        List<RestModule> modules = entity.modules;
        if (modules.size() == 0) {
            if (entity.isRequestionAllModules) {
                this.call.append("No modules found in the current schema.");
            } else if (entity.isModulePath) {
                this.call.append("No module found for path: " + entity.moduleFilter);
            } else {
                this.call.append("No module named: " + entity.moduleFilter);
            }
            return;
        }
        this.call.append("declare\n  l_module_id number;\n  l_template_id number;\n  l_handler_id number;\n  l_parameter_id number;\nbegin\n");
        for (RestModule module : modules) {
            this.visit(module);
        }
        for (String key : entity.privileges.keySet()) {
            this.call.append("\n    declare\n");
            this.call.append("      l_modules owa.vc_arr;\n");
            this.call.append("      l_roles owa.vc_arr;\n");
            this.call.append("      l_patterns owa.vc_arr;\n");
            this.call.append("      l_priv_id number;\n");
            this.call.append("      l_role_id number;\n");
            this.call.append("    begin\n");
            RestPrivilege priv = entity.privileges.get(key);
            int roleCounter = 1;
            for (String string : priv.getRoles()) {
                this.call.append("      l_role_id := ORDS_SERVICES.create_role('" + string + "');\n");
                this.call.append("      l_roles(" + roleCounter++ + ") := '" + string + "';\n");
            }
            int moduleCounter = 1;
            for (String module : priv.getModules()) {
                this.call.append("      l_modules(" + moduleCounter++ + ") := '" + module + "';\n");
            }
            boolean bl = true;
            for (String pattern : priv.getURIPatterns()) {
                void var8_9;
                this.call.append("      l_patterns(" + (int)(++var8_9) + ") := '" + pattern + "';\n");
            }
            this.call.append("      l_priv_id := ORDS_SERVICES.create_privilege(\n");
            this.call.append("        p_name => '" + priv.getName() + "',\n");
            this.call.append("        p_label => '" + priv.getTitle() + "',\n");
            this.call.append("        p_description => '" + priv.getDescription() + "',\n");
            this.call.append("        p_roles => l_roles,\n");
            this.call.append("        p_modules => l_modules,\n");
            this.call.append("        p_patterns => l_patterns,\n");
            this.call.append("        p_comments => '" + priv.getComments() + "');\n");
            this.call.append("    end;");
        }
        this.call.append("\ncommit;\n");
        this.call.append("end;\n/");
    }

    @Override
    public void visit(RestModule module) throws IOException {
        this.call.append("\n  ORDS_SERVICES.delete_module(");
        if (module.getName() != null) {
            this.call.append(" p_name => '" + module.getName());
        }
        this.call.append("');");
        this.call.append("\n  l_module_id := ORDS_SERVICES.create_module(");
        if (module.getName() != null) {
            this.call.append(" p_name => '" + module.getName() + "' ,");
        }
        if (module.getURIPrefix() != null) {
            this.call.append(" p_uri_prefix => '" + module.getURIPrefix() + "' ,");
        }
        this.call.append(" p_items_per_page => " + module.getPaginationSize() + " ,");
        if (module.getComments() != null) {
            this.call.append(" p_comments => '" + module.getComments() + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        for (RestTemplate template : module.getTemplates()) {
            this.visit(template);
        }
        this.call.append("\n");
    }

    @Override
    public void visit(RestTemplate template) throws IOException {
        this.call.append("\n  l_template_id := ORDS_SERVICES.add_template( p_module_id => l_module_id,");
        if (template.getURIPattern() != null) {
            this.call.append(" p_uri_template => '" + template.getURIPattern() + "' ,");
        }
        this.call.append(" p_priority => " + template.getPriority() + " ,");
        if (template.getEntityTag().getType() != null) {
            this.call.append(" p_etag_type => '" + template.getEntityTag().getType() + "' ,");
        }
        if (template.getEntityTagQuery() != null) {
            this.call.append(" p_etag_query => '" + template.getEntityTagQuery() + "' ,");
        }
        if (template.getComments() != null) {
            this.call.append(" p_comments => '" + template.getComments() + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        for (RestResourceHandler handler : template.getResourceHandlers().values()) {
            this.visit(handler);
        }
    }

    @Override
    public void visit(RestResourceHandler handler) throws IOException {
        this.call.append("\n");
        this.call.append("  l_handler_id := ORDS_SERVICES.add_handler( p_template_id => l_template_id,");
        if (handler.getSourceType() != null) {
            this.call.append(" p_source_type => '" + String.valueOf((Object)handler.getSourceType()) + "' ,");
        }
        if (handler.getMethodType().getType() != null) {
            this.call.append(" p_method => '" + handler.getMethodType().getType() + "' ,");
        }
        if (handler.getMimeTypes() != null && handler.getMimeTypes().size() > 0) {
            StringBuilder mimes = new StringBuilder();
            boolean isFirst = true;
            for (String mime : handler.getMimeTypes()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    mimes.append(",");
                }
                mimes.append(mime);
            }
            if (mimes.length() > 0) {
                this.call.append(" p_mimes_allowed => '" + mimes.toString() + "' ,");
            }
        }
        this.call.append(" p_items_per_page => " + handler.getPaginationSize() + " ,");
        if (handler.getComments() != null) {
            this.call.append(" p_comments => '" + handler.getComments() + "'");
        }
        if (handler.getSQL() != null) {
            this.call.append(" p_source => ");
            this.appendClob(StreamCopy.toInputStream((String)handler.getSQL()));
            this.call.append(",");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
        for (RestHandlerParameter parameter : handler.getParameters()) {
            this.visit(parameter);
        }
    }

    @Override
    public void visit(RestHandlerParameter parameter) {
        this.call.append("\n");
        this.call.append("  l_parameter_id := ORDS_SERVICES.add_parameter( p_handler_id => l_handler_id,");
        if (parameter.getName() != null) {
            this.call.append(" p_name => '" + parameter.getName() + "' ,");
        }
        if (parameter.getBindVariable() != null) {
            this.call.append(" p_bind_variable_name => '" + parameter.getBindVariable() + "' ,");
        }
        if (parameter.getSourceType() != null) {
            this.call.append(" p_source_type => '" + String.valueOf((Object)parameter.getSourceType()) + "' ,");
        }
        if (parameter.getAccessMethod() != null) {
            this.call.append(" p_access_method => '" + String.valueOf((Object)parameter.getAccessMethod()) + "' ,");
        }
        if (parameter.getDataType() != null) {
            this.call.append(" p_param_type => '" + String.valueOf((Object)parameter.getDataType()) + "'");
        }
        if (parameter.getComments() != null) {
            this.call.append(" p_comments => '" + parameter.getComments() + "'");
        }
        if (this.call.charAt(this.call.length() - 1) == ',') {
            this.call.deleteCharAt(this.call.length() - 1);
        }
        this.call.append(");");
    }

    private void appendClob(InputStream in) {
        if (in == null) {
            this.call.append("null");
        }
        Integer bufferSize = 200;
        char[] buffer = new char[bufferSize.intValue()];
        Object chunk = "";
        boolean isFirstChunk = true;
        String newLineReplacement = "' || unistr('\\000a')\n   || '";
        InputStreamReader clobStream = new InputStreamReader(in);
        boolean firstRead = true;
        while (true) {
            int readResult = -1;
            try {
                buffer = new char[bufferSize.intValue()];
                readResult = clobStream.read(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            if (readResult < 0) {
                if (!((String)chunk).endsWith("' || unistr('\\000a')\n   || '")) break;
                this.call.replace(this.call.length() - 5, this.call.length() - 1, "");
                break;
            }
            chunk = this.trimNulls(buffer);
            chunk = ((String)chunk).replace("'", "''");
            chunk = "'" + (String)chunk + "'";
            if (!firstRead) {
                chunk = "  ||  " + (String)chunk;
            } else {
                firstRead = false;
            }
            chunk = ((String)chunk).replace("\n", "' || unistr('\\000a')\n   || '");
            if (isFirstChunk && ((String)chunk).startsWith("' || unistr('\\000a')\n   || '")) {
                chunk = ((String)chunk).replaceFirst("' || unistr('\\000a')\n   || '", "'' || unistr('\\000a')\n   || '");
            }
            isFirstChunk = false;
            this.call.append((String)chunk);
        }
    }

    private void appendRawClob(Clob clob, StringBuilder call) throws SQLException {
        if (clob == null || clob.length() == 0L) {
            call.append("null");
        }
        Integer bufferSize = 200;
        char[] buffer = new char[bufferSize.intValue()];
        Object chunk = "";
        boolean isFirstChunk = true;
        String newLineReplacement = "' || unistr('\\000a')\n   || '";
        Reader clobStream = clob.getCharacterStream();
        boolean firstRead = true;
        while (true) {
            int readResult = -1;
            try {
                buffer = new char[bufferSize.intValue()];
                readResult = clobStream.read(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            if (readResult < 0) {
                if (!((String)chunk).endsWith("' || unistr('\\000a')\n   || '")) break;
                call.replace(call.length() - 5, call.length() - 1, "");
                break;
            }
            chunk = this.trimNulls(buffer);
            chunk = ((String)chunk).replace("'", "''");
            chunk = "'" + (String)chunk + "'";
            if (!firstRead) {
                chunk = "  ||  " + (String)chunk;
            } else {
                firstRead = false;
            }
            chunk = ((String)chunk).replace("\n", "' || unistr('\\000a')\n   || '");
            if (isFirstChunk && ((String)chunk).startsWith("' || unistr('\\000a')\n   || '")) {
                chunk = ((String)chunk).replaceFirst("' || unistr('\\000a')\n   || '", "'' || unistr('\\000a')\n   || '");
            }
            isFirstChunk = false;
            call.append((String)chunk);
        }
    }

    private String trimNulls(char[] input) {
        int firstNullPosition = -1;
        String result = "";
        for (int i = 0; i < input.length; ++i) {
            int charValue = new Byte((byte)input[i]).intValue();
            if (charValue != 0) continue;
            firstNullPosition = i;
            break;
        }
        result = firstNullPosition > -1 ? new String(input, 0, firstNullPosition) : new String(input);
        return result;
    }
}

