/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.plusplus.ssh.SSHConnection;
import oracle.dbtools.plusplus.ssh.TunnelDescriptor;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowNoRows;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;

public class SshTunnelCommand
extends CommandListener
implements IHelp,
IShowCommand,
IShowPrefixNameNewline,
IShowNoRows {
    private static final String KEY = "-i";
    private static final String PORTF = "-L";
    private static final String DISCONNECT = "disconnect";
    private static String SSHTUNNEL = "sqlcl.sshtunnel";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() != null && ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            ctx.write("Not supported for nucleo connection\n");
            return true;
        }
        String[] parts = cmd.getSql().split("\\s+");
        if (parts.length < 2 || parts.length > 6 || parts.length % 2 > 0) {
            ctx.write(this.getHelp());
        } else {
            SSHConnection sshConn;
            boolean connected;
            String hostname = "";
            String keyname = "";
            String portf = "";
            if (parts.length == 2) {
                if (parts[1].toLowerCase().equals(DISCONNECT)) {
                    SSHConnection tunnel = (SSHConnection)ctx.getProperty(SSHTUNNEL);
                    if (tunnel != null && tunnel.isConnected()) {
                        tunnel.disconnect();
                    }
                    ctx.putProperty(SSHTUNNEL, null);
                    return true;
                }
                hostname = parts[1];
            } else if (parts.length == 4 || parts.length == 6) {
                hostname = parts[1];
                keyname = this.getArgument(KEY, parts);
                portf = this.getArgument(PORTF, parts);
            }
            String username = System.getProperty("user.name");
            SSHConnection.ConnType type = SSHConnection.ConnType.NONE;
            if (hostname.indexOf("@") != -1) {
                String[] uhost = hostname.split("@");
                username = uhost[0];
                hostname = uhost[1];
            }
            String basePort = "22";
            if (hostname.indexOf(":") != -1) {
                String[] uhost = hostname.split(":");
                hostname = uhost[0];
                basePort = uhost[1];
            }
            if (connected = (sshConn = new SSHConnection(ctx, type, hostname, username, keyname, basePort, portf, "")).connect()) {
                ctx.write("SSH Tunnel connected\n");
                ctx.putProperty(SSHTUNNEL, sshConn);
            } else {
                ctx.write("SSH Tunnel connection failed\n");
            }
        }
        return true;
    }

    private String getArgument(String key, String[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equals(key) || i >= parts.length - 1) continue;
            return parts[i + 1];
        }
        return "";
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "SSHTUNNEL";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{this.getCommand()};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String optionalHeader = (String)ctx.getProperty("script.runner.optional_show_header");
        SSHConnection tunnel = (SSHConnection)ctx.getProperty(SSHTUNNEL);
        if (tunnel != null) {
            if (optionalHeader != null && !optionalHeader.equals("")) {
                ctx.write(optionalHeader);
            }
            if (tunnel.isConnected()) {
                ctx.write("Tunnel Connected\n");
                TunnelDescriptor session = tunnel.getSession();
                ctx.write(MessageFormat.format("\tHost:{0}\n", session.getHost()));
                ctx.write(MessageFormat.format("\tUsername:{0}\n", session.getUserName()));
                int localPort = session.getLocalPort();
                int remotePort = session.getRemotePort();
                String remoteHost = session.getRemoteHost();
                ctx.write("\nPort Forwarding\n");
                ctx.write(MessageFormat.format("\tlocal port:{0}\n\tRemote Host:{1}\n\tRemote Port:{2}\n", Integer.toString(localPort), remoteHost, Integer.toString(remotePort)));
            } else {
                ctx.write("No Tunnel Created\n");
            }
        } else if (optionalHeader == null || optionalHeader.equals("")) {
            ctx.write("No SSH Tunnel defined\n");
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

