/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scheduler.SchedulerMessages;
import oracle.dbtools.raptor.scheduler.exceptions.JobExecutionException;
import oracle.dbtools.raptor.scheduler.job.Job;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Buffer;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

@DisallowConcurrentExecution
public class SqlclCommandJob
implements org.quartz.Job {
    public void execute(JobExecutionContext jobExecutionContext) {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobMap = jobDetail.getJobDataMap();
        Job job = (Job)jobMap.get((Object)"job");
        ScriptRunnerContext context = this.createScriptRunnerContext(jobMap);
        String connName = job.getConnection();
        String payload = job.getPayload();
        try (Connection connection = this.connect(context, connName);){
            String out = this.runPayload(context, payload + "\n", connection);
            jobExecutionContext.setResult((Object)out);
        }
        catch (IOException | RuntimeException | SQLException e) {
            throw new JobExecutionException(e);
        }
    }

    private ScriptRunnerContext createScriptRunnerContext(JobDataMap jobMap) {
        ScriptRunnerContext original = (ScriptRunnerContext)jobMap.get((Object)"runner");
        ScriptRunnerContext clone = new ScriptRunnerContext();
        clone.consumerRuning(true);
        clone.putProperty("script.runner.appinfo.arraylist", new ArrayList());
        clone.setSQLPlusBuffer(new Buffer());
        clone.putProperty("script.runner.using.systemout", true);
        clone.setSqlError(4);
        clone.putProperty("sqlplus.error.logging", true);
        clone.putProperty("script.runner.exit_int_whenever", 2);
        clone.putProperty("script.runner.exit_int_whenever.wassqlcode", true);
        if (original != null) {
            clone.putProperty("script.runner.jline", original.getProperty("script.runner.jline"));
        }
        return clone;
    }

    private String runPayload(ScriptRunnerContext context, String payload, Connection conn) throws IOException {
        ByteArrayOutputStream baS = new ByteArrayOutputStream();
        if (payload == null || payload.isBlank()) {
            return SchedulerMessages.getString("NO_PAYLOAD_FOUND");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = baS;){
            String string;
            try (BufferedOutputStream boS = new BufferedOutputStream(baS);){
                String encoding = ScriptRunnerContext.getOutputEncoding();
                ScriptExecutor runner = new ScriptExecutor(payload, conn);
                runner.setScriptRunnerContext(context);
                runner.setConn(conn);
                runner.setOut(boS);
                runner.run();
                runner.getScriptRunnerContext().getOutputStream().flush();
                string = baS.toString(encoding);
            }
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    private Connection connect(ScriptRunnerContext ctx, String connName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

