/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.save;

import java.io.File;
import java.net.URI;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.ora.CloudSupport;
import oracle.dbtools.plusplus.connections.db.save.StandardConnectionDefinitionFactory;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.CloudConfigProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.CloudWalletConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ProxyProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.WalletValue;

public class CloudConnectionDefinitionFactory
extends StandardConnectionDefinitionFactory {
    @Override
    public boolean canHandle(ConnectorType type) {
        return CloudWalletConnectorType.class == type.getClass();
    }

    @Override
    protected DatabaseProvider.Builder configureDatabaseProvider(PropertyValues props, DatabaseProvider.Builder builder) {
        URI proxy;
        builder = builder.property("OracleConnectionType", "CLOUD");
        WalletValue cloudWalletPath = props.getValueOf(CloudConfigProperty.CLOUDCONFIG);
        if (cloudWalletPath != null) {
            File f = new File(cloudWalletPath.getLocation());
            URI uri = f.toURI();
            builder = builder.property("sqldev.cloud.configfile", uri.toString());
        }
        if ((proxy = props.getValueOf(ProxyProperty.PROXY)) != null) {
            String host = proxy.getHost();
            int port = proxy.getPort();
            builder.property("sqldev.http.proxymode", CloudSupport.ProxyMode.CUSTOM.name());
            builder.property("sqldev.http.proxy.host", host);
            builder.property("sqldev.http.proxy.port", Integer.toString(port));
        }
        return builder;
    }
}

