/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionSaveHandler;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.plusplus.connections.db.DatabaseConnection;
import oracle.dbtools.plusplus.connections.db.ImplicitConnection;
import oracle.dbtools.plusplus.connections.db.save.SharedConnectionSaveHandler;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;

class NamedConnections {
    private static final ConnectionStoreBridge BRIDGE = new ConnectionStoreBridge(){

        @Override
        public ConnectionSaveHandler createSaveHandler(ScriptRunnerContext ctx, PropertyValues props, ConnectorType connectorType) {
            return SharedConnectionSaveHandler.createPersistor(ctx, NamedConnections.instance()::listConnections, props, connectorType, NamedConnections::refresh);
        }

        @Override
        public void addConnection(ConnectionDetails cd) {
            NamedConnections.instance().addImplicitConnection(cd);
        }

        @Override
        public boolean removeConnection(String name) {
            return NamedConnections.instance().removeConnectionImpl(name);
        }
    };
    private final Map<String, DatabaseConnection> openConnections = new HashMap<String, DatabaseConnection>();

    static ConnectionStoreBridge connectionStoreBridge() {
        return BRIDGE;
    }

    static NamedConnections instance() {
        return Holder.INSTANCE;
    }

    static void refresh() {
        ConnectionDefinitions.INSTANCE.refreshConnections();
    }

    private NamedConnections() {
    }

    public Collection<String> listConnections() {
        return ConnectionDefinitions.INSTANCE.listConnections();
    }

    public Connections.Identifier lookupConnectionIdentifier(String name) {
        return ConnectionDefinitions.INSTANCE.lookupConnectionIdentifier(name);
    }

    public ConnectionDefinition getConnectionDefinition(Connections.Identifier id) {
        return ConnectionDefinitions.INSTANCE.getConnectionDefinition(id);
    }

    DatabaseConnection addImplicitConnection(ConnectionDetails cd) {
        ImplicitConnection dbconn = new ImplicitConnection(cd);
        String name = dbconn.getName();
        this.openConnections.remove(name);
        this.openConnections.put(name, dbconn);
        return dbconn;
    }

    private boolean removeConnectionImpl(String name) {
        return name.startsWith("\"") && this.openConnections.remove(name) != null;
    }

    DatabaseConnection findOpenConnection(String name) {
        return this.openConnections.get(name);
    }

    DatabaseConnection findOpenConnection(Connection conn) {
        Map.Entry entry = this.openConnections.entrySet().stream().filter(e -> ((DatabaseConnection)e.getValue()).matchConnection(conn)).findFirst().orElse(null);
        return entry != null ? (DatabaseConnection)entry.getValue() : null;
    }

    private static class Holder {
        private static final NamedConnections INSTANCE = new NamedConnections();

        private Holder() {
        }
    }

    private static class ConnectionDefinitions {
        private static final ConnectionDefinitions INSTANCE = new ConnectionDefinitions();
        private final Map<Connections.Identifier, ConnectionDefinition> connectionDefinitions = new HashMap<Connections.Identifier, ConnectionDefinition>();
        private final Map<String, Connections.Identifier> names = new HashMap<String, Connections.Identifier>();

        private ConnectionDefinitions() {
            this.loadConnections();
        }

        private void loadConnections() {
            ConnectionStorage fileSystem = ConnectionStorage.instance();
            this.names.clear();
            fileSystem.listConnectionDirectories().forEach(id -> this.loadConnection((String)id, fileSystem));
        }

        private void loadConnection(String identifier, ConnectionStorage fileSystem) {
            Connections.Identifier ci = ConnectionIdentifiers.createIdentifier((CharSequence)identifier);
            ConnectionDefinition def = fileSystem.loadConnection(identifier);
            this.connectionDefinitions.put(ci, def);
            String connName = def.getConnectionName();
            this.names.put(connName, ci);
        }

        Collection<String> listConnections() {
            return new TreeSet<String>(this.names.keySet());
        }

        Connections.Identifier lookupConnectionIdentifier(String name) {
            return this.names.get(name);
        }

        ConnectionDefinition getConnectionDefinition(Connections.Identifier id) {
            return this.connectionDefinitions.get(id);
        }

        void refreshConnections() {
            this.connectionDefinitions.clear();
            this.loadConnections();
        }
    }
}

