/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

abstract class ConnectionDefinitionCreator {
    protected final ScriptRunnerContext ctx;
    protected final MessageLogger logger;
    protected final ConfigurationProperties.Builder dbtoolProperties = ConfigurationProperties.builder();
    private final ConfigurationProperties.Builder ojdbcProperties = ConfigurationProperties.builder();
    protected String connectionName;
    protected OracleWallet wallet;

    public ConnectionDefinitionCreator(ScriptRunnerContext ctx, MessageLogger logger) {
        this.ctx = ctx;
        this.logger = logger;
    }

    protected OracleWallet createWallet(String spec, String user, char[] pwd) throws IOException {
        OracleWallet wallet = new OracleWallet();
        wallet.createSSO();
        try {
            OracleSecretStore oss = wallet.getSecretStore();
            int i = 1;
            oss.setSecret("oracle.security.client.connect_string" + i, spec.toCharArray());
            oss.setSecret("oracle.security.client.username" + i, user.toCharArray());
            oss.setSecret("oracle.security.client.password" + i, pwd);
            wallet.setSecretStore(oss);
        }
        catch (OracleSecretStoreException e) {
            throw new IOException(e);
        }
        return wallet;
    }

    protected final void setDbToolsPropertyValue(String key, String value) {
        this.dbtoolProperties.put(key, value);
    }

    protected final void setOjdbcPropertyValue(String key, String value) {
        this.ojdbcProperties.put(key, value);
    }

    public final ConnectionDefinition createDefinition() {
        ConnectionDefinition.Builder builder = ConnectionDefinition.builder((Connections.Identifier)ConnectionIdentifiers.createIdentifier((CharSequence)this.connectionName));
        if (!this.dbtoolProperties.isEmpty()) {
            builder = builder.dbtoolsProperties(this.dbtoolProperties.build());
        }
        if (!this.ojdbcProperties.isEmpty()) {
            builder = builder.ojdbcProperties(this.ojdbcProperties.build());
        }
        if (this.wallet != null) {
            try {
                builder = builder.wallet(this.wallet);
            }
            catch (IOException e) {
                this.logger.logError("Wallet error", (Throwable)e);
            }
        }
        return builder.build();
    }
}

