/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.stripe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cloudstorage.api.stripe.ISegmentInputStreamProcessor;
import oracle.cloudstorage.util.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamStriper<T> {
    private static final Logger logger = LoggerFactory.getLogger(InputStreamStriper.class);
    private final InputStream source;
    private final int width;
    private final int numSegments;
    private final ExecutorService executor;
    private final ISegmentInputStreamProcessor<T>[] processors;
    private final List<Future<ISegmentInputStreamProcessor.ResultProvider<T>>> results;
    private final PipedOutputStream[] buffers;
    private final PipedInputStream[] pipes;
    private final Object concurrentExceptionLock = new Object();
    private long totalRead = 0L;
    private IOException concurrentException;
    private IOException readException;
    private volatile boolean cancelled = false;

    public InputStreamStriper(ExecutorService executor, InputStream largeObjectInputStream, int stripeSegmentWidth, int numSegments) throws IOException {
        this(executor, largeObjectInputStream, stripeSegmentWidth, stripeSegmentWidth, numSegments, null);
    }

    public InputStreamStriper(ExecutorService executor, InputStream largeObjectInputStream, int stripeSegmentWidth, int pipeSize, int numSegments) throws IOException {
        this(executor, largeObjectInputStream, stripeSegmentWidth, pipeSize, numSegments, null);
    }

    public InputStreamStriper(ExecutorService executor, InputStream largeObjectInputStream, int stripeSegmentWidth, ISegmentInputStreamProcessor<T>[] processors) throws IOException {
        this(executor, largeObjectInputStream, stripeSegmentWidth, stripeSegmentWidth, processors.length, processors);
    }

    public InputStreamStriper(ExecutorService executor, InputStream largeObjectInputStream, int stripeSegmentWidth, int pipeSize, ISegmentInputStreamProcessor<T>[] processors) throws IOException {
        this(executor, largeObjectInputStream, stripeSegmentWidth, pipeSize, processors.length, processors);
    }

    private InputStreamStriper(ExecutorService executor, InputStream largeObjectInputStream, int stripeSegmentWidth, int pipeSize, int numSegments, ISegmentInputStreamProcessor<T>[] processors) throws IOException {
        this.source = largeObjectInputStream;
        this.width = stripeSegmentWidth;
        this.numSegments = numSegments;
        this.processors = processors;
        this.results = new ArrayList<Future<ISegmentInputStreamProcessor.ResultProvider<T>>>(numSegments);
        this.buffers = new PipedOutputStream[numSegments];
        this.pipes = new PipedInputStream[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            this.buffers[i] = new PipedOutputStream();
            this.pipes[i] = new PipedInputStream(this.buffers[i], pipeSize);
        }
        this.executor = executor;
    }

    public InputStream[] segment() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    InputStreamStriper.this.readSource();
                }
                catch (Exception e) {
                    InputStreamStriper.this.handleSourceReadException(e);
                    for (PipedInputStream pipe : InputStreamStriper.this.pipes) {
                        try {
                            pipe.close();
                        }
                        catch (IOException e1) {
                            InputStreamStriper.this.handleSourceReadException(e1);
                        }
                    }
                }
            }
        });
        if (this.processors == null) {
            return this.pipes;
        }
        for (int index = 0; index < this.numSegments; ++index) {
            Callable<ISegmentInputStreamProcessor.ResultProvider<T>> processor = this.processor(index);
            this.results.add(this.executor.submit(processor));
            if (this.readException == null) continue;
            this.cancel();
        }
        return this.pipes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResult(int index) throws InterruptedException, ExecutionException {
        if (index >= this.results.size()) {
            logger.warn("null future result for segment {}.", (Object)index);
            return null;
        }
        Future<ISegmentInputStreamProcessor.ResultProvider<T>> futureResultProvider = this.results.get(index);
        if (futureResultProvider == null) {
            logger.warn("null future result for segment {}.", (Object)index);
            return null;
        }
        while (true) {
            Object object = this.concurrentExceptionLock;
            synchronized (object) {
                if (this.readException != null) {
                    throw new ExecutionException("Exception while reading; can't get result for segment " + index, this.readException);
                }
            }
            try {
                ISegmentInputStreamProcessor.ResultProvider<T> resultProvider = futureResultProvider.get(100L, TimeUnit.MILLISECONDS);
                T result = resultProvider == null ? null : (T)resultProvider.get();
                return result;
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwConcurrentException() throws IOException {
        Object object = this.concurrentExceptionLock;
        synchronized (object) {
            if (this.concurrentException != null) {
                throw this.concurrentException;
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
        for (ISegmentInputStreamProcessor<T> processor : this.processors) {
            processor.cancel();
        }
    }

    private void readSource() throws Exception {
        byte[] bytes = new byte[this.width];
        boolean reading = false;
        do {
            reading = false;
            for (PipedOutputStream buffer : this.buffers) {
                int writeLen = 0;
                int read = -1;
                while ((writeLen += (read = this.source.read(bytes, writeLen, bytes.length - writeLen)) < 0 ? 0 : read) <= bytes.length && read > 0 && !this.cancelled) {
                }
                if (writeLen > 0) {
                    ((OutputStream)buffer).write(bytes, 0, writeLen);
                    this.totalRead += (long)writeLen;
                }
                if (this.cancelled || read < 0) {
                    ((OutputStream)buffer).flush();
                    ((OutputStream)buffer).close();
                    continue;
                }
                reading = true;
            }
        } while (reading);
    }

    private Callable<ISegmentInputStreamProcessor.ResultProvider<T>> processor(final int index) {
        Callable processor = new Callable<ISegmentInputStreamProcessor.ResultProvider<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISegmentInputStreamProcessor.ResultProvider<T> call() throws Exception {
                PipedInputStream pipe = null;
                ISegmentInputStreamProcessor.ResultProvider resultProvider = null;
                try {
                    pipe = InputStreamStriper.this.pipes[index];
                    resultProvider = InputStreamStriper.this.processors[index].process(pipe);
                }
                catch (Exception e) {
                    InputStreamStriper.this.handleProcessingException(index, e);
                }
                finally {
                    if (pipe != null) {
                        try {
                            ((InputStream)pipe).close();
                        }
                        catch (Exception e) {
                            InputStreamStriper.this.handleProcessingException(index, e);
                        }
                    }
                }
                return resultProvider;
            }

            public String toString() {
                return "Processor " + index;
            }
        };
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSourceReadException(Exception cause) {
        String message = "Exception thrown reading large object input stream after reading " + this.totalRead + " bytes.";
        IOException detailedException = new IOException(message, cause);
        Object object = this.concurrentExceptionLock;
        synchronized (object) {
            if (this.concurrentException == null) {
                this.concurrentException = detailedException;
            } else {
                Throwables.addSuppressed(this.concurrentException, detailedException);
            }
            if (this.readException == null) {
                this.readException = detailedException;
            } else {
                Throwables.addSuppressed(this.readException, detailedException);
            }
            this.cancel();
            logger.error("", (Throwable)detailedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessingException(int index, Exception cause) {
        String message = "Exception thrown processing input stream segment " + index + ".";
        IOException detailedException = new IOException(message, cause);
        Object object = this.concurrentExceptionLock;
        synchronized (object) {
            if (this.concurrentException == null) {
                this.concurrentException = detailedException;
            } else {
                Throwables.addSuppressed(this.concurrentException, detailedException);
            }
            logger.error("", (Throwable)detailedException);
        }
    }
}

