/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.retry.IDelayProvider;
import oracle.cloudstorage.api.retry.RetryState;

abstract class Backoff
implements IDelayProvider {
    protected static final int DEFAULT_INITIAL_DELAY_MILLIS = 500;
    private final long initialDelayMillis;
    private final double base;
    private final boolean useAttempt;
    private final String description;

    protected Backoff(long initialDelay, TimeUnit units, double base, boolean useAttempt) {
        this.initialDelayMillis = units.toMillis(initialDelay);
        this.base = base;
        this.useAttempt = useAttempt;
        this.description = this.getClass().getSimpleName() + " initial delay " + initialDelay + " " + units.toString().toLowerCase() + ", multiplier base " + base + " applied to " + (useAttempt ? "attempt" : "execution");
    }

    @Override
    public final long getDelayMillis(RetryState retryState) {
        int iteration = this.useAttempt ? retryState.getAttempt() : retryState.getEvaluation();
        long multiplier = this.calculateMultiplier(iteration);
        long delay = this.initialDelayMillis * multiplier;
        return delay;
    }

    protected double getBase() {
        return this.base;
    }

    protected abstract long calculateMultiplier(int var1);

    public String toString() {
        return this.description;
    }
}

