/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.auth;

import oracle.cloudstorage.api.auth.IUser;

public final class StorageUser
implements IUser.PreBuilt {
    public static final String DEFAULT_SERVICE_NAME = "Storage";
    public static final String DEFAULT_USER_NAME = "Storageadmin";
    public static final char SERVICE_NAME_SEP = '-';
    public static final char ACCOUNT_SEP = ':';
    private final String urlRoot;
    private final String storageUser;
    private final String password;
    private final String account;
    private final String serviceName;
    private final String identiyDomain;
    private final String tenant;
    private final String name;

    public StorageUser(final IUser.PreBuilt preBuilt) {
        this(new Properties((IUser.Base)preBuilt){

            @Override
            public String getStorageUser() {
                return preBuilt.getStorageUser();
            }
        });
    }

    public StorageUser(IUser.Base delegate, final IUser.PreBuiltAware preBuilt) {
        this(new Properties(delegate){

            @Override
            public String getStorageUser() {
                return preBuilt.getStorageUser();
            }
        });
    }

    public StorageUser(final IUser.FromTenant tenant) {
        this(new Properties((IUser.Base)tenant){

            @Override
            public String getTenant() {
                return tenant.getTenant();
            }
        });
    }

    public StorageUser(IUser.Base delegate, final IUser.TenantAware tenant) {
        this(new Properties(delegate){

            @Override
            public String getTenant() {
                return tenant.getTenant();
            }
        });
    }

    public StorageUser(final IUser.FromAccount account) {
        this(new Properties((IUser.WithName)account){

            @Override
            public String getAccount() {
                return account.getAccount();
            }
        });
    }

    public StorageUser(IUser.Base delegate, final IUser.AccountAware account) {
        this(new Properties(delegate){

            @Override
            public String getName() {
                return account.getName();
            }

            @Override
            public String getAccount() {
                return account.getAccount();
            }
        });
    }

    public StorageUser(final IUser.FromIdentityDomain identityDomain) {
        this(new Properties((IUser.WithName)identityDomain){

            @Override
            public String getServiceName() {
                return identityDomain.getServiceName();
            }

            @Override
            public String getIdentityDomain() {
                return identityDomain.getIdentityDomain();
            }
        });
    }

    public StorageUser(IUser.Base delegate, final IUser.IdentityDomainAware identityDomain) {
        this(new Properties(delegate){

            @Override
            public String getName() {
                return identityDomain.getName();
            }

            @Override
            public String getServiceName() {
                return identityDomain.getServiceName();
            }

            @Override
            public String getIdentityDomain() {
                return identityDomain.getIdentityDomain();
            }
        });
    }

    public StorageUser(IUser.Base delegate, final IUser.PropertiesAware properties) {
        this(new Properties(delegate){

            @Override
            public String getStorageUser() {
                return properties.getStorageUser();
            }

            @Override
            public String getTenant() {
                return properties.getTenant();
            }

            @Override
            public String getAccount() {
                return properties.getAccount();
            }

            @Override
            public String getName() {
                return properties.getName();
            }

            @Override
            public String getServiceName() {
                return properties.getServiceName();
            }

            @Override
            public String getIdentityDomain() {
                return properties.getIdentityDomain();
            }
        });
    }

    public StorageUser(IUser.Properties properties) {
        this.urlRoot = properties.getUrlRoot();
        this.password = properties.getPassword();
        if (StorageUser.isSet(properties.getStorageUser())) {
            this.storageUser = properties.getStorageUser();
        } else if (StorageUser.isSet(properties.getTenant())) {
            this.storageUser = "Storage-" + properties.getTenant() + ':' + DEFAULT_USER_NAME;
        } else if (StorageUser.isSet(properties.getAccount(), properties.getName())) {
            this.storageUser = properties.getAccount() + ':' + properties.getName();
        } else if (StorageUser.isSet(properties.getServiceName(), properties.getIdentityDomain(), properties.getName())) {
            this.storageUser = properties.getServiceName() + '-' + properties.getIdentityDomain() + ':' + properties.getName();
        } else {
            throw new IllegalArgumentException("Could not build storage user from: \n  storageUser: " + properties.getStorageUser() + "\n  tenant: " + properties.getTenant() + "\n  name: " + properties.getName() + "\n  account: " + properties.getAccount() + "\n  serviceName: " + properties.getServiceName() + "\n  identityDomain: " + properties.getIdentityDomain());
        }
        String[] storageUserParts = this.storageUser == null ? null : this.storageUser.split(":");
        this.account = storageUserParts == null || storageUserParts.length <= 0 ? null : storageUserParts[0];
        this.name = storageUserParts == null || storageUserParts.length <= 1 ? null : storageUserParts[1];
        String[] accountParts = this.account == null ? null : this.account.split("-");
        this.serviceName = accountParts == null || accountParts.length <= 0 ? null : accountParts[0];
        this.tenant = this.identiyDomain = accountParts == null || accountParts.length <= 1 ? null : accountParts[1];
    }

    @Override
    public final String getUrlRoot() {
        return this.urlRoot;
    }

    @Override
    public final String getStorageUser() {
        return this.storageUser;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    public final String getAccount() {
        return this.account;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getIdentiyDomain() {
        return this.identiyDomain;
    }

    public final String getTenant() {
        return this.tenant;
    }

    public final String getName() {
        return this.name;
    }

    private static boolean isSet(String ... strings) {
        for (String s : strings) {
            if (s == null) {
                return false;
            }
            if (!s.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static abstract class Properties
    implements IUser.Properties {
        private final IUser.Base base;
        private final IUser.NameAware named;

        private Properties(IUser.Base base) {
            this.base = base;
            this.named = null;
        }

        private Properties(IUser.WithName named) {
            this.base = named;
            this.named = named;
        }

        @Override
        public final String getUrlRoot() {
            return this.base.getUrlRoot();
        }

        @Override
        public final String getPassword() {
            return this.base.getPassword();
        }

        @Override
        public String getName() {
            return this.named == null ? null : this.named.getName();
        }

        @Override
        public String getTenant() {
            return null;
        }

        @Override
        public String getAccount() {
            return null;
        }

        @Override
        public String getServiceName() {
            return null;
        }

        @Override
        public String getIdentityDomain() {
            return null;
        }

        @Override
        public String getStorageUser() {
            return null;
        }
    }
}

