/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import oracle.arbori.util.Service;
import oracle.dbtools.db.OracleUtil;

public class Service
extends oracle.arbori.util.Service {
    public static String cleanIdentifier(String s, List<String> ids, String type, char quoteChar, Locale locale) {
        Service.CLEAN_TYPE cl = Service.CLEAN_TYPE.TRANSFORM30;
        try {
            cl = Service.CLEAN_TYPE.valueOf((String)type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Service.cleanIdentifier(s, ids, cl, quoteChar, locale);
    }

    public static String cleanIdentifier(String s, List<String> uniqueIds, Service.CLEAN_TYPE clean, char quoteChar, Locale locale) {
        String uName;
        if (s == null) {
            return "";
        }
        if (Service.CLEAN_TYPE.OFF == clean) {
            return s;
        }
        boolean isTransform = Service.CLEAN_TYPE.TRANSFORM30 == clean || Service.CLEAN_TYPE.TRANSFORM128 == clean;
        int idSize = Service.CLEAN_TYPE.TRANSFORM30 == clean || Service.CLEAN_TYPE.QUOTE30 == clean ? 30 : 128;
        String quoteString = String.valueOf(quoteChar);
        boolean isQuote = false;
        String name = s;
        if (Service.CLEAN_TYPE.UNIQUE == clean) {
            return Service.shortenIdentifier((String)name, uniqueIds, (int)idSize);
        }
        String string = uName = locale == null ? name.toUpperCase() : name.toUpperCase(locale);
        if (isTransform) {
            name = uName;
        }
        if (name.startsWith(quoteString) && name.endsWith(quoteString)) {
            name = s.substring(1, s.length() - 1);
        }
        if (isTransform) {
            if (OracleUtil.getReservedWords().contains(name)) {
                return name + "$";
            }
        } else if (OracleUtil.getReservedWords().contains(uName)) {
            return MessageFormat.format("{0}{1}{0}", quoteString, name);
        }
        String ALLOWED_CHARS = "$#_";
        Object cleanId = "";
        IntStream codePoints = name.codePoints();
        PrimitiveIterator.OfInt iter = codePoints.iterator();
        String HYPHEN = "-";
        while (iter.hasNext()) {
            boolean isBasicChar;
            Integer codePoint = (Integer)iter.next();
            String codePointStr = String.format("%c", codePoint);
            boolean bl = (!isTransform ? Character.isUpperCase(codePoint) : Character.isAlphabetic(codePoint)) || Character.isDigit(codePoint) ? true : (isBasicChar = false);
            if (Character.isWhitespace(codePoint) || codePointStr.equals(HYPHEN)) {
                if (isTransform) {
                    cleanId = (String)cleanId + "_";
                    continue;
                }
                cleanId = (String)cleanId + codePointStr;
                isQuote = true;
                continue;
            }
            if (Character.isSupplementaryCodePoint(codePoint) || !isBasicChar && ALLOWED_CHARS.indexOf(codePoint) < 0) {
                if (isTransform) {
                    cleanId = (String)cleanId + "#";
                    continue;
                }
                cleanId = (String)cleanId + codePointStr;
                isQuote = true;
                continue;
            }
            cleanId = (String)cleanId + codePointStr;
        }
        if (((String)cleanId).length() > 0 && (((String)cleanId).startsWith("_") || ((String)cleanId).startsWith("$") || ((String)cleanId).startsWith("#") || Character.isDigit(((String)cleanId).codePointAt(0)))) {
            if (isTransform) {
                cleanId = "X" + (String)cleanId;
            } else {
                isQuote = true;
            }
        }
        if (!isQuote) {
            quoteString = "";
        }
        return MessageFormat.format("{0}{1}{0}", quoteString, Service.shortenIdentifier((String)cleanId, uniqueIds, (int)idSize));
    }
}

