/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.vault;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.vault.VaultConnection;
import oracle.dbtools.raptor.vault.VaultHealth;
import oracle.dbtools.raptor.vault.VaultResponse;

public class VaultUtils {
    private String _basePath = "cubbyhole/";
    private String _address = null;
    private String _token = null;
    private String _vaultVersion = "v1";

    private VaultUtils(String address, String base, String token) {
        if (base != null) {
            this._basePath = base.endsWith("/") ? base : base + "/";
        }
        this._address = address;
        this._token = token;
    }

    private VaultHealth getVaultHealth() throws IOException {
        String path = this._address + "/" + this._vaultVersion + "/sys/health?standbycode=200&sealedcode=200&uninitcode=200&drsecondarycode=200&performancestandbycode=200";
        VaultResponse ret = this.sendGET(path);
        return new VaultHealth(ret.getFullResponseData());
    }

    public boolean isValid() {
        if (this._address == null || this._token == null) {
            return false;
        }
        Boolean isSealedOrInvalid = true;
        try {
            isSealedOrInvalid = this.getVaultHealth().getSealed();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isSealedOrInvalid == false;
    }

    public String toString() {
        return "\tAddress     :" + this._address + "\n\tToken       :" + this._token + "\n\tBaseAddress :" + this._basePath + "\n";
    }

    public String getVaultAddress() {
        return this._address;
    }

    public String getBasePath() {
        return this._basePath;
    }

    public boolean getVault() {
        return this._address != null && this._address.startsWith("http") && this._token != null && !this._token.equals("");
    }

    public List<String> listVault() throws IOException {
        return this.listVault(null);
    }

    public List<String> listVault(String path) throws IOException {
        Object uri;
        VaultResponse ret;
        ArrayList<String> list = new ArrayList<String>();
        if (this.isValid() && (ret = this.sendGET(((String)(uri = (String)uri + (((String)(uri = this.buildRequest(path))).endsWith("/") ? "" : "/") + "?list=true")).toString())).getResponseCode() == 200) {
            Object base;
            Map<String, ?> d = ret.getResponseData();
            List entries = null;
            if (d != null && d instanceof Map && d.get("keys") instanceof List) {
                entries = (List)d.get("keys");
            }
            Object object = base = path == null ? "" : path;
            if (path != null) {
                base = (String)base + (!path.endsWith("/") ? "/" : "");
            }
            for (String entry : entries) {
                if (entry.endsWith("/")) {
                    list.addAll(this.listVault((String)base + entry));
                    continue;
                }
                list.add((String)base + entry);
            }
        }
        return list;
    }

    private String buildRequest(String path) {
        StringBuilder uri = new StringBuilder(this._address + "/" + this._vaultVersion + "/");
        uri.append(this._basePath.replaceAll("(//+)", "/"));
        if (!this._basePath.endsWith("/")) {
            uri.append("/");
        }
        uri.append(path == null ? "" : path.replaceAll("\"", "").replaceAll("(//+)", "/"));
        String ret = uri.toString();
        return ret;
    }

    public VaultResponse getVaultBaseConnectionDetails(String path) {
        VaultResponse ret = null;
        String uri = this.buildRequest(path);
        try {
            ret = this.sendGET(uri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public VaultConnection getConnection(String name) throws SQLException {
        VaultResponse vaultDetails = this.getVaultBaseConnectionDetails(name);
        Map<String, ?> data = vaultDetails.getResponseData();
        if (data != null) {
            Properties properties = new Properties();
            properties.putAll(data);
            Object url = null;
            url = data.get("jdbc.url") == null ? "jdbc:oracle:" + String.valueOf(data.get("jdbc.type") != null ? data.get("jdbc.type") : "thin") + ":@" + String.valueOf(data.get("tns")) : (String)data.get("jdbc.url");
            Connection vconn = DriverManager.getConnection((String)url, properties);
            return new VaultConnection(vconn, (String)url, properties);
        }
        return null;
    }

    public void delete(String key) throws IOException {
        String path = this.buildRequest(key);
        this.sendDELETE(path);
    }

    public String store2vault(Connection conn, String jdbcurl, Properties props, String key) throws IOException {
        if (key == null) {
            key = DBUtil.getInstance(conn).executeOracleReturnOneCol("select sys_context('USERENV','SERVICE_NAME')||'/'||case when regexp_like (user, '^[[:upper:]]+$') then lower(user) else user end path from dual", null);
        }
        Properties secrets = props;
        secrets.put("jdbc.url", jdbcurl);
        SimpleDateFormat dFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        secrets.put("savedon", dFormat.format(new Date()));
        String path = this.buildRequest(key);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.sendPOST(path, secrets);
        return path;
    }

    private VaultResponse sendGET(String url) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("X-Vault-Token", this._token);
        return new VaultResponse(con);
    }

    private VaultResponse sendDELETE(String url) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("DELETE");
        con.setRequestProperty("X-Vault-Token", this._token);
        return new VaultResponse(con);
    }

    private VaultResponse sendPOST(String url, Map payload) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("X-Vault-Token", this._token);
        con.setDoOutput(true);
        OutputStream os = con.getOutputStream();
        JSON.std.write((Object)payload, os);
        os.flush();
        os.close();
        return new VaultResponse(con);
    }

    public static class Builder {
        String _token;
        String _address;
        String _base;

        public Builder setToken(String token) {
            this._token = token;
            return this;
        }

        public Builder setAddress(String address) {
            this._address = address;
            return this;
        }

        public Builder setBase(String base) {
            this._base = base;
            return this;
        }

        public VaultUtils build() {
            return new VaultUtils(this._address, this._base, this._token);
        }
    }
}

