/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;

public final class JDBCProxyUtil {
    private static final String PROXY_REGISTRY_CLASS = "oracle.dbtools.raptor.proxy.ProxyRegistry";
    private static final String PROXY_REGISTRY_UNWRAP = "unwrap";
    private static final String PROXY_REGISTRY_PROXY_FOR = "jdbcProxyFor";
    private static JDBCProxyUtil INSTANCE = null;
    private ClassLoader classLoader = null;
    private Class<?> proxyRegistryClass = null;
    private Method unwrapMethod = null;
    private Method jdbcProxyForMethod = null;
    private ClassLoader classLoaderHint = null;

    private JDBCProxyUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static JDBCProxyUtil getInstance(ClassLoader classLoaderHint) {
        if (INSTANCE == null) {
            Class<JDBCProxyUtil> clazz = JDBCProxyUtil.class;
            // MONITORENTER : oracle.dbtools.raptor.utils.JDBCProxyUtil.class
            if (INSTANCE == null) {
                INSTANCE = new JDBCProxyUtil();
            }
            // MONITOREXIT : clazz
        }
        INSTANCE.suggestClassLoader(classLoaderHint);
        return INSTANCE;
    }

    public static JDBCProxyUtil getInstance() {
        return JDBCProxyUtil.getInstance(null);
    }

    public Connection jdbcProxyFor(Connection conn, Properties p) {
        if (conn != null) {
            try {
                Method jdbcProxy = this.jdbcProxyForMethod;
                if (jdbcProxy == null) {
                    Class<?> registryClass = this.proxyRegistryClass != null ? this.proxyRegistryClass : this.loadClass(PROXY_REGISTRY_CLASS, conn.getClass().getClassLoader());
                    this.proxyRegistryClass = registryClass;
                    this.jdbcProxyForMethod = jdbcProxy = registryClass.getMethod(PROXY_REGISTRY_PROXY_FOR, Connection.class, Properties.class);
                }
                conn = (Connection)jdbcProxy.invoke(null, conn, p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return conn;
    }

    public <T> T unwrap(T obj) {
        if (obj != null) {
            try {
                Method unwrap = this.unwrapMethod;
                if (unwrap == null) {
                    Class<?> registryClass = this.proxyRegistryClass != null ? this.proxyRegistryClass : this.loadClass(PROXY_REGISTRY_CLASS, obj.getClass().getClassLoader());
                    this.proxyRegistryClass = registryClass;
                    this.unwrapMethod = unwrap = registryClass.getMethod(PROXY_REGISTRY_UNWRAP, Object.class);
                }
                obj = unwrap.invoke(null, obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj;
    }

    private Class<?> loadClass(String className, ClassLoader contextClassLoader) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.classLoader != null) {
            clazz = this.classLoader.loadClass(className);
        }
        if (clazz == null && this.classLoaderHint != null) {
            try {
                clazz = this.classLoaderHint.loadClass(className);
                this.setClassLoader(this.classLoaderHint);
            }
            catch (Exception e) {
                this.suggestClassLoader(null);
            }
        }
        if (clazz == null && contextClassLoader != null) {
            clazz = contextClassLoader.loadClass(className);
            this.setClassLoader(contextClassLoader);
        }
        return clazz;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.suggestClassLoader(null);
    }

    public synchronized void suggestClassLoader(ClassLoader classLoaderHint) {
        this.classLoaderHint = classLoaderHint != null && this.classLoader == null ? classLoaderHint : null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

