/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.io.Serializable;
import oracle.dbtools.raptor.query.QueryParameter;

public class Column
extends QueryParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String onClickClass;
    private String format;
    private String align;
    private String vAlign;
    private String id;
    private String cellRenderer;
    private String cellEditor;
    private String cellPopup;
    private ClassLoader classLoader;
    private Boolean editable;
    private Boolean hidden;

    public Column() {
    }

    public Column(String name, String align, String vAlign, String format) {
        this.setName(name);
        if (align != null) {
            this.setAlign(align);
        }
        if (vAlign != null) {
            this.setVAlign(vAlign);
        }
        if (format != null) {
            this.format = format;
        }
    }

    public void setOnClickClass(String onClickClass) {
        this.onClickClass = onClickClass;
    }

    public String getOnClickClass() {
        return this.onClickClass;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getAlign() {
        return this.align;
    }

    public void setVAlign(String vAlign) {
        this.vAlign = vAlign;
    }

    public String getVAlign() {
        return this.vAlign;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public String toXML(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(Column.getIndent(indent) + "<column");
        if (this.format != null) {
            sb.append(" colFormat=\"" + this.format + "\"");
        }
        if (this.align != null) {
            sb.append(" align=\"" + this.align + "\"");
        }
        if (this.vAlign != null) {
            sb.append(" valign=\"" + this.vAlign + "\"");
        }
        if (this.hidden != null) {
            sb.append(" hidden=\"" + this.hidden.toString() + "\"");
        }
        if (this.editable != null) {
            sb.append(" isEditable=\"" + this.editable.toString() + "\"");
        }
        if (this.cellRenderer != null) {
            sb.append(" cellRenderer=\"" + this.cellRenderer + "\"");
        }
        if (this.cellEditor != null) {
            sb.append(" cellEditor=\"" + this.cellEditor + "\"");
        }
        if (this.cellPopup != null) {
            sb.append(" cellPopup=\"" + this.cellPopup + "\"");
        }
        sb.append(this.getBaseAttributes());
        sb.append(">\n");
        sb.append(Column.getIndent(indent + 1) + "<colName><![CDATA[" + this.getName() + "]]></colName>\n");
        sb.append(this.getBaseChildren(indent + 1));
        sb.append(Column.getIndent(indent) + "</column>\n");
        return sb.toString();
    }

    public void setCellRenderer(String cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    public String getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(String cellEditor) {
        this.cellEditor = cellEditor;
    }

    public String getCellEditor() {
        return this.cellEditor;
    }

    public void setCellPopup(String cellPopup) {
        this.cellPopup = cellPopup;
    }

    public String getCellPopup() {
        return this.cellPopup;
    }

    public void setEditable(boolean edit) {
        this.editable = new Boolean(edit);
    }

    public Boolean isEditable() {
        return this.editable != null && this.editable != false;
    }

    public void setHidden(boolean hide) {
        this.hidden = hide;
    }

    public boolean isHidden() {
        if (this.hidden == null) {
            return false;
        }
        return this.hidden;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

