/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.proxy.ProxySelectorImpl;
import oracle.dbtools.raptor.proxy.Strings;
import oracle.dbtools.raptor.proxy.SystemProxyType;
import oracle.dbtools.util.Logger;

class ProxyConfig {
    public static final String SQLCL_SYSTEM_HTTP_PROXY = "dbtools.system_http_proxy";
    public static final String SQLCL_SYSTEM_NON_PROXY_HOSTS = "dbtools.system_http_non_proxy_hosts";
    public static final String DIRECT = "DIRECT";
    public static final String PAC_PREFIX = "PAC ";
    public static final String HTTP_PROTOCOL_PREFIX = "http://";
    public static final String DEFAULT_HTTP_PROXY_PORT = "80";
    public static final String DEFAULT_SOCKS_PROXY_PORT = "1080";
    private static final String PROXY_EXCEPTION_SEPARATOR = "|";
    private static String DEFAULT_PROXY_EXCEPTIONS = "";
    static final String[] LOCAL_PROXY_EXCEPTIONS = new String[]{"localhost", "localhost.localdomain", "127.0.0.1", "[::1]"};
    private SystemProxyType systemProxyType = SystemProxyType.DIRECT_CONNECTION;
    private String systemProxyHost;
    private String systemProxyPort;
    private String systemProxyExceptions;
    private String pacFile;

    public static String ensureLocalExceptionsAdded(String proxyExceptions) {
        String normalizedExceptions = ProxyConfig.normalizeExceptions(proxyExceptions);
        String[] currentExceptions = ProxyConfig.splitExceptionsIntoArray(normalizedExceptions);
        StringBuffer sb = ModelUtil.hasLength(normalizedExceptions) ? new StringBuffer(normalizedExceptions) : new StringBuffer();
        List<String> localExceptions = ProxyConfig.getLocalExceptions();
        for (String exception : localExceptions) {
            if (ProxyConfig.containsException(currentExceptions, exception)) continue;
            if (sb.length() > 0) {
                sb.append(PROXY_EXCEPTION_SEPARATOR);
            }
            sb.append(exception);
        }
        return sb.toString();
    }

    static boolean containsException(String[] currentExceptions, String exception) {
        boolean retval = false;
        if (currentExceptions != null && currentExceptions.length != 0 && exception.length() > 0) {
            for (String currentException : currentExceptions) {
                if (!currentException.equals(exception)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    static String normalizeExceptions(String exceptions) {
        String normalizedExceptions = exceptions;
        if (normalizedExceptions == null || normalizedExceptions.trim().length() == 0) {
            normalizedExceptions = DEFAULT_PROXY_EXCEPTIONS;
        } else {
            normalizedExceptions = normalizedExceptions.toLowerCase();
            normalizedExceptions = normalizedExceptions.replaceAll(",", PROXY_EXCEPTION_SEPARATOR);
            if (PlatformUtils.isWindows()) {
                normalizedExceptions = normalizedExceptions.replaceAll(";", PROXY_EXCEPTION_SEPARATOR);
            }
            normalizedExceptions = normalizedExceptions.replaceAll(" ", "");
            normalizedExceptions = normalizedExceptions.replaceAll("\\[", "");
            normalizedExceptions = normalizedExceptions.replaceAll("\\]", "");
        }
        return normalizedExceptions;
    }

    public static String[] splitExceptionsIntoArray(String exceptions) {
        String[] currentExceptions = null;
        if (ModelUtil.hasLength(exceptions)) {
            currentExceptions = exceptions.split("\\|");
        }
        return currentExceptions;
    }

    private static List<String> getLocalExceptions() {
        ArrayList<String> localExceptions = new ArrayList<String>(LOCAL_PROXY_EXCEPTIONS.length);
        for (String exception : LOCAL_PROXY_EXCEPTIONS) {
            localExceptions.add(exception);
        }
        try {
            InetAddress address = InetAddress.getLocalHost();
            String name = address.getCanonicalHostName();
            if (name != null) {
                localExceptions.add(name);
            }
            if ((name = address.getHostName()) != null) {
                localExceptions.add(name);
            }
            if ((name = address.getHostAddress()) != null) {
                localExceptions.add(name);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localExceptions;
    }

    static ProxyConfig getProxyConfiguration() {
        return Holder.INSTANCE;
    }

    private ProxyConfig() {
        this.initializeProxySettings();
    }

    SystemProxyType getProxyType() {
        return this.systemProxyType;
    }

    String getPACFile() {
        return this.pacFile;
    }

    String getHttpProxyHost() {
        return this.systemProxyHost;
    }

    String getHttpProxyPort() {
        return this.systemProxyPort;
    }

    String getHttpProxyExceptions() {
        return this.systemProxyExceptions;
    }

    private void initializeProxySettings() {
        String proxyHost = System.getProperty(SQLCL_SYSTEM_HTTP_PROXY);
        if (DIRECT.equals(proxyHost) || proxyHost == null || proxyHost.trim().length() == 0) {
            this.systemProxyType = SystemProxyType.DIRECT_CONNECTION;
            this.systemProxyHost = null;
            this.systemProxyPort = null;
            this.systemProxyExceptions = null;
        } else if (proxyHost.startsWith(PAC_PREFIX)) {
            this.systemProxyType = SystemProxyType.PAC;
            String SOME_EXTERNAL_HTTP_URL = "http://www.internic.net";
            try {
                List<Proxy> proxyList;
                URI someExtHttpUri = new URI("http://www.internic.net");
                this.pacFile = proxyHost.substring(PAC_PREFIX.length());
                if (this.pacFile != null && (proxyList = ProxySelectorImpl.resolveProxyListFromPAC(someExtHttpUri, this.pacFile)).size() > 0) {
                    Proxy p = proxyList.get(0);
                    if (Proxy.Type.DIRECT == p.type()) {
                        this.systemProxyHost = null;
                        this.systemProxyPort = null;
                    } else if (p.address() instanceof InetSocketAddress) {
                        this.systemProxyHost = ((InetSocketAddress)p.address()).getHostName();
                        this.systemProxyPort = Integer.toString(((InetSocketAddress)p.address()).getPort());
                    } else {
                        this.systemProxyHost = null;
                    }
                }
                this.systemProxyExceptions = ProxyConfig.ensureLocalExceptionsAdded(null);
            }
            catch (Exception e) {
                Logger.fine(ProxySelectorImpl.class, "Failed to get system proxy settings from DefaultProxySelector. Default to no proxy.");
            }
        } else {
            this.systemProxyType = SystemProxyType.MANUAL_PROXY;
            String[] hostAndPort = Strings.hostAndPort(proxyHost);
            if (hostAndPort != null) {
                this.systemProxyHost = hostAndPort[0];
                this.systemProxyPort = hostAndPort[1] == null ? DEFAULT_HTTP_PROXY_PORT : hostAndPort[1];
            } else {
                Logger.warn(ProxySelectorImpl.class, "dbtools.system_http_proxy env var is invalid: " + proxyHost);
            }
            String nonProxyHosts = System.getProperty(SQLCL_SYSTEM_NON_PROXY_HOSTS);
            this.systemProxyExceptions = ProxyConfig.ensureLocalExceptionsAdded(nonProxyHosts);
        }
    }

    void reset() {
        this.initializeProxySettings();
    }

    private static class Holder {
        static final ProxyConfig INSTANCE = new ProxyConfig();

        private Holder() {
        }
    }
}

