/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPLTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraTemporalDatumFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMPLTZ;

public class OraTIMESTAMPLTZFormat
extends OraTemporalDatumFormat {
    private TimeZone dbTimeZone;

    public OraTIMESTAMPLTZFormat(String pattern, OraLocaleInfo localeInfo, TimeZone dbTimeZone, TimeZone sessionTimeZone) throws ParseException {
        super(pattern, localeInfo, sessionTimeZone);
        this.dbTimeZone = dbTimeZone;
    }

    @Override
    public void applyPattern(String pattern) throws ParseException {
        String uc = pattern.toUpperCase(Locale.US);
        StringBuffer pat = new StringBuffer(pattern);
        super.applyPattern(pat.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPLTZFormat && super.equals(object);
    }

    public String format(TIMESTAMPLTZ date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMPLTZ date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.formatTemporalDatum(OraTIMESTAMPLTZ.getInstance(date, this.getDbTimeZone()).setSessionTimeZone(this.getSessionTimeZone()), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null || obj instanceof TIMESTAMPLTZ) {
            return this.format((TIMESTAMPLTZ)obj, toAppendTo, pos);
        }
        throw new IllegalArgumentException(Messages.getString("OraTIMESTAMPLTZFormat.80"));
    }

    public TIMESTAMPLTZ parse(String text, ParsePosition pos) {
        OraTIMESTAMPLTZ temporalDatum = (OraTIMESTAMPLTZ)this.parseTemporalDatum(text, pos, this.getSessionTimeZone());
        return temporalDatum != null ? temporalDatum.getDatum() : null;
    }

    protected TimeZone getDbTimeZone() {
        return this.dbTimeZone;
    }

    @Override
    protected OraTemporalDatum getTemporalDatum(Calendar calendar, int nanos) {
        return OraTIMESTAMPLTZ.getInstance(calendar, nanos).setDBTimeZone(this.getDbTimeZone()).setSessionTimeZone(this.getSessionTimeZone());
    }
}

