/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALYM;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraIntervalDatumFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.INTERVALYM;

public class OraINTERVALYMFormat
extends OraIntervalDatumFormat {
    public OraINTERVALYMFormat(OraLocaleInfo localeInfo) throws ParseException {
        super(localeInfo);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraINTERVALYMFormat && super.equals(object);
    }

    public String format(INTERVALYM date) {
        return this.format(date, new StringBuffer(), new FieldPosition(255)).toString();
    }

    public StringBuffer format(INTERVALYM interval, StringBuffer toAppendTo, FieldPosition pos) {
        if (interval != null) {
            OraINTERVALYM iVal = OraINTERVALYM.getInstance(interval);
            int sign = iVal.get(0);
            int years = iVal.get(1);
            int months = iVal.get(2);
            String str = (sign == -1 ? "-" : "+") + String.format("%02d", years) + "-" + String.format("%02d", months);
            toAppendTo.append(str);
        }
        return toAppendTo;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null || obj instanceof INTERVALYM) {
            return this.format((INTERVALYM)obj, toAppendTo, pos);
        }
        throw new IllegalArgumentException(Messages.getString("OraINTERVALYMFormat.100"));
    }

    public INTERVALYM parse(String text, ParsePosition pos) {
        if (text != null && text.length() > 0) {
            byte[] bytes = INTERVALYM.toBytes((String)text.substring(pos.getIndex()));
            return new INTERVALYM(bytes);
        }
        return null;
    }
}

