/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Attribute;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.ChainedTransformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.PrimitiveTransformers;

public abstract class AttributeBuilder<B extends AttributeBuilder<B>> {
    private Class<?> type;
    private boolean required;
    private Transformer<String, ?> transformer;
    private List<SemanticCompleter> completers = new LinkedList<SemanticCompleter>();
    private Object defaultValue;

    public B dataType(Class<?> type) {
        this.type = type;
        return (B)this;
    }

    public B transformer(Transformer<String, ?> ... transformer) {
        this.transformer = transformer.length == 1 ? transformer[0] : new ChainedTransformer(transformer);
        return (B)this;
    }

    public B completer(SemanticCompleter ... completer) {
        for (SemanticCompleter tmp : completer) {
            this.completers.add(tmp);
        }
        return (B)this;
    }

    public B required() {
        this.required = true;
        return (B)this;
    }

    public B defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return (B)this;
    }

    protected AttributeBuilder() {
    }

    protected void validate(AttributeImpl<?> attribute) {
        if (attribute.defaultValue != null && !attribute.type.isAssignableFrom(attribute.defaultValue.getClass())) {
            throw new IllegalArgumentException("type of defaultValue is inconsistent with the type of attribute with name " + attribute.getName());
        }
    }

    protected static abstract class AttributeImpl<T>
    implements Attribute<T> {
        private final Class<T> type;
        private final boolean required;
        private final Transformer<String, T> transformer;
        private List<SemanticCompleter> completers;
        private final T defaultValue;

        protected AttributeImpl(AttributeBuilder<?> builder) {
            this.type = builder.type != null ? builder.type : String.class;
            this.required = builder.required;
            this.transformer = builder.transformer == null ? PrimitiveTransformers.get(this.type) : builder.transformer;
            this.completers = builder.completers;
            this.defaultValue = builder.defaultValue;
        }

        @Override
        public Class<T> getDataType() {
            return this.type;
        }

        @Override
        public Transformer<String, T> getTransformer() {
            return this.transformer;
        }

        @Override
        public List<SemanticCompleter> getSemanticCompleters() {
            return this.completers;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }
    }
}

