/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.DescribePrep;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.IListPrinter;
import oracle.dbtools.raptor.utils.ListPrinter;
import oracle.dbtools.raptor.utils.ResolvedDBObject;

@Restricted(level=Restricted.Level.NONE)
public class Info
extends CommandListener
implements IHelp {
    private static final String PADDING = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ";
    private static final String PADLINE = "\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac";
    private static final String PADMID = "\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd\u00e2\u2022\ufffd";
    private static final String THE_RETURN_VALUE_OF_A_FUNCTION = "this is the return value of a function call";
    static QueryXMLSupport s_xml = null;
    private static final Logger LOGGER = Logger.getLogger(Info.class.getName());
    private long _lastTime;
    private boolean _debug = false;
    private static IListPrinter _listPrinter = new ListPrinter();
    private boolean withStats;
    private static final String m_lineSeparator = System.getProperty("line.separator");

    protected static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(Info.class.getClassLoader(), "oracle/dbtools/raptor/newscriptrunner/commands/describe.xml"));
        }
        return s_xml;
    }

    private void startTime() {
        if (this._debug) {
            this._lastTime = System.currentTimeMillis();
        }
    }

    private void time(String s) {
        if (this._debug) {
            System.out.println("->" + s + ":" + (System.currentTimeMillis() - this._lastTime));
            this._lastTime = System.currentTimeMillis();
        }
    }

    @Override
    public String getCommand() {
        return "INFORMATION";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql();
        if (Info.matches("information", sql) || cmd.getLoweredTrimmedSQL().startsWith("info+")) {
            String rawName;
            String string = rawName = sql.indexOf(" ") > 0 ? sql.substring(sql.indexOf(" ")).trim() : null;
            if (rawName == null) {
                ctx.write(this.getHelp());
                return true;
            }
            if (rawName.toLowerCase().startsWith("loadxmlquerydefinitions")) {
                String newXml = rawName.substring(rawName.indexOf(" ")).trim();
                s_xml = null;
                s_xml = QueryXMLSupport.getQueryXMLSupport(new MetaResource(this.getClass().getClassLoader(), "file://" + newXml));
                if (s_xml == null) {
                    ctx.write("Could not load : " + newXml);
                }
                this._debug = false;
                return true;
            }
            if (rawName.toLowerCase().startsWith("debugxmlquerydefinitions")) {
                this._debug = true;
            }
            if (rawName.toLowerCase().startsWith("nodebugxmlquerydefinitions")) {
                this._debug = false;
            }
            if (rawName == null || rawName.length() == 0) {
                ctx.write(ScriptRunnerDbArb.getString("INFO_USAGE") + "\n");
                return true;
            }
            this.withStats = sql.split(" ")[0].endsWith("+");
            String filter = null;
            ResolvedDBObject dbObj = ResolvedDBObject.resolveDBObject(conn, rawName, filter);
            if (dbObj != null && dbObj.isBad()) {
                ctx.write(MessageFormat.format(Messages.getString("Info.19"), rawName));
                return true;
            }
            if (dbObj != null) {
                switch (dbObj.getType()) {
                    case 1: {
                        this.describeIndex(conn, ctx, dbObj);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.describeTable(conn, ctx, dbObj);
                        break;
                    }
                    case 6: {
                        this.describeSequence(conn, ctx, dbObj);
                        break;
                    }
                    case 7: 
                    case 8: {
                        this.describeProc(conn, ctx, dbObj);
                        break;
                    }
                    case 9: {
                        this.describePackage(conn, ctx, dbObj);
                        break;
                    }
                    case 13: {
                        this.describeType(conn, ctx, dbObj);
                        break;
                    }
                    case 151: {
                        this.describeDimension(conn, ctx, dbObj);
                        break;
                    }
                    case 150: {
                        this.describeHierarchy(conn, ctx, dbObj);
                        break;
                    }
                    case 152: {
                        this.describeAnalyticView(conn, ctx, dbObj);
                        break;
                    }
                    default: {
                        this.write(ctx, MessageFormat.format(Messages.getString("Info.20"), rawName));
                        break;
                    }
                }
            } else {
                SQLCommand cmdTmp = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_DESCRIBE, SQLCommand.StmtResultType.G_R_NONE, false, Restricted.Level.R4);
                cmdTmp.setOrigSQL("desc " + rawName);
                cmdTmp.setSql("desc " + rawName);
                DescribePrep forward = new DescribePrep();
                forward.handleEvent(conn, ctx, cmdTmp);
            }
            this.write(ctx, this.ansireset());
            return true;
        }
        return false;
    }

    private void describePackage(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        this.write(ctx, this.underline("Package") + "\n\n");
        Query colSQL = Info.getXMLQueries().getQuery("desc.package", conn);
        DBUtil dbUtil = DBUtil.getInstance(conn);
        this.write(ctx, this.white_black("/* Package " + dbObj.getOwner() + "." + dbObj.getName() + " */"));
        List<Map<String, ?>> procs = dbUtil.executeReturnList(colSQL.getSql(), dbObj.getBinds());
        for (Map<String, ?> proc : procs) {
            String type = "PROCEDURE";
            String owner = dbObj.getOwner();
            String name = proc.get("PROCEDURE_NAME").toString();
            ArrayList<String> argNames = new ArrayList<String>();
            ArrayList<String> argInOut = new ArrayList<String>();
            ArrayList<String> datatypes = new ArrayList<String>();
            HashMap<String, ?> binds = dbObj.getBinds();
            binds.put("OVERLOAD", proc.get("OVERLOAD") == null ? null : proc.get("OVERLOAD").toString());
            binds.put("PROC_NAME", proc.get("PROCEDURE_NAME").toString());
            Query argsSQL = Info.getXMLQueries().getQuery("desc.package.args", conn);
            List<Map<String, ?>> args = dbUtil.executeReturnList(argsSQL.getSql(), binds);
            if (args.size() > 0 && args.get(0) != null && args.get(0).get("POSITION").toString().equals("0")) {
                type = "FUNCTION";
            }
            for (Map<String, ?> arg : args) {
                argNames.add(arg.get("ARGUMENT_NAME") == null ? THE_RETURN_VALUE_OF_A_FUNCTION : arg.get("ARGUMENT_NAME").toString());
                argInOut.add(arg.get("IN_OUT") == null ? "" : arg.get("IN_OUT").toString());
                datatypes.add(arg.get("DATA_TYPE") == null ? "" : arg.get("DATA_TYPE").toString());
            }
            this.write(ctx, "\n");
            this.printProc(ctx, owner, dbObj.getName() + "." + name, type, argNames, argInOut, datatypes);
        }
        this.write(ctx, "\n\n");
    }

    private void printProc(ScriptRunnerContext ctx, String owner, String name, String type, ArrayList<String> argNames, ArrayList<String> argInOut, ArrayList<String> datatypes) {
        this.write(ctx, "/*  " + this.white(type + "  " + owner + "." + name) + "  */\n");
        String line = null;
        if (type.equals("FUNCTION")) {
            this.write(ctx, "    /*   RETURN " + this.black_white(datatypes.get(0) + "   */\n"));
            line = "     v_ret := " + owner + "." + name + "(";
        } else {
            line = "    " + owner + "." + name + "(";
        }
        this.write(ctx, line);
        int paramStart = line.length() + 1;
        if (argNames.size() == 0) {
            this.write(ctx, ");\n");
        } else {
            this.write(ctx, " ");
            if (type.equalsIgnoreCase("function")) {
                argNames.remove(0);
                argInOut.remove(0);
                datatypes.remove(0);
            }
            int width = 0;
            for (String arg : argNames) {
                if (width >= arg.length()) continue;
                width = arg.length() + 1;
            }
            for (int i = 0; i < argNames.size(); ++i) {
                if (argNames.get(i) == null) continue;
                if (i != 0) {
                    this.write(ctx, ",\n");
                    this.write(ctx, PADDING.substring(0, paramStart));
                }
                if (argNames.get(i) == null || argNames.get(i).length() <= 0 || argNames.get(i).equals(THE_RETURN_VALUE_OF_A_FUNCTION)) continue;
                line = "  " + argNames.get(i);
                line = line + "  " + PADDING.substring(0, width - argNames.get(i).length());
                line = line + "=>  p_" + argInOut.get(i).replace("/", "_") + "_param" + i + "  /*   " + this.format(datatypes.get(i)) + "   */";
                this.write(ctx, line);
            }
            this.write(ctx, ");\n");
        }
    }

    private void describeProc(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        Query colSQL = Info.getXMLQueries().getQuery("desc.plsql", conn);
        DBUtil dbUtil = DBUtil.getInstance(conn);
        String type = null;
        String owner = null;
        String name = null;
        ArrayList<String> argNames = new ArrayList<String>();
        ArrayList<String> argInOut = new ArrayList<String>();
        ArrayList<String> datatypes = new ArrayList<String>();
        List<Map<String, ?>> procs = dbUtil.executeReturnList(colSQL.getSql(), dbObj.getBinds());
        owner = dbObj.getOwner();
        name = dbObj.getName();
        type = procs.get(0).get("OBJECT_TYPE").toString();
        Query argsSQL = Info.getXMLQueries().getQuery("desc.proc.args", conn);
        List<Map<String, ?>> args = dbUtil.executeReturnList(argsSQL.getSql(), dbObj.getBinds());
        for (Map<String, ?> arg : args) {
            argNames.add(arg.get("ARGUMENT_NAME") == null ? THE_RETURN_VALUE_OF_A_FUNCTION : arg.get("ARGUMENT_NAME").toString());
            argInOut.add(arg.get("IN_OUT").toString());
            datatypes.add(arg.get("DATA_TYPE").toString());
        }
        this.printProc(ctx, owner, name, type, argNames, argInOut, datatypes);
    }

    private void describeTable(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        this.startTime();
        Query tableSQL = Info.getXMLQueries().getQuery("desc.table", conn);
        DBUtil dbUtil = DBUtil.getInstance(conn);
        this.time("Got table sql");
        List<Map<String, ?>> cols = dbUtil.executeReturnList(tableSQL.getSql(), dbObj.getBinds());
        this.time("Exec table sql");
        if (cols != null && cols.size() == 1 && cols.get(0) != null) {
            Map<String, ?> m = cols.get(0);
            this.write(ctx, this.format_reset("TABLE: " + dbObj.getName()) + " \n");
            this.write(ctx, this.format_reset("\t LAST ANALYZED:" + this.getValue(m, "LAST_ANALYZED")) + " \n");
            this.write(ctx, this.format_reset("\t ROWS         :" + this.getValue(m, "NUM_ROWS")) + " \n");
            this.write(ctx, this.format_reset("\t SAMPLE SIZE  :" + this.getValue(m, "SAMPLE_SIZE")) + " \n");
            this.write(ctx, this.format_reset("\t INMEMORY     :" + this.getValue(m, "INMEMORY")) + " \n");
            this.write(ctx, this.format_reset("\t COMMENTS     :" + this.getValue(m, "COMMENTS").replace("\n", "\n                       ")) + " \n");
            this.write(ctx, "\n");
            this.time("Print table sql");
        }
        this.write(ctx, this.format_reset("Columns") + " \n");
        Query colSQL = Info.getXMLQueries().getQuery("desc.cols", conn);
        String query = colSQL.getSql();
        Version ver = VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(conn));
        if (new Version("23").compareTo(ver) <= 0) {
            query = query.replace("-- VECTOR_INFO", "when data_type = 'VECTOR'    then     vector_info");
            query = query.replaceAll("-- DOMAIN_CASE", "|| case when domain_name is not null    then   ' DOMAIN '||domain_name else '' end");
        }
        colSQL.setSql(query);
        this.time("Got col sql");
        List<Map<String, ?>> cols2 = dbUtil.executeReturnList(colSQL.getSql(), dbObj.getBinds());
        this.time("Exec col sql");
        int widestCol = this.getWidest(cols2, "COLUMN_NAME") + 2;
        int widestData = this.getWidest(cols2, "DATA_TYPE") + 2;
        int widestLow = this.getWidest(cols2, "LOW_VALUE") + 2;
        int widestDefault = this.getWidest(cols2, "DATA_DEFAULT") + 2;
        int widestHigh = this.getWidest(cols2, "HIGH_VALUE") + 2;
        int widestDist = this.getWidest(cols2, "NUM_DISTINCT") + 2;
        int widestHist = this.getWidest(cols2, "HISTOGRAM") + 2;
        if (this.withStats) {
            String fmt = "%-" + widestCol + "s%-" + widestData + "s %-5s %-10s %-" + widestLow + "s %-" + widestHigh + "s %-" + widestDist + "s %-" + widestHist + "s\n";
            this.write(ctx, this.underline_format(fmt, "NAME", "DATA TYPE", "NULL", "DEFAULT", "LOW_VALUE", "HIGH_VALUE", "NUM_DISTINCT", "HISTOGRAM"));
            for (Map<String, ?> m : cols2) {
                if (this.getValue(m, "COLUMN_NAME").startsWith("*")) {
                    this.write(ctx, this.format("%-" + widestCol + "s", this.getValue(m, "COLUMN_NAME").trim()));
                } else {
                    this.write(ctx, String.format("%-" + widestCol + "s", this.getValue(m, "COLUMN_NAME")));
                }
                this.write(ctx, String.format("%-" + widestData + "s", this.getValue(m, "DATA_TYPE")));
                this.write(ctx, String.format(" %-5s %-" + widestDefault + "s %-" + widestLow + "s %-" + widestHigh + "s %-" + widestDist + "s %-" + widestHist + "s\n", this.getValue(m, "NULLABLE"), this.getValue(m, "DATA_DEFAULT"), this.getValue(m, "LOW_VALUE"), this.getValue(m, "HIGH_VALUE"), this.getValue(m, "NUM_DISTINCT"), this.getValue(m, "HISTOGRAM")));
            }
        } else {
            this.write(ctx, this.underline_format("%-" + widestCol + "s%-" + widestData + "s %-5s %-10s %s\n", "NAME", "DATA TYPE", "NULL", "DEFAULT", "COMMENTS"));
            for (Map<String, ?> m : cols2) {
                if (this.getValue(m, "COLUMN_NAME").startsWith("*")) {
                    this.write(ctx, this.format("%-" + widestCol + "s", this.getValue(m, "COLUMN_NAME")));
                } else {
                    this.write(ctx, String.format("%-" + widestCol + "s", this.getValue(m, "COLUMN_NAME")));
                }
                int cmtPad = widestCol + widestData + 5 + 10 + 3;
                this.write(ctx, String.format("%-" + widestData + "s", this.getValue(m, "DATA_TYPE")));
                this.write(ctx, String.format(" %-5s", this.getValue(m, "NULLABLE")));
                String default_value = this.getValue(m, "DATA_DEFAULT");
                if (default_value != null && default_value.isEmpty()) {
                    this.write(ctx, String.format(" %-" + (widestDefault - 4) + "s", this.getValue(m, "DATA_DEFAULT")));
                } else {
                    this.write(ctx, String.format(" %-" + widestDefault + "s", this.getValue(m, "DATA_DEFAULT")));
                }
                String comments = this.getValue(m, "COMMENTS");
                comments = comments.replaceAll("\\n", "");
                StringBuffer commentsBuff = comments.length() > 50 ? ScriptUtils.wordwrap(12, 50, new StringBuffer(comments), -1) : new StringBuffer(comments);
                this.write(ctx, String.format(" %s\n", commentsBuff.toString().replace(m_lineSeparator, m_lineSeparator + PADDING.substring(0, cmtPad))));
            }
        }
        this.time("printed col sql");
        this.write(ctx, this.ansireset() + "\n");
        Query idxSQL = Info.getXMLQueries().getQuery("desc.idx", conn);
        this.time("Got idx sql");
        List<List<?>> rows = dbUtil.executeReturnListofList(idxSQL.getSql(), dbObj.getBinds());
        this.time("Exec idx sql");
        if (rows != null && rows.size() > 1) {
            _listPrinter.printListofList(ctx, "Indexes", rows);
        }
        this.time("printed idx sql");
        this.write(ctx, "\n");
        Query refSQL = Info.getXMLQueries().getQuery("desc.child", conn);
        this.time("Got FK sql");
        rows = dbUtil.executeReturnListofList(refSQL.getSql(), dbObj.getBinds());
        this.time("Exec FK sql");
        if (rows != null && rows.size() > 1) {
            _listPrinter.printListofList(ctx, "References", rows);
        }
        this.time("printed FK sql");
    }

    private void describeIndex(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        this.writeObjectMetadata(conn, ctx, "INDEX", dbObj.getOwner(), dbObj.getName());
    }

    private void describeSequence(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        Query sequenceSQL = Info.getXMLQueries().getQuery("desc.sequence", conn);
        DBUtil dbUtil = DBUtil.getInstance(conn);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OBJECT_OWNER", dbObj.getOwner());
        binds.put("OBJECT_NAME", dbObj.getName());
        List<Map<String, ?>> cols = dbUtil.executeReturnList(sequenceSQL.getSql(), binds);
        this.time("Exec Sequence sql");
        if (cols != null && cols.size() == 1 && cols.get(0) != null) {
            Map<String, ?> m = cols.get(0);
            this.write(ctx, this.format_reset("SEQUENCE: " + dbObj.getName()) + " \n");
            this.write(ctx, this.format_reset("\t SEQUENCE_OWNER :" + this.getValue(m, "SEQUENCE_OWNER")) + " \n");
            this.write(ctx, this.format_reset("\t SEQUENCE_NAME  :" + this.getValue(m, "SEQUENCE_NAME")) + " \n");
            this.write(ctx, this.format_reset("\t MIN_VALUE      :" + this.getValue(m, "MIN_VALUE")) + " \n");
            this.write(ctx, this.format_reset("\t MAX_VALUE      :" + this.getValue(m, "MAX_VALUE")) + " \n");
            this.write(ctx, this.format_reset("\t INCREMENT_BY   :" + this.getValue(m, "INCREMENT_BY")) + " \n");
            this.write(ctx, this.format_reset("\t CYCLE_FLAG     :" + this.getValue(m, "CYCLE_FLAG")) + " \n");
            this.write(ctx, this.format_reset("\t ORDER_FLAG     :" + this.getValue(m, "ORDER_FLAG")) + " \n");
            this.write(ctx, this.format_reset("\t CACHE_SIZE     :" + this.getValue(m, "CACHE_SIZE")) + " \n");
            this.write(ctx, this.format_reset("\t LAST_NUMBER    :" + this.getValue(m, "LAST_NUMBER")) + " \n");
            String part = this.getValue(m, "PARTITION_COUNT");
            if ("".equals(part) || part == null) {
                part = "(null)";
            }
            this.write(ctx, this.format_reset("\t PARTITION_COUNT:" + part) + " \n");
            this.write(ctx, this.format_reset("\t SESSION_FLAG   :" + this.getValue(m, "SESSION_FLAG")) + " \n");
            this.write(ctx, this.format_reset("\t KEEP_VALUE     :" + this.getValue(m, "KEEP_VALUE")) + " \n");
            this.write(ctx, "\n");
            this.time("Print Sequence sql");
        }
    }

    private void describeType(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        this.writeObjectMetadata(conn, ctx, "TYPE", dbObj.getOwner(), dbObj.getName());
    }

    private void describeHierarchy(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        DBUtil dbUtil = DBUtil.getInstance(conn);
        this.write(ctx, this.format("HIERARCHY: " + dbObj.getName()) + " \n\n");
        this.write(ctx, this.format("Levels") + " \n");
        Query levelsSQL = Info.getXMLQueries().getQuery("desc.hierarchy.levels", conn);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OWNER", dbObj.getOwner());
        binds.put("OBJECT_NAME", dbObj.getName());
        List<Map<String, ?>> cols = dbUtil.executeReturnList(levelsSQL.getSql(), binds);
        _listPrinter.print(ctx, cols);
        this.write(ctx, this.format("References") + " \n");
        Query referencesSQL = Info.getXMLQueries().getQuery("desc.object.references", conn);
        cols = dbUtil.executeReturnList(referencesSQL.getSql(), binds);
        _listPrinter.print(ctx, cols);
    }

    private void describeAnalyticView(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        Query calculatedSQL;
        DBUtil dbUtil = DBUtil.getInstance(conn);
        this.write(ctx, this.format("ANALYTIC VIEW: " + dbObj.getName()) + " \n\n");
        Query measuresSQL = Info.getXMLQueries().getQuery("desc.analytic.view.measures", conn);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OWNER", dbObj.getOwner());
        binds.put("OBJECT_NAME", dbObj.getName());
        List<Map<String, ?>> cols = dbUtil.executeReturnList(measuresSQL.getSql(), binds);
        if (!cols.isEmpty()) {
            this.write(ctx, this.format("Measures") + " \n");
            _listPrinter.print(ctx, cols);
        }
        if (!(cols = dbUtil.executeReturnList((calculatedSQL = Info.getXMLQueries().getQuery("desc.analytic.view.calc.measures", conn)).getSql(), binds)).isEmpty()) {
            this.write(ctx, this.format("Calculated Measures") + " \n");
            _listPrinter.print(ctx, cols);
        }
        this.write(ctx, this.format("Dimensionality") + " \n");
        Query dimensionalitySQL = Info.getXMLQueries().getQuery("desc.analytic.view.dimensionality", conn);
        cols = dbUtil.executeReturnList(dimensionalitySQL.getSql(), binds);
        _listPrinter.print(ctx, cols);
        this.write(ctx, this.format("References") + " \n");
        Query referencesSQL = Info.getXMLQueries().getQuery("desc.object.references", conn);
        cols = dbUtil.executeReturnList(referencesSQL.getSql(), binds);
        _listPrinter.print(ctx, cols);
    }

    private void describeDimension(Connection conn, ScriptRunnerContext ctx, ResolvedDBObject dbObj) {
        DBUtil dbUtil = DBUtil.getInstance(conn);
        this.write(ctx, this.format("ATTRIBUTE DIMENSION: " + dbObj.getName()) + " \n\n");
        this.write(ctx, this.format("Sources") + " \n");
        Query measuresSQL = Info.getXMLQueries().getQuery("desc.dimension.sources", conn);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OWNER", dbObj.getOwner());
        binds.put("OBJECT_NAME", dbObj.getName());
        List<Map<String, ?>> cols = dbUtil.executeReturnList(measuresSQL.getSql(), binds);
        _listPrinter.print(ctx, cols);
        this.write(ctx, this.format("Attributes ") + " \n");
        Query calculatedSQL = Info.getXMLQueries().getQuery("desc.dimension.attributes", conn);
        cols = dbUtil.executeReturnList(calculatedSQL.getSql(), binds);
        _listPrinter.print(ctx, cols);
        this.write(ctx, this.format("References") + " \n");
        Query referencesSQL = Info.getXMLQueries().getQuery("desc.object.references", conn);
        cols = dbUtil.executeReturnList(referencesSQL.getSql(), binds);
        _listPrinter.print(ctx, cols);
    }

    private void writeObjectMetadata(Connection conn, ScriptRunnerContext ctx, String objectType, String owner, String objectName) {
        DBUtil dbUtil = DBUtil.getInstance(conn);
        Query argsSQL = Info.getXMLQueries().getQuery("desc.metadata", conn);
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OBJECT_TYPE", objectType);
        binds.put("OBJECT_NAME", objectName);
        binds.put("OWNER", owner);
        String metadata = dbUtil.executeReturnOneCol(argsSQL.getSql(), binds);
        this.write(ctx, metadata + "\n\n");
    }

    public void write(ScriptRunnerContext ctx, String s) {
        ctx.write(s);
        try {
            ctx.getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getValue(Map<String, ?> m, String key) {
        if (m.get(key) == null) {
            return "";
        }
        return m.get(key).toString();
    }

    public int getWidest(List<Map<String, ?>> cols, String string) {
        int ret = string.length();
        for (Map<String, ?> m : cols) {
            if (m.get(string) == null) continue;
            int l = m.get(string).toString().length();
            ret = l > ret ? (ret = l) : ret;
        }
        return ret;
    }

    public String format(String string) {
        return string;
    }

    public String format(String fmt, Object ... args) {
        return String.format(fmt, args);
    }

    public String underline_format(String fmt, Object ... args) {
        return String.format(fmt, args);
    }

    public String ansireset() {
        return "";
    }

    public String white(String string) {
        return string;
    }

    public String white_black(String string) {
        return string;
    }

    public String black_white(String string) {
        return string;
    }

    public String underline(String string) {
        return string;
    }

    public String format_reset(String string) {
        return string;
    }

    public static void setListPrinter(IListPrinter listprinter) {
        _listPrinter = listprinter;
    }
}

